/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.printprovider.gui;

import com.kingdee.bos.ctrl.kdf.printprovider.ContextOfPreview;
import com.kingdee.bos.ctrl.kdf.printprovider.IHeaderFooterPainter;
import com.kingdee.bos.ctrl.kdf.printprovider.IPainter;
import com.kingdee.bos.ctrl.kdf.printprovider.PrinterAttrManager;
import com.kingdee.bos.ctrl.kdf.printprovider.events.BodySizeChangedEvent;
import com.kingdee.bos.ctrl.kdf.printprovider.events.MediaSizeChangedEvent;
import com.kingdee.bos.ctrl.kdf.printprovider.events.OrientChangedEvent;
import com.kingdee.bos.ctrl.kdf.printprovider.events.PrintableAreaChangedEvent;
import com.kingdee.bos.ctrl.kdf.printprovider.events.PrinterAttributeListener;
import com.kingdee.bos.ctrl.kdf.printprovider.events.context.ContextEventListener;
import com.kingdee.bos.ctrl.kdf.printprovider.events.context.CurrentPageChangedEvent;
import com.kingdee.bos.ctrl.kdf.printprovider.events.context.UIStateChangedEvent;
import com.kingdee.bos.ctrl.kdf.printprovider.events.context.UpdateViewEvent;
import com.kingdee.bos.ctrl.kdf.printprovider.gui.MarginLines;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;

public abstract class AbstractPreviewPane
extends JPanel
implements PrinterAttributeListener,
ContextEventListener {
    IPainter painter;
    PrinterAttrManager printerattr;
    ContextOfPreview context;
    public MarginLines marginlines;
    BufferedImage buffer = null;
    IHeaderFooterPainter hfPainter;
    OrientationRequested orient;
    ComponentAdapter componentListener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            AbstractPreviewPane.this.updateView(AbstractPreviewPane.this.context.getTheUpdateViewEvent());
            AbstractPreviewPane.this.context.setPaneFitStyle(AbstractPreviewPane.this.context.getPaneFitStyle());
        }
    };

    public AbstractPreviewPane(PrinterAttrManager printerattr, IPainter paintProxy, ContextOfPreview context) {
        this.printerattr = printerattr;
        this.painter = paintProxy;
        this.context = context;
        this.setBackground(Color.GRAY);
        this.marginlines = new MarginLines(this, printerattr, context);
        context.addContextEventListener(this.marginlines);
        this.setPreferredSize(new Dimension((int)printerattr.getPaperWidth(), (int)printerattr.getPaperHeight()));
        printerattr.addPrinterAttributeListener(this);
        context.addContextEventListener(this);
        this.orient = printerattr.orient;
    }

    public ContextOfPreview getContext() {
        return this.context;
    }

    public void setHeaderFooterPainter(IHeaderFooterPainter hfPainter) {
        this.hfPainter = hfPainter;
    }

    public abstract int draw(Graphics2D var1, int var2);

    void drawMarginLines(Graphics2D g2) {
        Color oldColor = g2.getColor();
        Stroke oldStroke = g2.getStroke();
        float[] dash1 = new float[]{5.0f};
        BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 5.0f, dash1, 0.0f);
        g2.setStroke(dashed);
        g2.setColor(Color.BLACK);
        g2.draw(this.marginlines.getHeaderLine());
        g2.draw(this.marginlines.getFooterLine());
        g2.draw(this.marginlines.getLeftLine());
        g2.draw(this.marginlines.getRightLine());
        g2.draw(this.marginlines.getTopLine());
        g2.draw(this.marginlines.getBottomLine());
        g2.setColor(oldColor);
        g2.setStroke(oldStroke);
    }

    public void doRepaint() {
        this.buffer = null;
        this.revalidate();
        this.repaint();
    }

    @Override
    public void MediaSizeChanged(MediaSizeChangedEvent event) {
        float y;
        float x;
        if (this.orient == OrientationRequested.PORTRAIT) {
            x = event.getNewMediaSize().getX(25400) * 72.0f;
            y = event.getNewMediaSize().getY(25400) * 72.0f;
        } else {
            y = event.getNewMediaSize().getX(25400) * 72.0f;
            x = event.getNewMediaSize().getY(25400) * 72.0f;
        }
        Dimension dimNew = new Dimension((int)((double)x * this.context.getZoomFactor()), (int)((double)y * this.context.getZoomFactor()));
        this.setSize(dimNew);
        this.setPreferredSize(dimNew);
        this.getParent().setSize(dimNew);
        ((JPanel)this.getParent()).setPreferredSize(dimNew);
        this.doRepaint();
    }

    @Override
    public void OrientChanged(OrientChangedEvent event) {
        if (event.getNewOrient() == this.orient) {
            return;
        }
        float x = this.getPreferredSize().height;
        float y = this.getPreferredSize().width;
        Dimension dimNew = new Dimension((int)x, (int)y);
        this.setSize(dimNew);
        this.setPreferredSize(dimNew);
        this.getParent().setSize(dimNew);
        ((JPanel)this.getParent()).setPreferredSize(dimNew);
        this.orient = event.getNewOrient();
        this.doRepaint();
    }

    @Override
    public void PrintableAreaChange(PrintableAreaChangedEvent event) {
        this.doRepaint();
    }

    @Override
    public void BodySizeChanged(BodySizeChangedEvent rect) {
    }

    public Dimension getVisibleSize() {
        Dimension viewsize = null;
        if (this.getParent() != null && this.getParent().getParent() instanceof JViewport) {
            viewsize = ((JViewport)this.getParent().getParent()).getSize();
        }
        return viewsize;
    }

    public ComponentListener getComponentListener() {
        return this.componentListener;
    }

    @Override
    public void currentPageChanged(CurrentPageChangedEvent event) {
        this.doRepaint();
    }

    @Override
    public void uiStateChanged(UIStateChangedEvent event) {
        this.doRepaint();
    }

    @Override
    public void updateView(UpdateViewEvent event) {
        float x = this.printerattr.getPaperWidth();
        float y = this.printerattr.getPaperHeight();
        Dimension dimNew = new Dimension((int)((double)x * this.context.getZoomFactor()) + 4, (int)((double)y * this.context.getZoomFactor()) + 4);
        if (this.getParent() != null && this.getParent().getParent() instanceof JViewport) {
            Dimension viewsize = ((JViewport)this.getParent().getParent()).getSize();
            if (dimNew.width < viewsize.width && dimNew.height < viewsize.height) {
                dimNew.setSize(viewsize.width - 12, viewsize.height);
            }
        }
        this.setSize(dimNew);
        this.setPreferredSize(dimNew);
        if (this.getParent() != null) {
            this.getParent().setSize(dimNew);
            ((JPanel)this.getParent()).setPreferredSize(dimNew);
        }
        this.doRepaint();
    }

    class MyGlassPane
    extends JComponent
    implements ItemListener {
        private static final long serialVersionUID = -6598262472174921543L;
        Point point = new Point(50, 50);

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.setVisible(e.getStateChange() == 1);
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.point != null) {
                g.setColor(Color.red);
                g.fillOval(this.point.x - 10, this.point.y - 10, 20, 20);
            }
        }

        public void setPoint(Point p) {
            this.point = p;
        }
    }
}

