/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.proxy;

import com.kingdee.bos.ctrl.kdf.expr.Variant;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

public class JavaDataOutput
extends DataOutputStream {
    JavaDataOutput(OutputStream out) {
        super(out);
    }

    public void writeDate(Date val) throws IOException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(val);
        super.writeShort(calendar.get(1));
        super.writeByte(calendar.get(2) + 1);
        super.writeByte(calendar.get(5));
        super.writeByte(calendar.get(11));
        super.writeByte(calendar.get(12));
        super.writeByte(calendar.get(13));
    }

    public void writeDecimal(BigDecimal val) throws IOException {
        this.writeString(val.toString());
    }

    public void writeString(String val) throws IOException {
        super.writeInt(val.length());
        super.writeChars(val);
    }

    public void writeVariant(Variant var) throws IOException {
        this.writeShort(var.getVt());
        switch ((short)var.getVt()) {
            case 3: {
                super.writeInt((Integer)var.getValue());
                break;
            }
            case 2: {
                super.writeShort(((Short)var.getValue()).shortValue());
                break;
            }
            case 5: {
                super.writeFloat(((Float)var.getValue()).floatValue());
                break;
            }
            case 6: {
                super.writeDouble((Double)var.getValue());
                break;
            }
            case 8: {
                super.writeBoolean((Boolean)var.getValue());
                break;
            }
            case 10: {
                this.writeDecimal((BigDecimal)var.getValue());
                break;
            }
            case 12: {
                this.writeDate((Date)var.getValue());
                break;
            }
            case 11: {
                this.writeString((String)var.getValue());
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                super.writeByte(((Byte)var.getValue()).byteValue());
                break;
            }
            case 4: {
                super.writeLong((Long)var.getValue());
            }
        }
    }
}

