/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.server;

import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.server.FormBuilder;
import com.kingdee.bos.ctrl.kdf.server.FormPageEventQueue;
import com.kingdee.bos.ctrl.kdf.server.FormPageInfo;
import com.kingdee.bos.ctrl.kdf.server.IFormOutput;
import com.kingdee.bos.ctrl.kdf.server.IORMForm;
import com.kingdee.bos.ctrl.kdf.server.IServerPluginParam;
import com.kingdee.bos.ctrl.kdf.server.IVariantDataListener;
import com.kingdee.bos.ctrl.kdf.server.SerialNumber;
import com.kingdee.bos.ctrl.kdf.util.file.KDFXmlReader;
import com.kingdee.bos.orm.impl.server.TCPServer;
import com.kingdee.bos.orm.template.ORMObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class ORMFormServer
extends ORMObject
implements IORMForm,
IFormOutput,
Runnable {
    private FormPageInfo formPageInfo;
    private byte[] kdf;
    private int kdfID = SerialNumber.getInstance().getSerial();
    private IServerPluginParam[] plugins;
    private KDFXmlReader reader;
    private FormBuilder formBuilder;
    private boolean isPrepared = false;
    private Thread thread;
    private IVariantDataListener vdataListener;
    private Object userFuncObj;
    private HashMap reportParams;

    public ORMFormServer() {
        super(null);
        super.registerInterface(IORMForm.class, (Object)this);
    }

    @Override
    public void obtainPage(int pageIndex, Page page) {
        FormPageEventQueue.getInstance().addPageEvent(this.kdfID, pageIndex, page);
    }

    @Override
    public void endOutput() {
        FormPageEventQueue.getInstance().addFormEndEvent(this.kdfID);
    }

    @Override
    public int getKDFID() {
        return this.kdfID;
    }

    @Override
    public void setPlugins(IServerPluginParam[] plugins) {
        this.plugins = plugins;
    }

    @Override
    public void setPageInfo(FormPageInfo info) {
        this.formPageInfo = info;
    }

    @Override
    public void setKDF(byte[] kdf) {
        this.kdf = kdf;
    }

    @Override
    public Object[] prepareForm() {
        this.isPrepared = true;
        this.reader = new KDFXmlReader(new ByteArrayInputStream(this.kdf));
        this.formBuilder = new FormBuilder(this.kdfID);
        this.formBuilder.setCallBack(this);
        this.formBuilder.setVariantDataListener(this.vdataListener);
        this.formBuilder.setUserFunctionProvider(this.userFuncObj);
        this.formBuilder.setReportParams(this.reportParams);
        return this.formBuilder.prepareForm(this.reader, this.plugins);
    }

    @Override
    public void makeForm() {
        if (!this.isPrepared) {
            this.reader = new KDFXmlReader(new ByteArrayInputStream(this.kdf));
            this.formBuilder = new FormBuilder(this.kdfID);
            this.formBuilder.setCallBack(this);
            this.formBuilder.setVariantDataListener(this.vdataListener);
            this.formBuilder.setUserFunctionProvider(this.userFuncObj);
            this.formBuilder.setReportParams(this.reportParams);
            this.formBuilder.prepareForm(this.reader, this.plugins);
        }
        this.isPrepared = false;
        this.thread = new Thread(this);
        this.thread.start();
    }

    @Override
    public void run() {
        this.formBuilder.makeForm(this.formPageInfo, this.reader, this.plugins);
        if (Thread.currentThread().isInterrupted()) {
            FormPageEventQueue.getInstance().remove(this.kdfID);
        }
        this.formPageInfo = null;
        this.kdf = null;
        this.plugins = null;
        this.reader = null;
        this.formBuilder = null;
        this.vdataListener = null;
        this.userFuncObj = null;
    }

    @Override
    public void cancelJob(Thread worker) {
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) throws IOException {
        int port = 11034;
        String path = System.getProperty("user.dir");
        String file = path + File.separator + "lib" + File.separator + "log4j.properties";
        System.setProperty("log4j.configuration", file);
        new TCPServer(port).start();
    }

    @Override
    public void setVariantDataListener(IVariantDataListener listener) {
        this.vdataListener = listener;
    }

    @Override
    public void setUserFunctionProvider(Object obj) {
        this.userFuncObj = obj;
    }

    @Override
    public void setReportParams(HashMap params) {
        this.reportParams = params;
    }

    @Override
    public void setKDF(InputStream kdfStream) {
        throw new AssertionError((Object)"Remote Mode do not support Stream Input");
    }
}

