/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.batchaction;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BatchActionEnum
implements Serializable {
    private static final long serialVersionUID = -5618348725735893196L;
    public static final BatchActionEnum AUDIT = new BatchActionEnum("AUDIT");
    public static final BatchActionEnum UNAUDIT = new BatchActionEnum("UNAUDIT");
    public static final BatchActionEnum DELETE = new BatchActionEnum("DELETE");
    public static final BatchActionEnum CANCEL = new BatchActionEnum("CANCEL");
    public static final BatchActionEnum ADDNEW = new BatchActionEnum("ADDNEW");
    public static final BatchActionEnum VOUCHER = new BatchActionEnum("VOUCHER");
    public static final BatchActionEnum UNVOUCHER = new BatchActionEnum("UNVOUCHER");
    public static final BatchActionEnum CLOSE = new BatchActionEnum("CLOSE", ActionLevelEnum.ENTRY);
    public static final BatchActionEnum FREEZE = new BatchActionEnum("FREEZE", ActionLevelEnum.ENTRY);
    public static final BatchActionEnum UNFREEZE = new BatchActionEnum("UNFREEZE", ActionLevelEnum.ENTRY);
    public static final BatchActionEnum MULTIPRINT = new BatchActionEnum("PRINT", true);
    public static final BatchActionEnum MULTIPRINTPREVIEW = new BatchActionEnum("PRINTPREVIEW", true);
    public static final BatchActionEnum UNCLOSE = new BatchActionEnum("UNCLOSE", ActionLevelEnum.ENTRY);
    public static final BatchActionEnum SUBMIT = new BatchActionEnum("SUBMIT");
    public static final BatchActionEnum ENTRYAUDIT = new BatchActionEnum("AUDIT", ActionLevelEnum.ENTRY);
    public static final BatchActionEnum SAVE = new BatchActionEnum("SAVE");
    public static final BatchActionEnum FIRST = new BatchActionEnum("FIRST");
    public static final BatchActionEnum PREVIOUS = new BatchActionEnum("PREVIOUS");
    public static final BatchActionEnum NEXT = new BatchActionEnum("NEXT");
    public static final BatchActionEnum LAST = new BatchActionEnum("LAST");
    public static final BatchActionEnum TRANSFORM = new BatchActionEnum("TRANSFORM");
    public static final BatchActionEnum RECEIVE = new BatchActionEnum("RECEIVE");
    public static final BatchActionEnum PAY = new BatchActionEnum("PAY");
    public static final BatchActionEnum ENTRYRELEASE = new BatchActionEnum("ENTRYRELEASE", ActionLevelEnum.ENTRY);
    public static final BatchActionEnum ENTRYUNRELEASE = new BatchActionEnum("ENTRYUNRELEASE", ActionLevelEnum.ENTRY);
    public static final BatchActionEnum CLOSEAR = new BatchActionEnum("UNCLOSEAR", ActionLevelEnum.ENTRY);
    public static final BatchActionEnum UNCLOSEAR = new BatchActionEnum("UNCLOSEAR", ActionLevelEnum.ENTRY);
    public static final BatchActionEnum CREATEAS = new BatchActionEnum("CREATEAS", ActionLevelEnum.ENTRY);
    public static final BatchActionEnum ENABLE = new BatchActionEnum("ENABLE");
    public static final BatchActionEnum DISABLE = new BatchActionEnum("DISABLE");
    public static final BatchActionEnum ALTER = new BatchActionEnum("ALTER");
    public static final BatchActionEnum REVERSE = new BatchActionEnum("REVERSE");
    private static List entryActionList = new ArrayList();
    private String bizAction = null;
    private String name;
    private ActionLevelEnum actionLevel = ActionLevelEnum.HEAD;
    private boolean isOnlyInClient = false;
    private static Map actions;
    private static boolean initiated;

    private static synchronized void initiate(Context ctx) throws BOSException, EASBizException {
        if (initiated) {
            return;
        }
        actions = ctx != null ? BatchActionFactory.getLocalInstance(ctx).getAllBatchActionEnum() : BatchActionFactory.getRemoteInstance().getAllBatchActionEnum();
        initiated = true;
    }

    public static BatchActionEnum getBatchActionEnum(Context ctx, String action) throws BOSException, EASBizException {
        if (!initiated) {
            BatchActionEnum.initiate(ctx);
        }
        return (BatchActionEnum)actions.get(action.toUpperCase());
    }

    public static ActionLevelEnum getDefaultLevel(String action) {
        return entryActionList.contains(action.toUpperCase()) ? ActionLevelEnum.ENTRY : ActionLevelEnum.HEAD;
    }

    public BatchActionEnum(String bizAction, boolean isOnlyInClient) {
        this(bizAction);
        this.isOnlyInClient = isOnlyInClient;
    }

    public BatchActionEnum(String bizAction, int actionLevel, boolean isOnlyInClient, String name) {
        this.bizAction = bizAction;
        this.actionLevel = actionLevel == 0 ? ActionLevelEnum.HEAD : ActionLevelEnum.ENTRY;
        this.isOnlyInClient = isOnlyInClient;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public BatchActionEnum(String bizAction, ActionLevelEnum actionLevel) {
        this(bizAction);
        this.actionLevel = actionLevel;
    }

    public BatchActionEnum(String bizAction) {
        this.bizAction = bizAction;
    }

    public ActionLevelEnum getActionLevel() {
        return this.actionLevel;
    }

    public String getBizAction() {
        return this.bizAction;
    }

    public boolean isOnlyClient() {
        return this.isOnlyInClient;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof BatchActionEnum) {
            BatchActionEnum action = (BatchActionEnum)arg0;
            return this.getBizAction().equals(action.getBizAction()) && this.actionLevel.equals(action.getActionLevel());
        }
        return false;
    }

    public int hashCode() {
        return this.getBizAction().hashCode() * 10 + this.actionLevel.hashCode();
    }

    static {
        entryActionList.add(BatchActionEnum.CLOSE.bizAction);
        entryActionList.add(BatchActionEnum.FREEZE.bizAction);
        entryActionList.add(BatchActionEnum.UNCLOSE.bizAction);
        entryActionList.add(BatchActionEnum.UNFREEZE.bizAction);
        entryActionList.add(BatchActionEnum.ENTRYRELEASE.bizAction);
        entryActionList.add(BatchActionEnum.ENTRYUNRELEASE.bizAction);
    }
}

