/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.batchaction.app;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.IBatchAction;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class BatchActionFacade
extends AbstractBOSObject
implements IBatchAction {
    static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"BATFAC");

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    public BatchActionFacade() {
        this.registerInterface(IBatchAction.class, this);
    }

    public BatchActionFacade(Context ctx) {
        super(ctx);
        this.registerInterface(IBatchAction.class, this);
    }

    @Override
    public Map getAllBatchActionEnum() throws BOSException, EASBizException {
        HashMap<String, BatchActionEnum> actions = new HashMap<String, BatchActionEnum>();
        String fieldName = "FName_" + this.getLanguage(this.getContext());
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT FBizAction,FActionLevel,FIsOnlyInClient," + fieldName + " FROM T_BAS_BatchAction"));
        try {
            while (rs.next()) {
                String action = rs.getString("FBizAction");
                int level = rs.getInt("FActionLevel");
                boolean isOnlyClient = rs.getBoolean("FIsOnlyInClient");
                String name = rs.getString(fieldName);
                BatchActionEnum actionEnum = new BatchActionEnum(action, level, isOnlyClient, name);
                actions.put(action.toUpperCase(), actionEnum);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return actions;
    }

    private String getLanguage(Context ctx) {
        Locale locale = ctx.getLocale();
        String language = locale.getLanguage();
        return language.toUpperCase();
    }
}

