/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.console.ui.dbcenter;

import com.kingdee.bos.bi.model.ui.content.ContentTable;
import com.kingdee.bos.bi.model.ui.resource.Resource;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.client.CoreUI;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class AbstractDBCenterListUI
extends CoreUI {
    private static final long serialVersionUID = 3678686821025859446L;
    protected static final Logger log = CoreUIObject.getLogger(AbstractDBCenterListUI.class);
    protected static final String TITLE_BI_DATA_CENTER = "BI\u7ba1\u63a7\u4e2d\u5fc3\u2014\u6570\u636e\u4e2d\u5fc3";
    protected ContentTable tblMain = null;
    private ActionListener refreshActionListener = null;
    private ActionListener addActionListener = null;
    private ActionListener editActionListener = null;
    private ActionListener viewActionListener = null;
    private ActionListener delActionListener = null;
    private ActionListener useActionListener = null;
    private ActionListener testActionListener = null;

    public AbstractDBCenterListUI() throws Exception {
        this.loadListener();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUITitle(TITLE_BI_DATA_CENTER);
    }

    public void initUIContentLayout() {
        this.setLayout((LayoutManager)new TableLayout2(1, 1));
        this.add((Component)((Object)this.getTblMain()), TableLayout2.param((int)0, (int)0));
    }

    protected ContentTable getTblMain() {
        if (this.tblMain == null) {
            this.tblMain = new ContentTable();
            this.tblMain.getIndexColumn().getStyleAttributes().setHided(false);
            this.tblMain.setHorizonGridLineVisible(true);
            this.tblMain.setVerticalGridLineVisible(true);
            this.tblMain.addColumns(new String[]{"ID", "DBCENTERNAME", "BIZTYPE", "DBTYPE", "URLPORT", "DBNAME", "DBUSERNAME", "USEFLAG", "CREATOR", "LASTUPDATE"});
            this.tblMain.setHeadText("ID", "ID");
            this.tblMain.setHeadText("DBCENTERNAME", "\u6570\u636e\u4e2d\u5fc3\u540d\u79f0");
            this.tblMain.setHeadText("BIZTYPE", "\u4e1a\u52a1\u7c7b\u578b");
            this.tblMain.setHeadText("DBTYPE", "\u6570\u636e\u5e93\u7c7b\u578b");
            this.tblMain.setHeadText("URLPORT", "\u6570\u636e\u5e93\u5730\u5740");
            this.tblMain.setHeadText("DBNAME", "\u6570\u636e\u5e93\u540d\u79f0");
            this.tblMain.setHeadText("DBUSERNAME", "\u6570\u636e\u5e93\u7528\u6237");
            this.tblMain.setHeadText("USEFLAG", "\u542f\u7528\u72b6\u6001");
            this.tblMain.setHeadText("CREATOR", "\u521b\u5efa\u4eba");
            this.tblMain.setHeadText("LASTUPDATE", "\u6700\u540e\u4fee\u6539\u65f6\u95f4");
            this.tblMain.setColumnWidth("ID", 0);
            this.tblMain.setColumnWidth("DBCENTERNAME", 150);
            this.tblMain.setColumnWidth("BIZTYPE", 100);
            this.tblMain.setColumnWidth("DBTYPE", 100);
            this.tblMain.setColumnWidth("URLPORT", 150);
            this.tblMain.setColumnWidth("DBNAME", 100);
            this.tblMain.setColumnWidth("DBUSERNAME", 100);
            this.tblMain.setColumnWidth("USEFLAG", 80);
            this.tblMain.setColumnWidth("CREATOR", 100);
            this.tblMain.setColumnWidth("LASTUPDATE", 170);
            this.tblMain.setParent((Component)((Object)this));
            this.tblMain.getStyleAttributes().setLocked(true);
        }
        return this.tblMain;
    }

    public void initUIMenuBarLayout() {
        this.menuBar.add((JMenu)this.menuFile);
        this.menuBar.add((JMenu)this.menuTool);
        this.menuBar.add((JMenu)this.menuHelp);
        this.menuFile.add((Component)this.kDSeparator1);
        this.menuFile.add((JMenuItem)this.menuItemPageSetup);
        this.menuFile.add((JMenuItem)this.menuItemExitCurrent);
        this.menuTool.add((JMenuItem)this.menuItemSendMessage);
        this.menuTool.add((JMenuItem)this.menuItemCalculator);
        this.menuHelp.add((JMenuItem)this.menuItemHelp);
        this.menuHelp.add((Component)this.kDSeparator12);
        this.menuHelp.add((JMenuItem)this.menuItemRegPro);
        this.menuHelp.add((JMenuItem)this.menuItemPersonalSite);
        this.menuHelp.add((Component)this.helpseparatorDiv);
        this.menuHelp.add((JMenuItem)this.menuitemProductval);
        this.menuHelp.add((Component)this.kDSeparatorProduct);
        this.menuHelp.add((JMenuItem)this.menuItemAbout);
    }

    public void initUIToolBarLayout() {
        this.toolBar.add((Component)this.btnPageSetup);
        this.toolBar.add(this.getWorkButtton("\u5237\u65b0", this.refreshActionListener, Resource.ICON_REFRESH));
        this.toolBar.add(this.getWorkButtton("\u65b0\u5efa", this.addActionListener, Resource.ICON_NEW_FILE));
        this.toolBar.add(this.getWorkButtton("\u7f16\u8f91", this.editActionListener, Resource.ICON_EDIT));
        this.toolBar.add(this.getWorkButtton("\u67e5\u770b", this.viewActionListener, Resource.ICON_ATTIBUTE));
        this.toolBar.add(this.getWorkButtton("\u5220\u9664", this.delActionListener, Resource.ICON_DELETE));
        this.toolBar.add(this.getWorkButtton("\u6d4b\u8bd5\u8fde\u63a5", this.testActionListener, Resource.ICON_TEST_DBCENTER));
        this.toolBar.add(this.getWorkButtton("\u542f\u7528", this.useActionListener, Resource.ICON_STARTUSE));
    }

    private Component getWorkButtton(String text, ActionListener actionListener, ImageIcon icon) {
        KDWorkButton button = new KDWorkButton(text);
        button.setIcon((Icon)icon);
        button.setToolTipText(text);
        button.addActionListener(actionListener);
        return button;
    }

    protected void loadListener() {
        this.refreshActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDBCenterListUI.this.action_refresh();
            }
        };
        this.addActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDBCenterListUI.this.action_addNew();
            }
        };
        this.editActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDBCenterListUI.this.action_edit(AbstractDBCenterListUI.this.checkTableSingleSelection("\u7f16\u8f91" + AbstractDBCenterListUI.this.getUITitle()));
            }
        };
        this.viewActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDBCenterListUI.this.action_view(AbstractDBCenterListUI.this.checkTableSingleSelection("\u67e5\u770b" + AbstractDBCenterListUI.this.getUITitle()));
            }
        };
        this.delActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDBCenterListUI.this.action_del(AbstractDBCenterListUI.this.checkTableSingleSelection("\u5220\u9664" + AbstractDBCenterListUI.this.getUITitle()));
            }
        };
        this.useActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDBCenterListUI.this.action_use(AbstractDBCenterListUI.this.checkTableSingleSelection("\u542f\u7528" + AbstractDBCenterListUI.this.getUITitle()));
            }
        };
        this.testActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDBCenterListUI.this.action_test(AbstractDBCenterListUI.this.checkTableSingleSelection("\u6d4b\u8bd5" + AbstractDBCenterListUI.this.getUITitle()));
            }
        };
        this.getTblMain().addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (SwingUtilities.isLeftMouseButton((MouseEvent)e) && e.getClickCount() == 2 && e.getType() == 1) {
                    AbstractDBCenterListUI.this.doDoubleClickTable(e);
                }
            }
        });
        this.getTblMain().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int rowIndx = ((ContentTable)((Object)e.getSource())).getSelectionRow();
                if (rowIndx >= 0) {
                    AbstractDBCenterListUI.this.selChanged(AbstractDBCenterListUI.this.getRowAttrs(rowIndx));
                }
            }
        });
    }

    protected void selChanged(Map rowAttrs) {
        String status = (String)rowAttrs.get("USEFLAG");
        Component comp = null;
        for (int i = this.toolBar.getComponentCount() - 1; i >= 0; --i) {
            comp = this.toolBar.getComponent(i);
            if (!(comp instanceof KDWorkButton) || ((KDWorkButton)comp).getActionListeners()[0] != this.useActionListener) continue;
            this.changePublishButtonStatus(status, (AbstractButton)((KDWorkButton)comp));
            break;
        }
    }

    protected void doDoubleClickTable(KDTMouseEvent e) {
        this.action_view(e.getRowIndex());
    }

    protected void action_refresh() {
        this.doRefresh(-1);
    }

    protected abstract void doRefresh(int var1);

    protected void action_addNew() {
        this.doAddNew();
        this.doRefresh(0);
    }

    protected abstract void doAddNew();

    protected void action_edit(int rowIdx) {
        if (rowIdx >= 0 && this.doEdit(this.getRowID(rowIdx), this.getRowName(rowIdx), this.getRowUseFlag(rowIdx))) {
            this.doRefresh(0);
        }
    }

    protected abstract boolean doEdit(String var1, String var2, boolean var3);

    protected void action_view(int rowIdx) {
        if (rowIdx >= 0) {
            this.doView(this.getRowID(rowIdx), this.getRowName(rowIdx));
        }
    }

    protected abstract void doView(String var1, String var2);

    protected void action_del(int rowIdx) {
        if (rowIdx >= 0 && this.doDel(this.getRowID(rowIdx), this.getRowName(rowIdx), this.getRowUseFlag(rowIdx))) {
            this.doRefresh(-1);
        }
    }

    protected abstract boolean doDel(String var1, String var2, boolean var3);

    protected void action_test(int rowIdx) {
        if (rowIdx >= 0) {
            this.doTest(this.getRowID(rowIdx), this.getRowName(rowIdx), this.getRowUseFlag(rowIdx));
        }
    }

    protected abstract void doTest(String var1, String var2, boolean var3);

    protected void action_use(int rowIdx) {
        if (rowIdx >= 0 && this.doEnable(this.getRowID(rowIdx), !this.getRowUseFlag(rowIdx))) {
            this.doRefresh(rowIdx);
        }
    }

    protected abstract boolean doEnable(String var1, boolean var2);

    public boolean destroyWindow() {
        return super.destroyWindow();
    }

    private int checkTableSingleSelection(String title) {
        int idx = this.getTblMain().getSelectionRow();
        if (idx < 0) {
            WindowUtil.msgboxInfo((Object)"\u8bf7\u5728\u5217\u8868\u4e2d\u9009\u4e2d\u64cd\u4f5c\u7684\u76ee\u6807\u884c\u3002", (String)title, (Component)((Object)this.getTblMain()));
            return -1;
        }
        if (this.getTblMain().getSelectManager().getBlocks().size() > 1) {
            WindowUtil.msgboxInfo((Object)"\u8bf7\u5355\u9009\u64cd\u4f5c\u7684\u76ee\u6807\u884c\u3002", (String)title, (Component)((Object)this.getTblMain()));
            return -1;
        }
        return idx;
    }

    protected String getRowID(int r) {
        return (String)this.getRowAttrs(r).get("ID");
    }

    protected HashMap getRowAttrs(int r) {
        return (HashMap)this.getTblMain().getRowUserObject(r);
    }

    protected String getRowName(int r) {
        return (String)this.getRowAttrs(r).get("DBCENTERNAME");
    }

    protected boolean getRowUseFlag(int r) {
        return "1".equalsIgnoreCase((String)this.getRowAttrs(r).get("USEFLAG"));
    }

    void changePublishButtonStatus(String status, AbstractButton button) {
        if ("1".equalsIgnoreCase(status)) {
            button.setText("\u7981\u7528");
            button.setIcon(Resource.ICON_FORBID);
        } else {
            button.setText("\u542f\u7528");
            button.setIcon(Resource.ICON_STARTUSE);
        }
    }
}

