/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.bireport;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.common.bireport.ICellElement;
import com.kingdee.bos.bi.model.common.bireport.IOLAPMember;
import com.kingdee.bos.bi.model.rt.bireport.BIReportMDXUtils;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.util.StringUtil;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;

public class DimensionMember
implements IOLAPMember,
ICellElement,
Serializable {
    private boolean isCalculator;
    private String name;
    private Dimension dim;
    private String alias;
    private String expr;
    private static final long serialVersionUID = 8254092256559417725L;

    public DimensionMember(Dimension dim, String name, String alias, boolean isCalculator) {
        this.dim = dim;
        this.name = name;
        this.alias = alias;
        this.isCalculator = isCalculator;
    }

    public boolean isCalculator() {
        return this.isCalculator;
    }

    public Dimension getDimension() {
        return this.dim;
    }

    @Override
    public String toMDX(Context ctx) {
        DimensionType dimType = this.dim.getDimensionDef().getDimensionType();
        StringBuffer sb = new StringBuffer();
        sb.append("[").append(dimType.getMdxName()).append("].");
        try {
            sb.append(this.toUniqueName(ctx));
        }
        catch (SQLException e) {
            return StringUtil.getNullString();
        }
        return sb.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toUniqueName(Context ctx) throws SQLException {
        int n;
        if (this.isCalculator) {
            return BIReportMDXUtils.addSquareBrackets(this.name);
        }
        if (this.dim.getDimensionDef().getDimensionType().isTime()) {
            return BIReportMDXUtils.addAllSquareBrackets(this.name);
        }
        StringBuffer sb = new StringBuffer();
        List lstPath = this.dim.findFullPath(this.name, ctx);
        for (int i = n = lstPath.size() - 1; i >= 0; --i) {
            if (i < n) {
                sb.append(".");
            }
            sb.append(BIReportMDXUtils.addSquareBrackets((String)lstPath.get(i)));
        }
        return sb.toString();
    }

    @Override
    public String getType() {
        return "member";
    }

    public String toString() {
        return this.alias;
    }

    @Override
    public String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<Item type=\"" + this.getType() + "\" isCalculator=\"" + this.isCalculator + "\">");
        sb.append("<name>").append("<![CDATA[" + this.name + "]]>").append("</name>");
        sb.append("<alias>").append("<![CDATA[" + this.alias + "]]>").append("</alias>");
        sb.append("<expr>").append("<![CDATA[" + this.expr + "]]>").append("</expr>");
        sb.append("</Item>");
        return sb.toString();
    }
}

