/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.mm.general.importscheme;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.common.mm.commonfilter.CommonFilterEnum;
import com.kingdee.bos.bi.model.common.mm.commonfilter.CommonFilterModel;
import com.kingdee.bos.bi.model.common.mm.customdim.GeneralDimProperty;
import com.kingdee.bos.bi.model.common.mm.general.Filtering;
import com.kingdee.bos.bi.model.common.mm.general.GeneralDimensionNode;
import com.kingdee.bos.bi.model.common.mm.general.GeneralModel;
import com.kingdee.bos.bi.model.common.mm.general.db.Column;
import com.kingdee.bos.bi.model.common.mm.general.importscheme.SchemeModel;
import com.kingdee.bos.bi.model.common.mm.general.importscheme.SchemeUtil;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.dao.query.EntityExecutorFactory;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SchemeDataProvider {
    protected static final Logger log = CommonLogger.getLogger(SchemeDataProvider.class);
    static int i = 0;

    public static GeneralDimensionNode[] getSchemeData(String schemeId, String dimNumber, Map updateParams, IManagementFacade facade) throws SQLException, BOSException {
        SchemeModel schemeModel;
        String type;
        List customDefineAttributeList = GeneralDimensionNode.loadAttributeList(dimNumber, facade);
        if (updateParams != null) {
            String viewd = (String)updateParams.get("viewId");
            String selectNodeNumber = (String)updateParams.get("selectNodeNumber");
            SchemeDataProvider.updateLastImportSchemeId(facade, viewd, schemeId, selectNodeNumber);
        }
        if ("entity".equalsIgnoreCase(type = (schemeModel = SchemeModel.load(dimNumber, schemeId, facade)).getType())) {
            return SchemeDataProvider.getEntityData(facade, schemeModel, customDefineAttributeList, dimNumber);
        }
        if ("query".equalsIgnoreCase(type)) {
            return SchemeDataProvider.getQueryData(facade, schemeModel, customDefineAttributeList, dimNumber);
        }
        if ("table".equalsIgnoreCase(type)) {
            return SchemeDataProvider.getTableData(facade, schemeModel, customDefineAttributeList, dimNumber);
        }
        if ("dbTable".equalsIgnoreCase(type)) {
            return SchemeDataProvider.getDBTableData(facade, schemeModel, customDefineAttributeList, dimNumber);
        }
        if ("sql".equalsIgnoreCase(type)) {
            return SchemeDataProvider.getSQLData(facade, schemeModel, customDefineAttributeList, dimNumber);
        }
        return null;
    }

    private static void updateLastImportSchemeId(IManagementFacade facade, String viewId, String schemeId, String selectNodeNumber) throws SQLException {
        String sql = "update T_BI_CSTM_List set FLastISchemeID='" + schemeId + "',FLastISchemeNodeNumber='" + selectNodeNumber + "' where FID='" + viewId + "'";
        facade.executeUpdate(sql);
    }

    public static GeneralDimensionNode[] getEntityData(IManagementFacade facade, SchemeModel schemeModel, List customDefineAttributeList, String dimNumber) throws BOSException, SQLException {
        String pkFullName = schemeModel.getMetaDataFullName();
        MetaDataPK pk = new MetaDataPK(pkFullName);
        Context ctx = facade.getContext();
        EntityObjectInfo entityObjectInfo = MetaDataLoader.getEntity((Context)ctx, (IMetaDataPK)pk);
        IDataProvider entityExecutor = EntityExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
        Map mapping = schemeModel.getMappings();
        Filtering filtering = schemeModel.getFiltering();
        PropertyCollection collection = SchemeUtil.getEntityPropertyCollection(entityObjectInfo);
        entityExecutor.setObjectView(SchemeDataProvider.getEntityView(collection, mapping, filtering));
        System.out.println(entityExecutor.getSQL());
        IRowSet rs = entityExecutor.executeQuery();
        return SchemeDataProvider.getGeneralDimensionNodeArray(rs, mapping, customDefineAttributeList, dimNumber);
    }

    private static Map getEntityUsedFieldMap(Map mapping, Filtering filtering) {
        HashMap map = new HashMap();
        if (mapping != null) {
            Map.Entry entry2 = null;
            for (Map.Entry entry2 : mapping.entrySet()) {
                map.put(entry2.getValue(), entry2.getKey());
            }
        }
        if (filtering != null) {
            if (filtering.getCuEnabled()) {
                map.put(filtering.getFilterField(), Integer.toString(filtering.getAdminUint().size()));
            }
            CommonFilterModel fm2 = null;
            for (CommonFilterModel fm2 : filtering.getCommonFilter()) {
                map.put(fm2.getField(), fm2.getValue());
            }
        }
        return map;
    }

    public static EntityViewInfo getEntityView(PropertyCollection collection, Map mapping, Filtering filtering) {
        Map usedFieldMap = SchemeDataProvider.getEntityUsedFieldMap(mapping, filtering);
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        entityView.setFilter(filterInfo);
        PropertyInfo propertyInfo2 = null;
        String realName = null;
        String propName = null;
        for (PropertyInfo propertyInfo2 : collection) {
            propName = propertyInfo2.getName();
            if (usedFieldMap.size() > 0 && usedFieldMap.get(propName.toUpperCase()) == null) continue;
            if (propertyInfo2 instanceof LinkPropertyInfo) {
                RelationshipInfo relationShip = (RelationshipInfo)propertyInfo2.get("relationship");
                EntityObjectInfo anotherEntityObject = relationShip.getSupplierObject();
                PropertyCollection propertyCollection = ((LogicalKeyInfo)anotherEntityObject.get("logicalKey")).getKeyPropertys();
                for (PropertyInfo pInfo : propertyCollection) {
                    realName = propName + "." + pInfo.getName();
                    entityView.getSelector().add(new SelectorItemInfo(realName, propName));
                    log.info((Object)(SchemeDataProvider.class.getClass().getName() + ",realName=" + realName));
                }
                continue;
            }
            entityView.getSelector().add(new SelectorItemInfo(propName));
        }
        SchemeDataProvider.setFilterInfo(filterInfo, filtering);
        return entityView;
    }

    private static void setFilterInfo(FilterInfo filterInfo, Filtering filtering) {
        if (filtering == null) {
            return;
        }
        StringBuffer formatSB = new StringBuffer();
        String compareValue = null;
        CompareType compareType = null;
        CommonFilterModel fm2 = null;
        for (CommonFilterModel fm2 : filtering.getCommonFilter()) {
            if (CommonFilterEnum.COMPARISON_OPERATOR_LIKE.equalsIgnoreCase(fm2.getCompare())) {
                compareType = CompareType.getEnum((String)CommonFilterEnum.COMPARISON_OPERATOR_LIKE);
                compareValue = "%" + fm2.getValue() + "%";
            } else if ("left like".equalsIgnoreCase(fm2.getCompare())) {
                compareType = CompareType.getEnum((String)CommonFilterEnum.COMPARISON_OPERATOR_LIKE);
                compareValue = fm2.getValue() + "%";
            } else if ("right like".equalsIgnoreCase(fm2.getCompare())) {
                compareType = CompareType.getEnum((String)CommonFilterEnum.COMPARISON_OPERATOR_LIKE);
                compareValue = "%" + fm2.getValue();
            } else {
                compareType = CompareType.getEnum((String)fm2.getCompare());
                compareValue = fm2.getValue();
            }
            filterInfo.getFilterItems().add(new FilterItemInfo(fm2.getField(), (Object)compareValue, compareType));
            formatSB.append(fm2.getLeft()).append(" ").append("#").append(String.valueOf(filterInfo.getFilterItems().size() - 1)).append(" ").append(fm2.getRight()).append(" ").append(fm2.getLogic()).append(" ");
        }
        if (filtering.getCuEnabled()) {
            if (!StringUtil.isEmpty(formatSB.toString().trim())) {
                formatSB.append("and").append(" ");
            }
            filterInfo.getFilterItems().add(new FilterItemInfo(filtering.getFilterField(), (Object)filtering.getCuSqlForFilterItem(), CompareType.INCLUDE));
            formatSB.append("(").append(" ").append("#").append(String.valueOf(filterInfo.getFilterItems().size() - 1)).append(" ").append(")").append(" ").append(" ").append(" ");
        }
        if (!StringUtil.isEmpty(formatSB.toString())) {
            filterInfo.setMaskString(formatSB.toString().trim());
        }
    }

    private static GeneralDimensionNode[] getGeneralDimensionNodeArray(IRowSet rs, Map mapping, List customDefineAttributeList, String dimNumber) throws SQLException {
        RDRowSet dbrs = RDRowSet.parse((ResultSet)rs, (int)0, (int)-1);
        return SchemeDataProvider.getGeneralDimensionNodeArray(dbrs, mapping, customDefineAttributeList, dimNumber);
    }

    public static GeneralDimensionNode[] getQueryData0(IManagementFacade facade, SchemeModel schemeModel, List customDefineAttributeList, String dimNumber) throws BOSException, SQLException {
        String pkName = schemeModel.getMetaDataFullName();
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)pkName);
        IQueryExecutor exec = SchemeDataProvider.getQueryExecutor(pk);
        Map mapping = schemeModel.getMappings();
        Filtering filtering = schemeModel.getFiltering();
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        entityView.setFilter(filterInfo);
        SchemeDataProvider.setFilterInfo(filterInfo, filtering);
        exec.setObjectView(entityView);
        try {
            System.out.println(exec.getSQL());
        }
        catch (PermissionServiceException e) {
            log.error((Object)e);
            throw e;
        }
        IRowSet rs = exec.executeQuery();
        return SchemeDataProvider.getGeneralDimensionNodeArray(rs, mapping, customDefineAttributeList, dimNumber);
    }

    public static GeneralDimensionNode[] getQueryData2(IManagementFacade facade, SchemeModel schemeModel, List customDefineAttributeList, String dimNumber) throws SQLException, BOSException, EASBizException {
        String pkName = schemeModel.getMetaDataFullName();
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)pkName);
        IQueryExecutor exec = SchemeDataProvider.getQueryExecutor(pk);
        Map mapping = schemeModel.getMappings();
        Filtering filtering = schemeModel.getFiltering();
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        entityView.setFilter(filterInfo);
        SchemeDataProvider.setFilterInfo(filterInfo, filtering);
        exec.setObjectView(entityView);
        String sql = facade.getQueryMetaDataSQL(pkName);
        RDRowSet rs1rs = facade.executeQuery(sql);
        IRowSet rs1RowSet = DbUtil.executeQuery((String)sql);
        System.out.println(exec.getSQL());
        IRowSet rs = exec.executeQuery();
        return SchemeDataProvider.getGeneralDimensionNodeArray(rs, mapping, customDefineAttributeList, dimNumber);
    }

    public static GeneralDimensionNode[] getQueryData(IManagementFacade facade, SchemeModel schemeModel, List customDefineAttributeList, String dimNumber) throws SQLException, BOSException {
        String pkName = schemeModel.getMetaDataFullName();
        String sql = facade.getQueryMetaDataSQL(pkName);
        schemeModel.setDbCenterSql(sql);
        return SchemeDataProvider.getSQLData(facade, schemeModel, customDefineAttributeList, dimNumber);
    }

    public static IQueryExecutor getQueryExecutor(IMetaDataPK pk) {
        return QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
    }

    public static GeneralDimensionNode[] getTableData(IManagementFacade facade, SchemeModel schemeModel, List customDefineAttributeList, String dimNumber) throws SQLException {
        Context ctx = facade.getContext();
        String pkFullName = schemeModel.getMetaDataFullName();
        MetaDataPK pk = new MetaDataPK(pkFullName);
        DataTableInfo dataTableInfo = MetaDataLoader.getDataTable((Context)ctx, (IMetaDataPK)pk);
        ColumnCollection collection = dataTableInfo.getColumns();
        ColumnInfo columnInfo = null;
        Column srcColumn = null;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            srcColumn = new Column();
            columnInfo = (ColumnInfo)it.next();
            srcColumn.setName(columnInfo.getName());
            srcColumn.setCaption(columnInfo.getAlias());
            srcColumn.setType(columnInfo.getTypeName().getName());
            srcColumn.setLength(columnInfo.getLength());
        }
        String innerSQL = "select * from " + dataTableInfo.getName();
        Filtering filter = schemeModel.getFiltering();
        String sql = SchemeDataProvider.getSQL(innerSQL, filter);
        RDRowSet rs = facade.executeQuery(sql);
        Map mapping = schemeModel.getMappings();
        return SchemeDataProvider.getGeneralDimensionNodeArray(rs, mapping, customDefineAttributeList, dimNumber);
    }

    public static GeneralDimensionNode[] getDBTableData(IManagementFacade facade, SchemeModel schemeModel, List customDefineAttributeList, String dimNumber) throws SQLException {
        String sql = "select * from " + schemeModel.getDbCenterTable();
        schemeModel.setDbCenterSql(sql);
        return SchemeDataProvider.getSQLData(facade, schemeModel, customDefineAttributeList, dimNumber);
    }

    public static GeneralDimensionNode[] getSQLData(IManagementFacade facade, SchemeModel schemeModel, List customDefineAttributeList, String dimNumber) throws SQLException {
        String dbCenterId = schemeModel.getDbCenterId();
        String innerSQL = schemeModel.getDbCenterSql();
        Filtering filter = schemeModel.getFiltering();
        String sql = SchemeDataProvider.getSQL(innerSQL, filter);
        RDRowSet rs = facade.executeDBCenterQuery(dbCenterId, sql);
        Map mapping = schemeModel.getMappings();
        return SchemeDataProvider.getGeneralDimensionNodeArray(rs, mapping, customDefineAttributeList, dimNumber);
    }

    private static String getSQL(String innerSQL, Filtering filter) {
        StringBuffer sql = new StringBuffer(StringUtil.getViewSQL(innerSQL, false));
        boolean cuEnabled = filter.getCuEnabled();
        if (cuEnabled) {
            sql.append(" WHERE ").append("Z.\"").append(filter.getFilterField()).append("\" in ");
            sql.append("(");
            Iterator it = filter.getAdminUint().iterator();
            while (it.hasNext()) {
                sql.append("'").append(it.next()).append("',");
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(") and");
        } else {
            sql.append(" WHERE");
        }
        CommonFilterModel fm2 = null;
        String compareType = null;
        String compareValue = null;
        for (CommonFilterModel fm2 : filter.getCommonFilter()) {
            sql.append(" ").append(fm2.getLeft() == null ? "" : fm2.getLeft());
            sql.append(fm2.getField() == null ? "" : "Z.\"" + fm2.getField() + "\"");
            if (CommonFilterEnum.COMPARISON_OPERATOR_LIKE.equalsIgnoreCase(fm2.getCompare())) {
                compareType = CommonFilterEnum.COMPARISON_OPERATOR_LIKE;
                compareValue = "%" + fm2.getValue() + "%";
            } else if ("left like".equalsIgnoreCase(fm2.getCompare())) {
                compareType = CommonFilterEnum.COMPARISON_OPERATOR_LIKE;
                compareValue = fm2.getValue() + "%";
            } else if ("right like".equalsIgnoreCase(fm2.getCompare())) {
                compareType = CommonFilterEnum.COMPARISON_OPERATOR_LIKE;
                compareValue = "%" + fm2.getValue();
            } else {
                compareType = fm2.getCompare();
                compareValue = fm2.getValue();
            }
            sql.append(compareType == null ? "" : compareType);
            if (fm2.getIsNumeric()) {
                sql.append(compareValue == null ? "" : compareValue);
            } else {
                sql.append(compareValue == null ? "''" : "'" + compareValue + "'");
            }
            sql.append(fm2.getRight() == null ? "" : fm2.getRight());
            sql.append(fm2.getLogic() == null ? "" : fm2.getLogic()).append(" ");
        }
        sql.delete(sql.lastIndexOf(" "), sql.length());
        return sql.toString();
    }

    private static GeneralDimensionNode[] getGeneralDimensionNodeArray(RDRowSet rs, Map mapping, List customDefineAttributeList, String dimNumber) {
        GeneralDimensionNode root = SchemeDataProvider.bulidTree(rs, mapping, customDefineAttributeList, dimNumber);
        GeneralDimensionNode[] result = new GeneralDimensionNode[root.getChildCount()];
        int n = root.getChildCount();
        for (int i = 0; i < n; ++i) {
            result[i] = root.getChild(i);
        }
        return result;
    }

    private static GeneralDimensionNode bulidTree(RDRowSet rs, Map mapping, List customDefineAttributeList, String dimNumber) {
        HashMap<String, ArrayList<GeneralDimensionNode>> mapForTree = new HashMap<String, ArrayList<GeneralDimensionNode>>();
        GeneralDimensionNode rootNode = null;
        GeneralDimensionNode r = new GeneralDimensionNode();
        GeneralModel m = new GeneralModel(dimNumber);
        m.setPropertyList(customDefineAttributeList);
        m.setId(0);
        m.setNumber(null);
        m.setName("\u8fd9\u662f\u865a\u62df\u7684\u6839\u8282\u70b9");
        r.setGeneralModel(m);
        rootNode = r;
        while (rs.next()) {
            String number = SchemeUtil.objectToString(rs.getObject((String)mapping.get("FNUMBER")));
            String parentNumberKey = (String)mapping.get("FPARENTNUMBER");
            String parentNumber = null;
            if (!StringUtil.isEmpty(parentNumberKey)) {
                parentNumber = SchemeUtil.objectToString(rs.getObject((String)mapping.get("FPARENTNUMBER")));
            }
            if (number != null && parentNumber != null && number.equalsIgnoreCase(parentNumber)) {
                parentNumber = null;
            }
            String name = SchemeUtil.objectToString(rs.getObject((String)mapping.get("FNAME")));
            String description = null;
            String descriptionKey = (String)mapping.get("FMEMO");
            if (descriptionKey != null) {
                description = SchemeUtil.objectToString(rs.getObject(descriptionKey));
            }
            String originalId = SchemeUtil.objectToString(rs.getObject((String)mapping.get("FNUMBER")));
            GeneralModel model = new GeneralModel(dimNumber);
            model.setNumber(number);
            model.setName(name);
            model.setMemo(description);
            model.setOriginalId(originalId);
            List attrValueList = GeneralDimensionNode.deepCopy(customDefineAttributeList);
            GeneralDimProperty attr = null;
            String key = null;
            int n = attrValueList.size();
            for (int i = 0; i < n; ++i) {
                attr = (GeneralDimProperty)attrValueList.get(i);
                key = StringUtil.isEmpty(attr.getFieldName()) ? "F" + attr.getNumber() : attr.getFieldName();
                if ((key = (String)mapping.get(key.toUpperCase())) == null) continue;
                attr.setValue(rs.getObject(key));
            }
            model.setPropertyList(attrValueList);
            GeneralDimensionNode node = new GeneralDimensionNode();
            node.setGeneralModel(model);
            if (rootNode == null && (StringUtil.isEmpty(parentNumber) || StringUtil.equals(parentNumber, number))) {
                rootNode = node;
                continue;
            }
            ArrayList<GeneralDimensionNode> children = (ArrayList<GeneralDimensionNode>)mapForTree.get(parentNumber);
            if (children == null) {
                children = new ArrayList<GeneralDimensionNode>();
                mapForTree.put(parentNumber, children);
            }
            children.add(node);
        }
        if (rootNode != null) {
            i = 0;
            SchemeDataProvider.doBuild(rootNode, mapForTree);
        }
        return rootNode;
    }

    private static void doBuild(GeneralDimensionNode parent, Map mapForTree) {
        String number = parent.getGeneralModel().getNumber();
        List children = (List)mapForTree.get(number);
        int childrenCount = children == null ? 0 : children.size();
        for (int i = 0; i < childrenCount; ++i) {
            GeneralDimensionNode child = (GeneralDimensionNode)children.get(i);
            parent.addChild(child);
            SchemeDataProvider.doBuild(child, mapForTree);
        }
    }
}

