/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.mm.monitor;

import com.kingdee.bos.bi.model.common.mm.ComboBoxObject;
import com.kingdee.bos.bi.model.common.mm.monitor.MetricMonitorXmlModel;
import com.kingdee.bos.bi.model.rt.dim.DimensionMeta;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jdom2.JDOMException;

public class MetricMonitorModel {
    private String id;
    private String kpiId;
    private String discription;
    private String schema;
    private MetricMonitorXmlModel xmlModel;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getKPIId() {
        return this.kpiId;
    }

    public void setKPIId(String kpiId) {
        this.kpiId = kpiId;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getDiscription() {
        return this.discription;
    }

    public void setDiscription(String discription) {
        this.discription = discription;
    }

    public MetricMonitorXmlModel getXmlModel() {
        return this.xmlModel;
    }

    public void setXmlModel(MetricMonitorXmlModel xmlModel) {
        this.xmlModel = xmlModel;
    }

    public static List loadKpiModelList(IManagementFacade facade) throws SQLException {
        ArrayList<ComboBoxObject> list = new ArrayList<ComboBoxObject>();
        String sql = "select FID,FName,FAMID from T_BI_AM_KPI where FPublishFlag=1 order by FLastUpdateTime desc";
        RDRowSet rs = facade.executeQuery("select FID,FName,FAMID from T_BI_AM_KPI where FPublishFlag=1 order by FLastUpdateTime desc");
        while (rs.next()) {
            ComboBoxObject kpi = new ComboBoxObject();
            kpi.setCode(rs.getString("FID"));
            kpi.setName(rs.getString("FName"));
            kpi.setInfo(rs.getString("FAMID"));
            list.add(kpi);
        }
        return list;
    }

    public static Vector loadKpiModelInfo(IManagementFacade facade, String kpiId) throws BIModelRemoteException, SQLException {
        Vector<ComboBoxObject> kpiMetricVector = new Vector<ComboBoxObject>();
        String famid = MetricMonitorModel.getAppModelId(facade, kpiId);
        if (!StringUtil.isEmpty(famid)) {
            String metricTableName = MetricMonitorModel.getMetricTableName(facade, famid);
            StringBuffer sql = new StringBuffer();
            sql.append("select C.FID,C.FNumber,C.FName from T_BI_AM_KPI A,").append(metricTableName);
            sql.append(" C ,T_BI_KPI_Metric D where A.FID='").append(kpiId);
            sql.append("' and C.FNumber=D.FMetric and D.FID=A.FID order by C.FID asc");
            RDRowSet rs = facade.executeQuery(sql.toString());
            ComboBoxObject m = null;
            while (rs.next()) {
                m = new ComboBoxObject();
                m.setCode(rs.getString("FNumber"));
                m.setName(rs.getString("FName"));
                kpiMetricVector.add(m);
            }
        }
        return kpiMetricVector;
    }

    private static String getAppModelId(IManagementFacade facade, String kpiId) throws SQLException {
        String sqlGetAppModelId = "select FAMID from T_BI_AM_KPI where FID='" + kpiId + "'";
        RDRowSet rs = facade.executeQuery(sqlGetAppModelId);
        if (rs.next()) {
            return rs.getString("FAMID");
        }
        return null;
    }

    public static MetricMonitorModel load(IManagementFacade facade, String metricId, String kpiId) throws SQLException, JDOMException, IOException {
        String xml;
        RDRowSet rs;
        MetricMonitorModel model = new MetricMonitorModel();
        StringBuffer sql = new StringBuffer();
        sql.append("select FID,FName,FKPIID,FSchema,FDiscription from T_BI_KPI_MON where FID='").append(metricId).append("'");
        if (!StringUtil.isEmpty(kpiId)) {
            sql.append(" and FKPIID='").append(kpiId).append("'");
        }
        if ((rs = facade.executeQuery(sql.toString())).next()) {
            model.setId(rs.getString("FID"));
            model.setKPIId(rs.getString("FKPIID"));
            model.setSchema(rs.getString("FSchema"));
            model.setDiscription(rs.getString("FDiscription"));
        }
        if (!StringUtil.isEmpty(xml = model.getSchema())) {
            model.setXmlModel(MetricMonitorXmlModel.toModel(xml));
        }
        return model;
    }

    public static void save(IManagementFacade facade, MetricMonitorModel model) throws BIModelRemoteException, SQLException, IOException {
        StringBuffer sqlUpdate = new StringBuffer();
        sqlUpdate.append("update T_BI_KPI_MON set FKPIID= '").append(model.getKPIId()).append("',FSchema = '");
        sqlUpdate.append(MetricMonitorXmlModel.toXml(model.getXmlModel())).append("',FDiscription = '");
        sqlUpdate.append(model.getDiscription()).append("'").append(" where FID ='").append(model.getId()).append("'");
        facade.executeUpdate(sqlUpdate.toString());
    }

    public static String getMetricTableName(IManagementFacade facade, String appmodelId) throws BIModelRemoteException {
        String pubnumber = (String)facade.getAppmodelInfo(appmodelId, "pubnumber");
        if (!StringUtil.isEmpty(pubnumber)) {
            return DimensionMeta.getTablename(pubnumber, "metric");
        }
        return null;
    }
}

