/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.mm.schedule;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.common.mm.schedule.ScheduleExecutor;
import com.kingdee.bos.bi.model.ui.exception.BIModelBizException;
import com.kingdee.bos.bi.model.util.XmlUtil;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.service.job.IJobService;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.JobDef;
import com.kingdee.bos.service.job.core.JobIsolationLevel;
import com.kingdee.bos.service.job.core.Trigger;
import com.kingdee.bos.service.job.core.Wrapper;
import com.kingdee.bos.service.job.wrapper.MethodWrapper;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class ScheduleUtil {
    private static Logger log = CommonLogger.getLogger(ScheduleUtil.class);
    public static final String SCHEDULE_RETRYTIME = "RetryTime";
    public static final String SCHEDULE_TYPE = "Type";
    public static final String SCHEDULE_BEGIN_TIME = "BeginTime";
    public static final String SCHEDULE_END_TIME = "EndTime";
    public static final String SCHEDULE_USE_CALENDAR = "UseCalendar";
    public static final String SCHEDULE_ORG_UnitId = "OrgUnitId";
    public static final String SCHEDULE_INSTRUCTION_TYPE = "InstructionType";
    public static final String SCHEDULE_SCHEDULE_PLAN = "SchedulePlan";
    public static final String SCHEDULE_XML_INITIAL = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Scheduale xmlns=\"http://www.kingdee.com/2003/K-PDL1.0\" RetryTime=\"0\" Type=\"EVERYDAY\" BeginTime=\"1258446031557\" EndTime=\"1258446031557\" UseCalendar=\"false\" InstructionType=\"0\"></Scheduale>";

    public static void createJobDef(Context ctx, String viewId, String viewName, String scheduleXML) throws Exception {
        JobDef jobDef = ScheduleUtil.toJobDef(ctx, viewId, viewName, scheduleXML);
        Trigger trigger = ScheduleUtil.toTrigger(jobDef, scheduleXML);
        IJobService svc = JobServiceFactory.getLocalInstance((Context)ctx);
        try {
            svc.createJobDef(jobDef, trigger, true);
        }
        catch (Throwable e) {
            log.error((Object)("createJobDef error , id:" + viewId + " , scheduleXML:" + scheduleXML), e);
        }
    }

    private static JobDef toJobDef(Context ctx, String viewId, String viewName, String scheduleXML) throws Exception {
        String jobdefid = viewId + "BGJOBDEF";
        String packageName = "com.kingdee.bos.bi.model.ui.dialog.schedule";
        String title = "BI-\u4f01\u4e1a\u6307\u6807\u5efa\u6a21-" + viewName;
        String description = "BI-\u4f01\u4e1a\u6307\u6807\u5efa\u6a21-\u540e\u53f0\u8c03\u5ea6\uff1aid=" + viewId + ",name" + viewName;
        String proxyUserID = ctx.getCaller().toString();
        String proxyOrgID = (String)ScheduleUtil.xmlToMap(scheduleXML).get(SCHEDULE_ORG_UnitId);
        boolean isPersistent = true;
        MethodWrapper handler = null;
        boolean isSmallJob = false;
        String mutex = null;
        int priority = 0;
        int missedTimeout = -1;
        JobIsolationLevel isolationLevel = null;
        String viewerUI = null;
        String dc = ctx.getAIS();
        String user = ctx.getCaller().toString();
        Class<ScheduleUtil> cls = ScheduleUtil.class;
        String methodName = "execute";
        Object[] params = new Object[]{viewId};
        handler = new MethodWrapper(cls, methodName, params);
        JobDef jobDef = new JobDef(jobdefid, packageName, title, description, proxyUserID, proxyOrgID, isPersistent, (Wrapper)handler, isSmallJob, mutex, priority, missedTimeout, isolationLevel, viewerUI, dc, user);
        return jobDef;
    }

    private static Trigger toTrigger(JobDef jobDef, String scheduleXML) throws Exception {
        Date validateTime = new Date();
        Date expiredTime = new Date(2842790400000L);
        String pulseSourceCode = "timer";
        boolean isAutoLoad = true;
        String schedulePlan = (String)ScheduleUtil.xmlToMap(scheduleXML).get(SCHEDULE_TYPE) + ":" + (String)ScheduleUtil.xmlToMap(scheduleXML).get(SCHEDULE_SCHEDULE_PLAN);
        boolean useCalendar = "true".equals(ScheduleUtil.xmlToMap(scheduleXML).get(SCHEDULE_USE_CALENDAR));
        Trigger trigger = new Trigger(validateTime, expiredTime, jobDef, pulseSourceCode, isAutoLoad, schedulePlan, useCalendar);
        return trigger;
    }

    public static Map xmlToMap(String xml) throws JDOMException, IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        Element root = XmlUtil.toRootElement(xml);
        paramMap.put(SCHEDULE_SCHEDULE_PLAN, root.getText());
        paramMap.put(SCHEDULE_RETRYTIME, root.getAttributeValue(SCHEDULE_RETRYTIME));
        paramMap.put(SCHEDULE_TYPE, root.getAttributeValue(SCHEDULE_TYPE));
        paramMap.put(SCHEDULE_BEGIN_TIME, root.getAttributeValue(SCHEDULE_BEGIN_TIME));
        paramMap.put(SCHEDULE_END_TIME, root.getAttributeValue(SCHEDULE_END_TIME));
        paramMap.put(SCHEDULE_USE_CALENDAR, root.getAttributeValue(SCHEDULE_USE_CALENDAR));
        paramMap.put(SCHEDULE_ORG_UnitId, root.getAttributeValue(SCHEDULE_ORG_UnitId));
        paramMap.put(SCHEDULE_INSTRUCTION_TYPE, root.getAttributeValue(SCHEDULE_INSTRUCTION_TYPE));
        return paramMap;
    }

    public static void execute(Context ctx, String id) throws BIModelBizException {
        ScheduleExecutor.doExecute(ctx, id);
    }
}

