/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.mm.time.builder;

import com.kingdee.bos.bi.model.common.mm.time.TimeDimensionNode;
import com.kingdee.bos.bi.model.common.mm.time.TimeModel;
import com.kingdee.bos.bi.model.common.mm.time.TimeTreeModel;
import com.kingdee.bos.bi.model.common.mm.time.TimeUtil;
import com.kingdee.bos.bi.model.common.mm.time.builder.AbstractTimeLevel;
import java.util.Map;

public class MonthLevel
extends AbstractTimeLevel {
    public MonthLevel(TimeModel timeModel) {
        super(timeModel);
        this.levelCode = 4;
        this.levelName = "month";
        this.levelBriefNumber = "M";
    }

    public MonthLevel(TimeModel timeModel, Map params) {
        super(timeModel, params);
        this.levelCode = 4;
        this.levelName = "month";
        this.levelBriefNumber = "M";
    }

    @Override
    protected void doBuilderFromYear(TimeDimensionNode parentNode) {
        boolean cursor = true;
        int theEnd = 12;
        this.createMonthTreeNodes(parentNode, 1, 12);
    }

    @Override
    protected void doBuilderFromHalfYear(TimeDimensionNode parentNode) {
        int cursor = (this.prevLevel.value - 1) * 6 + 1;
        int theEnd = this.prevLevel.value * 6;
        this.createMonthTreeNodes(parentNode, cursor, theEnd);
    }

    @Override
    protected void doBuilderFromQuarter(TimeDimensionNode parentNode) {
        int cursor = (this.prevLevel.value - 1) * 3 + 1;
        int theEnd = this.prevLevel.value * 3;
        this.createMonthTreeNodes(parentNode, cursor, theEnd);
    }

    @Override
    protected void doBuilderFromMonth(TimeDimensionNode parentNode) {
    }

    @Override
    protected void doBuilderFromDate(TimeDimensionNode parentNode) {
    }

    private void createMonthTreeNodes(TimeDimensionNode parentNode, int cursor, int theEnd) {
        int startMonth = TimeUtil.getMonth(this.startTime);
        int endMonth = TimeUtil.getMonth(this.endTime);
        int year = this.getYear();
        while (cursor <= theEnd) {
            if (!(this.prevLevel.isStart && cursor < startMonth || this.prevLevel.isEnd && cursor > endMonth)) {
                TimeUtil.resetCalendarAll(this.calendar, year, cursor, 1);
                TimeDimensionNode monthNode = new TimeDimensionNode();
                TimeTreeModel monthModel = new TimeTreeModel();
                monthModel.setDimensionType(parentNode.getTimeModel().getDimensionType());
                monthNode.setTimeModel(monthModel);
                monthModel.setName(cursor + "\u6708");
                monthModel.setNumber(TimeUtil.getStringTime(this.calendar));
                monthModel.setLevelName("month");
                monthModel.setShortNumber(Integer.toString(cursor));
                this.addParamsForDashBoard(monthModel);
                parentNode.addChild(monthNode);
                if (this.nextLevel != null) {
                    this.value = cursor;
                    this.isStart = this.prevLevel.isStart && cursor == startMonth;
                    this.isEnd = this.prevLevel.isEnd && cursor == endMonth;
                    this.nextLevel.builder(monthNode);
                }
            }
            ++cursor;
        }
    }
}

