/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.mm.time.builder;

import com.kingdee.bos.bi.model.common.mm.time.TimeDimensionNode;
import com.kingdee.bos.bi.model.common.mm.time.TimeModel;
import com.kingdee.bos.bi.model.common.mm.time.TimeTreeModel;
import com.kingdee.bos.bi.model.common.mm.time.TimeUtil;
import com.kingdee.bos.bi.model.common.mm.time.builder.AbstractTimeLevel;
import java.util.Map;

public class YearLevel
extends AbstractTimeLevel {
    public YearLevel(TimeModel timeModel) {
        super(timeModel);
        this.levelCode = 1;
        this.levelName = "year";
        this.levelBriefNumber = "Y";
    }

    public YearLevel(TimeModel timeModel, Map params) {
        super(timeModel, params);
        this.levelCode = 1;
        this.levelName = "year";
        this.levelBriefNumber = "Y";
    }

    @Override
    protected void doBuilderFromYear(TimeDimensionNode parentNode) {
        int startYear = TimeUtil.getYear(this.startTime);
        int endYear = TimeUtil.getYear(this.endTime);
        this.createYearTreeNodes(parentNode, startYear, endYear);
    }

    @Override
    protected void doBuilderFromHalfYear(TimeDimensionNode parentNode) {
    }

    @Override
    protected void doBuilderFromQuarter(TimeDimensionNode parentNode) {
    }

    @Override
    protected void doBuilderFromMonth(TimeDimensionNode parentNode) {
    }

    @Override
    protected void doBuilderFromDate(TimeDimensionNode parentNode) {
    }

    private void createYearTreeNodes(TimeDimensionNode parentNode, int startYear, int endYear) {
        for (int cursor = startYear; cursor <= endYear; ++cursor) {
            TimeUtil.resetCalendarAll(this.calendar, cursor, 1, 1);
            TimeDimensionNode yearNode = new TimeDimensionNode();
            TimeTreeModel yearModel = new TimeTreeModel();
            yearModel.setDimensionType(parentNode.getTimeModel().getDimensionType());
            yearNode.setTimeModel(yearModel);
            yearModel.setName(cursor + "\u5e74");
            yearModel.setNumber(TimeUtil.getStringTime(this.calendar));
            yearModel.setLevelName("year");
            yearModel.setShortNumber(Integer.toString(cursor));
            this.addParamsForDashBoard(yearModel);
            parentNode.addChild(yearNode);
            if (this.nextLevel == null) continue;
            this.value = cursor;
            this.isStart = cursor == startYear;
            this.isEnd = cursor == endYear;
            this.nextLevel.builder(yearNode);
        }
    }
}

