/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.commonui.contentree.panel;

import com.kingdee.bos.bi.model.commonui.contentree.event.BranchEvent;
import com.kingdee.bos.bi.model.commonui.contentree.event.BranchListener;
import com.kingdee.bos.bi.model.commonui.contentree.panel.content.IBranchContent;
import com.kingdee.bos.bi.model.commonui.contentree.panel.content.ILeafContent;
import com.kingdee.bos.bi.model.commonui.contentree.panel.content.INodeContent;
import com.kingdee.bos.bi.model.commonui.contentree.panel.content.impl.DefaultBranchContent;
import com.kingdee.bos.bi.model.commonui.contentree.panel.content.impl.DefaultLeafContent;
import com.kingdee.bos.bi.model.commonui.contentree.panel.view.DefaultTreeView;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DefaultPanel
extends KDPanel {
    private static final long serialVersionUID = 5236568681181579552L;
    private Component owner;
    private KDPanel panMain;
    private KDTree treeMain;
    private KDTreeView treeViewMain;
    private IBranchContent rootContent;
    private KDSplitPane split;
    private boolean isSysMenuInstalled = false;

    public DefaultPanel() {
        this(null);
    }

    public DefaultPanel(Component owner) {
        this.owner = owner;
        this.installComponent();
        this.installListener();
    }

    private void installComponent() {
        this.rootContent = this.createBranchContentInstance();
        this.initContentTree();
        this.treeViewMain = this.getTreeView(this.treeMain);
        this.panMain = new KDPanel((LayoutManager)new BorderLayout());
        this.split = new KDSplitPane();
        this.split.setLeftComponent((Component)this.treeViewMain);
        this.split.setRightComponent((Component)this.panMain);
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    public void setDividerLocation(int d) {
        if (this.split != null) {
            this.split.setDividerLocation(d);
        }
    }

    public DefaultTreeView getTreeView(KDTree tree) {
        return new DefaultTreeView(tree);
    }

    private void installListener() {
        this.treeMain.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultPanel.this.changeContent(e.getOldLeadSelectionPath(), e.getNewLeadSelectionPath());
            }
        });
    }

    private void changeContent(TreePath oldPath, TreePath newPath) {
        DefaultKingdeeTreeNode node;
        if (!this.isSysMenuInstalled) {
            this.isSysMenuInstalled = true;
        }
        this.panMain.removeAll();
        if (oldPath != null) {
            node = (DefaultKingdeeTreeNode)oldPath.getLastPathComponent();
            INodeContent iNodeContent = (INodeContent)node.getUserObject();
        }
        if (newPath == null) {
            return;
        }
        node = (DefaultKingdeeTreeNode)newPath.getLastPathComponent();
        INodeContent content = (INodeContent)node.getUserObject();
        if (content instanceof IBranchContent) {
            ((IBranchContent)content).setBranchNode(node);
        }
        content.installComponents((Container)this.panMain);
        this.getOwner().validate();
        this.getOwner().repaint();
    }

    private void initContentTree() {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"root");
        root.setUserObject((Object)this.rootContent);
        this.treeMain = new KDTree((ITreeNode)root, false, true);
        this.treeMain.getSelectionModel().setSelectionMode(1);
        this.treeMain.setShowPopMenuDefaultItem(false);
        this.treeMain.setShowsRootHandles(true);
    }

    public void removeNode(DefaultKingdeeTreeNode node) {
        if (node == null) {
            return;
        }
        DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)node.getParent();
        this.treeMain.removeNodeFromParent((MutableTreeNode)node);
        if (parentNode != null && parentNode != this.treeMain.getModel().getRoot()) {
            this.treeMain.setSelectionNode(parentNode);
        }
    }

    private void addNode(DefaultKingdeeTreeNode parentNode, DefaultKingdeeTreeNode childNode) {
        DefaultKingdeeTreeNode parent = parentNode;
        if (parentNode == null) {
            parent = (DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot();
        }
        if (!(parent.getUserObject() instanceof IBranchContent)) {
            throw new Error("parentNode.getUserObject() must be " + IBranchContent.class);
        }
        this.treeMain.addNodeInto((MutableTreeNode)childNode, (MutableTreeNode)parent);
    }

    protected DefaultKingdeeTreeNode createTreeNode(INodeContent userObj, String text, ImageIcon icon) {
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)userObj);
        if (!StringUtil.isEmpty(text)) {
            node.setText(text);
        }
        if (icon != null) {
            node.setCustomIcon((Icon)icon);
        }
        return node;
    }

    public void setRootNodeShow(boolean isShow) {
        this.treeMain.setRootVisible(isShow);
    }

    public DefaultKingdeeTreeNode setRootNode(IBranchContent branch, String text, ImageIcon icon) {
        if (branch == null) {
            branch = this.rootContent;
        }
        branch.setOwner((Component)this.panMain);
        DefaultKingdeeTreeNode root = this.createTreeNode(branch, text, icon);
        this.treeMain.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root, true));
        return root;
    }

    public DefaultKingdeeTreeNode addBranch(DefaultKingdeeTreeNode parentNode, IBranchContent userObj, String text, ImageIcon icon) {
        IBranchContent content = userObj;
        if (userObj == null) {
            content = this.rootContent;
        }
        content.setOwner((Component)this.panMain);
        DefaultKingdeeTreeNode node = this.createTreeNode(content, text, icon);
        this.addNode(parentNode, node);
        return node;
    }

    public DefaultKingdeeTreeNode addLeaf(DefaultKingdeeTreeNode parentNode, ILeafContent userObj, String text, ImageIcon icon) {
        ILeafContent content = userObj;
        if (userObj == null) {
            content = this.createLeafContentInstance();
        }
        content.setOwner((Component)this.panMain);
        DefaultKingdeeTreeNode node = this.createTreeNode(content, text, icon);
        node.setAllowsChildren(false);
        this.addNode(parentNode, node);
        return node;
    }

    public void validateConsoleTree() {
        this.treeViewMain.repaint();
        this.treeViewMain.validate();
        this.treeViewMain.revalidate();
        this.treeMain.repaint();
        this.treeMain.validate();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot();
        if (this.treeMain.isRootVisible()) {
            this.treeMain.setSelectionNode(root);
            this.treeMain.expandPath(new TreePath(root.getPath()));
        } else {
            if (root.getChildCount() > 0) {
                this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)root.getChildAt(0));
            }
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.treeMain.expandPath(new TreePath(((DefaultKingdeeTreeNode)root.getChildAt(i)).getPath()));
            }
        }
    }

    private ILeafContent createLeafContentInstance() {
        return new DefaultLeafContent("Welcome to Along's program!");
    }

    public KDTree getTree() {
        return this.treeMain;
    }

    public void setTitle(String title) {
        this.treeViewMain.setTitle(title);
    }

    public IBranchContent createBranchContentInstance() {
        DefaultBranchContent branchContent = new DefaultBranchContent();
        branchContent.addBranchListener(new BranchListener(){

            @Override
            public void doubleClickedItem(BranchEvent e) {
                DefaultPanel.this.treeMain.setSelectionNode(e.getClickedNode());
            }
        });
        return branchContent;
    }

    public void setOwner(Component owner) {
        this.owner = owner;
    }

    public Component getOwner() {
        return this.owner;
    }
}

