/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.appmodel;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.common.mm.appmodel.FormulaParamModel;
import com.kingdee.bos.bi.model.rt.appmodel.AggDataRule;
import com.kingdee.bos.bi.model.rt.appmodel.AppModel;
import com.kingdee.bos.bi.model.rt.appmodel.EASDataRule;
import com.kingdee.bos.bi.model.rt.appmodel.FIPeriod;
import com.kingdee.bos.bi.model.rt.appmodel.Formula;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.rt.dim.measure.MeasureDimension;
import com.kingdee.bos.bi.model.ui.exception.BIModelBizException;
import com.kingdee.bos.bi.model.util.StringUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;

public abstract class DataRule {
    protected AppModel appmodel;
    protected String type;
    protected Map parameters;
    protected String schemaId;
    protected int itemorder;
    public static final String TYPE_EAS = "eas";
    public static final String TYPE_CALC = "calc";
    public static final int TYPE_EAS_FLAG = 0;
    public static final int TYPE_CALC_FLAG = 1;

    protected DataRule(AppModel appmodel, String schemaId, int itemorder, Map parameters) {
        this.appmodel = appmodel;
        this.schemaId = schemaId;
        this.itemorder = itemorder;
        this.parameters = parameters;
    }

    public String getSchemaId() {
        return this.schemaId;
    }

    public String getAppmodelId() {
        return this.appmodel.getId();
    }

    public int getItemorder() {
        return this.itemorder;
    }

    public static void getFormulaParam(Formula formula, Connection cn, String appModelId, String unpassedVoucher, String iteamSummarize) throws SQLException {
        FormulaParamModel paramModel = null;
        if (!StringUtil.isEmpty(unpassedVoucher)) {
            if ("include".equals(unpassedVoucher)) {
                formula.isUnpassedVoucherIncluded = true;
            } else if ("exclude".equals(unpassedVoucher)) {
                formula.isUnpassedVoucherIncluded = false;
            } else if ("default".equals(unpassedVoucher)) {
                if (cn != null && appModelId != null) {
                    paramModel = FormulaParamModel.getFormulaParamModel(cn, appModelId);
                }
                if (null != paramModel) {
                    DataRule.getFormulaParam(formula, null, null, paramModel.getUnpassedVoucher(), null);
                }
            } else {
                formula.isUnpassedVoucherIncluded = false;
            }
        }
        if (!StringUtil.isEmpty(iteamSummarize)) {
            if ("detail".equals(iteamSummarize)) {
                formula.isDetailItemBalanceIncluded = true;
                formula.isSubItemBalanceIncluded = false;
            } else if ("sub".equals(iteamSummarize)) {
                formula.isDetailItemBalanceIncluded = false;
                formula.isSubItemBalanceIncluded = true;
            } else if ("none".equals(iteamSummarize)) {
                formula.isDetailItemBalanceIncluded = false;
                formula.isSubItemBalanceIncluded = false;
            } else if ("default".equals(iteamSummarize)) {
                if (paramModel == null && cn != null && appModelId != null) {
                    paramModel = FormulaParamModel.getFormulaParamModel(cn, appModelId);
                }
                if (null != paramModel) {
                    DataRule.getFormulaParam(formula, null, null, null, paramModel.getIteamSummarize());
                }
            } else {
                formula.isDetailItemBalanceIncluded = false;
                formula.isSubItemBalanceIncluded = false;
            }
        }
    }

    public static DataRule fromNode(Element e, AppModel appmodel, String schemaID, int itemorder, Connection cn) throws SQLException {
        Element formulaEle;
        String type = e.getAttributeValue("type");
        Formula formula = new Formula();
        if (TYPE_EAS.equalsIgnoreCase(type) && (formulaEle = e.getChild("formula")) != null) {
            formula.formula = formulaEle.getText();
            String unpassedVoucher = formulaEle.getAttributeValue("unpassedVoucher");
            String iteamSummarize = formulaEle.getAttributeValue("iteamSummarize");
            DataRule.getFormulaParam(formula, cn, appmodel.getId(), unpassedVoucher, iteamSummarize);
        }
        HashMap mapParams = new HashMap();
        DimensionType[] dimTypes = appmodel.getDimTypes();
        for (int i = 0; i < dimTypes.length; ++i) {
            String dimType = dimTypes[i].getName();
            Dimension dim = appmodel.getDimension(dimType);
            List eles = e.getChildren(dimType);
            List<String> param = new ArrayList();
            if (eles.size() > 0) {
                List items = ((Element)eles.get(0)).getChildren("item");
                if (items.size() == 0) {
                    param = dim.getMembers(cn, null, false, false);
                } else {
                    ArrayList<String> lstParam = new ArrayList<String>();
                    for (Element elItem : items) {
                        lstParam.add(elItem.getAttributeValue("value"));
                    }
                    if (dimTypes[i].equals(DimensionType.measure)) {
                        param.addAll(((MeasureDimension)dim).sortByFormular(lstParam, cn));
                    } else {
                        param.addAll(lstParam);
                    }
                }
            } else {
                param = appmodel.getDimension(dimType).getMembers(cn, null, false, false);
            }
            mapParams.put(dimType, param);
        }
        if (TYPE_EAS.equalsIgnoreCase(type)) {
            return new EASDataRule(appmodel, schemaID, itemorder, mapParams, formula);
        }
        if (TYPE_CALC.equalsIgnoreCase(type)) {
            return new AggDataRule(appmodel, schemaID, itemorder, mapParams);
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public Map getParameters() {
        return this.parameters;
    }

    protected Date adjustDate(Date date, Map scheduleConfig) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String periodCalcRule = (String)scheduleConfig.get("PeriodCalcRule");
        if ("last".equalsIgnoreCase(periodCalcRule)) {
            calendar.add(2, -1);
            int lastday = calendar.getActualMaximum(5);
            calendar.set(5, lastday);
        }
        return calendar.getTime();
    }

    protected FIPeriod checkDate(Date date, boolean checkQuarter) {
        int year = date.getYear() + 1900;
        int month = date.getMonth() + 1;
        Map map = this.getParameters();
        int quarter = FIPeriod.getQuarter(month);
        List lstYear = (List)map.get("year");
        if (lstYear.indexOf(year + "") == -1) {
            return null;
        }
        List lstPeirod = (List)map.get("period");
        if (checkQuarter) {
            if (lstPeirod.indexOf(quarter + "") != -1) {
                return new FIPeriod(year, quarter, true, month);
            }
            if (lstPeirod.indexOf(month + "") != -1) {
                return new FIPeriod(year, month, false, month);
            }
        } else if (lstPeirod.indexOf(month + "") != -1) {
            return new FIPeriod(year, month, false, month);
        }
        return null;
    }

    public abstract void calc(Date var1, Connection var2, Context var3, Map var4, Map var5, StringBuffer var6) throws BIModelBizException;
}

