/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.bireport;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.common.bireport.BIReportModel;
import com.kingdee.bos.bi.model.common.bireport.layout.BIReportComponents;
import com.kingdee.bos.bi.model.common.bireport.layout.ChartComponent;
import com.kingdee.bos.bi.model.common.bireport.layout.IComponent;
import com.kingdee.bos.bi.model.common.bireport.layout.PageSetup;
import com.kingdee.bos.bi.model.common.bireport.layout.WorksheetComponent;
import com.kingdee.bos.bi.model.common.bireport.property.bean.BIReportBean;
import com.kingdee.bos.bi.model.common.mm.time.TimeModel;
import com.kingdee.bos.bi.model.rt.appmodel.AppModel;
import com.kingdee.bos.bi.model.rt.appmodel.AppModelView;
import com.kingdee.bos.bi.model.rt.bireport.BIMSubject;
import com.kingdee.bos.bi.model.rt.dim.DimensionMeta;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.rt.dim.DimensionView;
import com.kingdee.bos.bi.model.rt.dim.Property;
import com.kingdee.bos.bi.model.rt.dim.measure.MeasureDimension;
import com.kingdee.bos.bi.model.rt.dim.measure.MeasureDimensionMeta;
import com.kingdee.bos.bi.model.rt.fact.Fact;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.solution.BILayout;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReport;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReportScheme;
import com.kingdee.bos.ctrl.analysis.web.solution.BISubject;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilter;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.FilterScheme;
import com.kingdee.bos.ctrl.analysis.web.solution.impl.BIReportChartComponent;
import com.kingdee.bos.ctrl.analysis.web.solution.impl.BIReportWorksheetComponent;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.jdom2.JDOMException;

public class BIReportImpl
implements BIReport {
    private BIReportModel bim;
    private String reportID;
    private String repositoryPath;
    private String reportName;
    private String reportCaption;
    private boolean isMolap;
    private String dataCenterName;
    private List lstComponents;
    private Document doc = null;
    private InputStream isCube;
    private InputStream isDataSource;
    private String mdx;
    private static final String PAR_FACT_TABLE_NAME = "fact_app";
    private static final String CUBE_NAME = "bimodelTest";

    public BIReportImpl(String reportID, String repositoryPath, HttpServletRequest request) throws BIReportException, SQLException {
        Context ctx = BISystem.getContext((HttpServletRequest)request);
        this.bim = BIReportModel.fromID(reportID, ctx);
        this.reportID = reportID;
        this.repositoryPath = repositoryPath;
        this.reportName = this.bim.getReportName();
        this.reportCaption = this.bim.getReportName();
        this.isMolap = false;
        this.mdx = this.bim.toMDX(ctx);
        this.isCube = this.createCube(this.bim.getAppModelView(), this.bim.getAppModel(), ctx);
        this.isDataSource = this.createDataSource(this.bim.getAppModelView());
        this.dataCenterName = this.bim.getAppModel().getDBCenterName();
    }

    public void close() {
    }

    public BIReportFilter getFilter(HttpServletRequest request) throws BIReportException {
        return null;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public boolean hasFilter(HttpServletRequest request) throws BIReportException {
        return false;
    }

    public String getCaption() {
        return this.reportCaption;
    }

    public String getDatacenter() {
        return this.dataCenterName;
    }

    public String getID() {
        return this.reportID;
    }

    public String getName() {
        return this.reportName;
    }

    public boolean isMolap() {
        return this.isMolap;
    }

    public List getComponents() {
        String mdxQuery = "bireport";
        this.lstComponents = new ArrayList();
        boolean showSlicer = this.bim.getLayout().getSlicer().isVisible();
        List lstCom = this.bim.getLayout().getComponents().getComponents();
        int len = lstCom.size();
        for (int i = 0; i < len; ++i) {
            BIReportChartComponent c;
            Properties pro;
            IComponent com = (IComponent)lstCom.get(i);
            if (com instanceof WorksheetComponent) {
                WorksheetComponent wc = (WorksheetComponent)com;
                pro = wc.getProperties();
                pro.put("showSlicer", Boolean.toString(showSlicer));
                c = new BIReportWorksheetComponent(wc.getName(), wc.getTitle(), "worksheet", mdxQuery, this.mdx, pro);
                this.lstComponents.add(c);
                continue;
            }
            if (!(com instanceof ChartComponent)) continue;
            ChartComponent cc = (ChartComponent)com;
            pro = cc.getProperties();
            c = new BIReportChartComponent(cc.getName(), cc.getTitle(), "chart", mdxQuery, this.mdx, pro);
            this.lstComponents.add(c);
        }
        return this.lstComponents;
    }

    public List getComponents(String schemeName) {
        if (this.lstComponents != null) {
            return this.lstComponents;
        }
        return this.getComponents();
    }

    public InputStream getCubeStream() throws BIReportException {
        return this.isCube;
    }

    private void createTableRef(StringBuffer sbSchema, AppModelView apv) {
        List dvList = apv.getDimRef().getDimensionViews();
        int count = dvList.size();
        for (int i = 0; i < count; ++i) {
            DimensionView dv = (DimensionView)dvList.get(i);
            if (!dv.isMeasure()) {
                sbSchema.append("<Parameter name=\"t_dim_");
                sbSchema.append(dv.getDimensionDef().getType());
                sbSchema.append("\" type=\"table\"/>");
                continue;
            }
            sbSchema.append("<Parameter name=\"fact_app\" type=\"table\"/>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDimensionDef(StringBuffer sbSchema, AppModelView apv, Context ctx) {
        List dvList = apv.getDimRef().getDimensionViews();
        Map aggMap = apv.getAggMap();
        int dvCount = dvList.size();
        for (int i = 0; i < dvCount; ++i) {
            DimensionView dv = (DimensionView)dvList.get(i);
            if (dv.isMeasure()) continue;
            DimensionMeta dm = dv.getDimensionDef();
            DimensionType dt = dm.getDimensionType();
            String typename = dt.getName();
            String typeAlias = dt.getAlias();
            String PK = dm.getPK();
            String childColumn = dm.getBizKey();
            String parentColumn = dm.getParentNumber();
            sbSchema.append("<Dimension name=\"" + typename + "\" ");
            sbSchema.append("caption=\"" + typeAlias + "\" ");
            sbSchema.append("table=\"t_dim_" + typename + "\" ");
            if (dt.isTime()) {
                sbSchema.append("type=\"time\" ");
            }
            sbSchema.append("primaryKey=\"" + PK + "\">");
            boolean aggFlag = !StringUtil.toBoolean((String)aggMap.get(typename));
            sbSchema.append("<Hierarchy aggregate=\"" + aggFlag + "\">");
            if ("org".equalsIgnoreCase(typename) || "metric".equalsIgnoreCase(typename) || "general".equalsIgnoreCase(dt.getInnerType())) {
                sbSchema.append("<Level name=\"" + typename + "\" ");
                sbSchema.append("caption=\"" + typeAlias + "\" ");
                sbSchema.append("column=\"" + PK + "\" ");
                sbSchema.append("childColumn=\"" + childColumn + "\" ");
                sbSchema.append("parentColumn=\"" + parentColumn + "\">");
                List props = dm.getProperties();
                int propsCount = props.size();
                for (int j = 0; j < propsCount; ++j) {
                    Property p = (Property)props.get(j);
                    if (!p.isInner()) {
                        sbSchema.append("<Property name=\"" + p.getName() + "\" ");
                        sbSchema.append("column=\"" + p.getField() + "\"/>");
                        continue;
                    }
                    if ("number".equalsIgnoreCase(p.getName())) {
                        sbSchema.append("<Property name=\"name\" column=\"" + p.getField() + "\"/>");
                        continue;
                    }
                    if (!"name".equalsIgnoreCase(p.getName())) continue;
                    sbSchema.append("<Property name=\"caption\" column=\"" + p.getField() + "\"/>");
                }
                sbSchema.append("</Level>");
            } else if ("period".equalsIgnoreCase(typename)) {
                sbSchema.append("<Level name=\"" + typename + "\" ");
                sbSchema.append("caption=\"" + typeAlias + "\" ");
                sbSchema.append("column=\"" + PK + "\" ");
                sbSchema.append("childColumn=\"" + childColumn + "\" ");
                sbSchema.append("parentColumn=\"" + parentColumn + "\">");
                String periodField = dm.getBizKey();
                sbSchema.append("<Property name=\"name\" column=\"" + periodField + "\"/>");
                sbSchema.append("<Property name=\"caption\" column=\"FName\"/>");
                sbSchema.append("</Level>");
            } else if ("year".equalsIgnoreCase(typename)) {
                sbSchema.append("<Level name=\"" + typename + "\" ");
                sbSchema.append("caption=\"" + typeAlias + "\" ");
                sbSchema.append("column=\"" + PK + "\" ");
                sbSchema.append(">");
                sbSchema.append("<Property name=\"caption\" column=\"FName\"/>");
                sbSchema.append("</Level>");
            } else if (dt.isTime()) {
                Connection con = null;
                try {
                    con = BISystem.getJdbcConnection((Context)ctx);
                    TimeModel timeModelMeta = TimeModel.load2(con, apv.getPubnumber(), dt.getName());
                    if (timeModelMeta.getUseYear()) {
                        sbSchema.append("<Level name=\"Year\" caption=\"\" column=\"FYear\" type=\"Years\" isDateTimeColumn=\"false\">");
                        sbSchema.append("</Level>");
                    }
                    if (timeModelMeta.getUseQuarter()) {
                        sbSchema.append("<Level name=\"quarter\" caption=\"\" column=\"FQuarter\" type=\"Quarters\" isDateTimeColumn=\"false\">");
                        sbSchema.append("</Level>");
                    }
                    if (timeModelMeta.getUseMonth()) {
                        sbSchema.append("<Level name=\"Month\" caption=\"\" column=\"FMonth\" type=\"Months\"  isDateTimeColumn=\"false\">");
                        sbSchema.append("</Level>");
                    }
                    if (timeModelMeta.getUseDay()) {
                        sbSchema.append("<Level name=\"Day\" caption=\"\" column=\"FDay\" type=\"Days\" isDateTimeColumn=\"false\">");
                        sbSchema.append("</Level>");
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                catch (JDOMException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                finally {
                    SQLUtils.cleanup((Connection)con);
                }
            }
            sbSchema.append("</Hierarchy>");
            sbSchema.append("</Dimension>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCubDef(StringBuffer sbSchema, AppModelView apv, AppModel am, Context ctx) throws SQLException {
        sbSchema.append("<Cube name=\"bimodelTest\" ");
        sbSchema.append("caption=\"BICube\" ");
        sbSchema.append("table=\"fact_app\">");
        List dvList = apv.getDimRef().getDimensionViews();
        int dvCount = dvList.size();
        for (int i = 0; i < dvCount; ++i) {
            DimensionView dv = (DimensionView)dvList.get(i);
            DimensionMeta dm = dv.getDimensionDef();
            String typename = dm.getType();
            if (!dm.isMeasure()) {
                sbSchema.append("<DimensionUsage name=\"" + typename + "\" ");
                sbSchema.append("foreignKey=\"" + dm.getFKFieldName() + "\"/>");
                continue;
            }
            MeasureDimension md = (MeasureDimension)am.getDimension(typename);
            Connection cn = null;
            List measures = null;
            try {
                cn = BISystem.getJdbcConnection((Context)ctx);
                measures = md.getMembers(cn, ctx, true, true);
                int mCount = measures.size();
                for (int j = 0; j < mCount; ++j) {
                    String number = (String)measures.get(j);
                    String caption = (String)md.findProperty(number, "name", cn);
                    String format = (String)md.findProperty(number, "format", cn);
                    String agg = (String)md.findProperty(number, "agg", cn);
                    sbSchema.append("<Measure name=\"" + number + "\" ");
                    sbSchema.append("caption=\"" + caption + "\" ");
                    sbSchema.append("column=\"" + MeasureDimensionMeta.getMeasureField(number) + "\" ");
                    sbSchema.append("aggregator=\"" + agg + "\" ");
                    sbSchema.append("formatString=\"" + format + "\"/>");
                }
                continue;
            }
            finally {
                SQLUtils.cleanup((Connection)cn);
            }
        }
        sbSchema.append("</Cube>");
    }

    private InputStream createCube(AppModelView apv, AppModel am, Context ctx) throws SQLException {
        ByteArrayInputStream is = null;
        StringBuffer sbSchema = new StringBuffer();
        sbSchema.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sbSchema.append("<Schema name=\"OLAP TEST\">");
        this.createTableRef(sbSchema, apv);
        this.createDimensionDef(sbSchema, apv, ctx);
        this.createCubDef(sbSchema, apv, am, ctx);
        sbSchema.append("</Schema>");
        try {
            is = new ByteArrayInputStream(sbSchema.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return is;
    }

    public InputStream getDataSourceStream() {
        return this.isDataSource;
    }

    private InputStream createDataSource(AppModelView apv) {
        StringBuffer sbDataSource = new StringBuffer();
        ByteArrayInputStream is = null;
        sbDataSource.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        String pubnumber = apv.getPubnumber();
        sbDataSource.append("<DataSource name=\"OLAP\">");
        int len = apv.getDimRef().getDimensionViews().size();
        for (int i = 0; i < len; ++i) {
            DimensionView dv = (DimensionView)apv.getDimRef().getDimensionViews().get(i);
            DimensionMeta dm = dv.getDimensionDef();
            String typename = dm.getType();
            if (!dv.isMeasure()) {
                sbDataSource.append("<Table name=\"t_dim_" + typename + "\">");
                sbDataSource.append("<Sql><![CDATA[");
                if ("year".equalsIgnoreCase(dm.getType())) {
                    String yearField = dm.getBizKey();
                    sbDataSource.append("select " + yearField + ", CONCAT(tochar(" + yearField + "), '\u5e74') as FName from " + dm.getTablename(pubnumber) + " where fflag <> 1");
                } else if ("period".equalsIgnoreCase(dm.getType())) {
                    String periodField = dm.getBizKey();
                    String periodParentField = dm.getParentNumber();
                    sbDataSource.append("select " + periodField + "," + periodParentField + ",case when " + periodField + "> 100 then concat(tochar(fperiod - 100),'\u5b63\u5ea6') else concat(tochar(" + periodField + "),'\u671f') end as FName from " + dm.getTablename(pubnumber) + " where fflag <> 1");
                } else if (dm.getDimensionType().isTime()) {
                    sbDataSource.append("select FID,FYear,FHalfYear,FQuarter,FMonth,FDay,FTime,");
                    sbDataSource.append("concat(tochar(FYear),'\u5e74') as FYearName,");
                    sbDataSource.append("case when FHalfYear=1 then'\u4e0a\u534a\u5e74' else '\u4e0b\u534a\u5e74' end as FHalfYearName,");
                    sbDataSource.append("concat(tochar(FQuarter),'\u5b63\u5ea6') as FQuarterName,");
                    sbDataSource.append("concat(tochar(FMonth),'\u6708') as FMonthName,");
                    sbDataSource.append("concat(tochar(FDay),'\u65e5') as FDayName ");
                    sbDataSource.append("from ").append(dm.getTablename(pubnumber));
                } else {
                    sbDataSource.append("select * from " + dm.getTablename(pubnumber));
                }
                sbDataSource.append("]]></Sql>");
                sbDataSource.append("</Table>");
                continue;
            }
            sbDataSource.append("<Table name=\"fact_app\">");
            sbDataSource.append("<Sql><![CDATA[");
            sbDataSource.append("select * from " + Fact.getTablename(pubnumber));
            sbDataSource.append("]]></Sql>");
            sbDataSource.append("</Table>");
        }
        sbDataSource.append("</DataSource>");
        try {
            is = new ByteArrayInputStream(sbDataSource.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return is;
    }

    private String getSetMDX(String dimtypename, String setname) {
        String mdx = "";
        if ("$All".equalsIgnoreCase(setname)) {
            mdx = dimtypename + ".members";
        }
        return mdx;
    }

    private void handleRowColumn(boolean isRow, StringBuffer sbMDX) {
        Element re = null;
        List columns = null;
        List rowSets = null;
        if (isRow) {
            re = (Element)this.doc.selectSingleNode("/AnalysisReport/Layout/Row");
            columns = this.doc.selectNodes("/AnalysisReport/Layout/Row/Dim");
            rowSets = this.doc.selectNodes("/AnalysisReport/Layout/Row/RowSet");
        } else {
            re = (Element)this.doc.selectSingleNode("/AnalysisReport/Layout/Col");
            columns = this.doc.selectNodes("/AnalysisReport/Layout/Column/Dim");
            rowSets = this.doc.selectNodes("/AnalysisReport/Layout/Column/RowSet");
        }
        boolean isEmpty = "true".equalsIgnoreCase(re.attributeValue("IsEmpty"));
        if (isEmpty) {
            sbMDX.append("non empty(");
        }
        int lenRS = rowSets.size();
        for (int i = 0; i < lenRS; ++i) {
            if (i > 0) {
                sbMDX.append(",");
            }
            sbMDX.append("{");
            Element rowset = (Element)rowSets.get(i);
            int lenDim = columns.size();
            for (int j = 0; j < lenDim; ++j) {
                String dimtypename;
                if (j > 0) {
                    sbMDX.append("*");
                }
                String dimMDXName = "measure".equalsIgnoreCase(dimtypename = ((Element)columns.get(j)).attributeValue("name")) ? "measures" : dimtypename;
                Node cell = rowset.selectSingleNode("Cell[@dim='" + dimtypename + "']");
                if (cell != null) {
                    int lenItem;
                    List items = cell.selectNodes("Item");
                    if (items == null || (lenItem = items.size()) <= 0) continue;
                    sbMDX.append("{");
                    for (int m = 0; m < lenItem; ++m) {
                        String itemType;
                        if (m > 0) {
                            sbMDX.append(",");
                        }
                        if ("Set".equalsIgnoreCase(itemType = ((Element)items.get(m)).attributeValue("type"))) {
                            String setname = ((Node)items.get(m)).getText();
                            sbMDX.append(this.getSetMDX(dimMDXName, setname));
                            continue;
                        }
                        if (!"Member".equalsIgnoreCase(itemType)) continue;
                        String member = ((Node)items.get(m)).getText();
                        sbMDX.append(dimMDXName + ".[" + member + "]");
                    }
                    sbMDX.append("}");
                    continue;
                }
                sbMDX.append(dimtypename + ".members");
            }
            sbMDX.append("}");
        }
        if (isEmpty) {
            sbMDX.append(")");
        }
        if (isRow) {
            sbMDX.append(" on rows");
        } else {
            sbMDX.append(" on columns");
        }
    }

    private void handelSlicer(StringBuffer sbMDX) {
        boolean slicerVisible = true;
        Element slicer = (Element)this.doc.selectSingleNode("/AnalysisReport/Layout/Slicer");
        if (slicer != null) {
            int cellLen;
            slicerVisible = !"false".equalsIgnoreCase(slicer.attributeValue("visible"));
            for (Element e : slicer.selectNodes("./Dim")) {
                String dimtypename = e.attributeValue("name");
                boolean bl = !"false".equalsIgnoreCase("visible");
            }
            List cells = slicer.selectNodes("./Default/Cell");
            if (cells != null && (cellLen = cells.size()) > 0) {
                sbMDX.append(" where (");
                for (int i = 0; i < cellLen; ++i) {
                    Node o;
                    String itemType;
                    Element cell = (Element)cells.get(i);
                    String dimtypename = cell.attributeValue("dim");
                    if (i > 0) {
                        sbMDX.append(",");
                    }
                    if (!"member".equalsIgnoreCase(itemType = ((Element)(o = cell.selectSingleNode("./Item"))).attributeValue("type"))) continue;
                    String member = o.getText();
                    sbMDX.append(dimtypename + ".[" + member + "]");
                }
                sbMDX.append(")");
            }
        }
    }

    public FilterScheme[] getFilterSchemes(Repository rep) throws BIReportException {
        return null;
    }

    public BILayout getLayout() {
        return null;
    }

    public List getLinks(String schemeName) {
        return null;
    }

    public String getPath() {
        return this.reportID;
    }

    public List getSchemeList() {
        ArrayList<BIReportScheme> ret = new ArrayList<BIReportScheme>();
        PageSetup ps = this.bim.getLayout().getPageSetup();
        String schemeTitle = ps.getTitle();
        String schemeMemoHead = ps.getMemHead();
        String schemeMemoTail = ps.getMemTail();
        String schemeChartLayout = "";
        int perPageRows = ps.getPerPageRows();
        BIReportScheme scheme = new BIReportScheme(this.getName(), this.getCaption(), this.mdx, schemeTitle, schemeMemoHead, schemeMemoTail, schemeChartLayout, perPageRows);
        ret.add(scheme);
        return ret;
    }

    public BISubject getSubject() {
        return new BIMSubject();
    }

    public String getSubjectPath() {
        return "";
    }

    public List getWorklists() {
        return null;
    }

    public void setRepositoryPath(String repPath) {
        this.repositoryPath = repPath;
    }

    public void setDatacenter(String datacenter) {
        this.dataCenterName = datacenter;
    }

    public boolean isDefaultOpenDataDrill() {
        BIReportComponents comLst = this.bim.getLayout().getComponents();
        BIReportBean reportBean = comLst.getReportBean();
        String value = String.valueOf(reportBean.getProp("defaultOpenDataDrill"));
        return value.equalsIgnoreCase("true");
    }
}

