/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.bireport.calmember.accum;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.rt.appmodel.AppModel;
import com.kingdee.bos.bi.model.rt.appmodel.AppModelView;
import com.kingdee.bos.bi.model.rt.bireport.calmember.CalMember;
import com.kingdee.bos.bi.model.rt.bireport.calmember.CalculatorType;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.rt.dim.DimensionMeta;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.rt.dim.FormatString;
import com.kingdee.bos.bi.model.rt.dim.Member;
import com.kingdee.bos.bi.model.ui.dialog.bireport.calmember.CalSelProvider;
import com.kingdee.bos.bi.model.ui.dialog.bireport.calmember.accum.AccumDetailPanel;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.bi.model.util.XmlUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class AccumCalMember
extends CalMember {
    private String calMeasure;
    private String calDim;
    private String accumCalRange;
    private int solveOrder;
    private String formatString;
    private String appModelType;
    private List advances;

    public AccumCalMember(Context ctx, String appmodelId, Dimension dim, String name, String caption, DimensionType dt, String schema) {
        super(ctx, appmodelId, dim, name, caption, dt, CalculatorType.accum);
        try {
            this.fromXML(schema);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toMDX() {
        StringBuffer sb = new StringBuffer();
        sb.append(" member [");
        sb.append("measures].[" + this.number);
        sb.append("] as '");
        sb.append(this.getMdx());
        sb.append("'");
        sb.append(",solveOrder=" + this.solveOrder + "");
        if (this.formatString != null) {
            sb.append(",formatString='" + this.formatString + "'");
        }
        if (!StringUtil.isEmpty(this.name)) {
            sb.append(",caption='" + this.name + "'");
        }
        return sb.toString();
    }

    private String getMdx() {
        StringBuffer sb = new StringBuffer();
        if (!"common".equalsIgnoreCase(this.appModelType)) {
            if ("allMember".equalsIgnoreCase(this.accumCalRange)) {
                sb.append("sum({{Year.currentmember.firstsibling:Year.currentmember.prevmember}*Period.currentmember.level.members,Year.currentmember*{Period.currentMember.FirstSibling : Period.currentMember}},measures.[" + this.calMeasure + "])");
            } else if ("brotherMember".equalsIgnoreCase(this.accumCalRange)) {
                sb.append("sum(Period.currentMember.FirstSibling : Period.currentMember,measures.[" + this.calMeasure + "])");
            }
        } else {
            String timeDim = this.getTimeDim();
            if ("allMember".equalsIgnoreCase(this.accumCalRange)) {
                sb.append("sum(" + timeDim + ".currentmember.level.firstmember : " + timeDim + ".currentMember,measures.[" + this.calMeasure + "])");
            } else if ("brotherMember".equalsIgnoreCase(this.accumCalRange)) {
                sb.append("sum(" + timeDim + ".currentMember.FirstSibling : " + timeDim + ".currentMember,measures.[" + this.calMeasure + "])");
            }
        }
        return sb.toString();
    }

    private String getTimeDim() {
        try {
            AppModelView views = AppModelView.fromDB(this.appmodelId, this.ctx);
            AppModel apm = new AppModel(views, this.ctx);
            int len = apm.getDimTypes().length;
            for (int i = 0; i < len; ++i) {
                DimensionType dt = apm.getDimTypes()[i];
                String innerTime = dt.getInnerType();
                if (!"time".equalsIgnoreCase(innerTime)) continue;
                return apm.getDimTypes()[i].getName();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return "";
    }

    public int getFormatStringIndex(AccumDetailPanel accumDetailPanel) {
        int i = accumDetailPanel.cmbFormatString.getItemCount();
        for (int y = 0; y < i; ++y) {
            FormatString format = (FormatString)accumDetailPanel.cmbFormatString.getItemAt(y);
            if (!format.getName().equals(this.formatString)) continue;
            return y;
        }
        return 0;
    }

    private void fromXML(String xml) throws IOException, JDOMException {
        if (StringUtil.isEmpty(xml)) {
            this.solveOrder = 1;
            return;
        }
        Element e = XmlUtil.toRootElement(xml);
        this.calMeasure = e.getAttributeValue("calMeasure");
        this.calDim = e.getAttributeValue("calDim");
        this.accumCalRange = e.getAttributeValue("accumCalRange");
        this.formatString = e.getAttributeValue("formatString");
        this.appModelType = e.getAttributeValue("appModelType");
        this.solveOrder = 1;
        try {
            this.solveOrder = Integer.parseInt(e.getAttributeValue("solveOrder"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        List eles = e.getChildren("measure");
        if (eles == null || eles.size() > 0) {
            // empty if block
        }
    }

    @Override
    public String getSchema() {
        StringBuffer sb = new StringBuffer();
        sb.append("");
        sb.append("");
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        sb.append("<Accumulate");
        sb.append(" calMeasure=\"" + this.calMeasure + "\"");
        sb.append(" calDim=\"" + this.calDim + "\"");
        sb.append(" accumCalRange=\"" + this.accumCalRange + "\"");
        sb.append(" formatString=\"" + this.formatString + "\"");
        sb.append(" appModelType=\"" + this.appModelType + "\"");
        sb.append(" solveOrder=\"" + this.solveOrder + "\" >");
        sb.append("</Accumulate>");
        return sb.toString();
    }

    public int getCalMeasureIndex(AccumDetailPanel accumDetailPanel) {
        int i = accumDetailPanel.calMeasure.getItemCount();
        for (int y = 0; y < i; ++y) {
            Member measure = (Member)accumDetailPanel.calMeasure.getItemAt(y);
            String number = measure.getNumber();
            if (!number.equals(this.calMeasure)) continue;
            return y;
        }
        return 0;
    }

    public int getCalDimIndex(AccumDetailPanel accumDetailPanel) {
        int i = accumDetailPanel.calDimension.getItemCount();
        for (int y = 0; y < i; ++y) {
            DimensionMeta dim = (DimensionMeta)accumDetailPanel.calDimension.getItemAt(y);
            String number = dim.getDimensionType().getName();
            if (!number.equals(this.calDim)) continue;
            return y;
        }
        return 0;
    }

    public int getSolveOrder() {
        return this.solveOrder;
    }

    public int getAccumCalRangeIndex(AccumDetailPanel accumDetailPanel) {
        int i = accumDetailPanel.accumCalRange.getItemCount();
        for (int y = 0; y < i; ++y) {
            CalSelProvider calRange = (CalSelProvider)accumDetailPanel.accumCalRange.getItemAt(y);
            if (!calRange.getName().equals(this.accumCalRange)) continue;
            return y;
        }
        return 0;
    }

    @Override
    public String toMDX(Dimension dim, Context ctx) {
        return null;
    }
}

