/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.dim;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.bi.model.DB.Field;
import com.kingdee.bos.bi.model.rt.dim.DimensionMeta;
import com.kingdee.bos.bi.model.rt.dim.DimensionMetaFactory;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.rt.dim.Member;
import com.kingdee.bos.bi.model.rt.dim.Property;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.service.impl.MMViewService;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.ctrl.analysis.web.appmodel.AbstractTreeNode;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.swing.tree.MutableTreeNode;

public abstract class DimensionView
implements Serializable {
    protected String id;
    protected String view_table;
    public String fieldNumber;
    public String fieldName;
    public String fieldViewId;
    protected DimensionMeta dm;

    public DimensionView(DimensionType dt, String id, String view_table, Context ctx) {
        this.id = id;
        this.view_table = view_table;
        this.dm = DimensionMetaFactory.createDimensionMeta(dt, ctx);
    }

    public DimensionView(IManagementFacade facade, DimensionType dt, String id, String view_table) {
        this.id = id;
        this.view_table = view_table;
        this.dm = DimensionMetaFactory.createDimensionMeta(facade, dt);
    }

    public DefaultKingdeeTreeNode getRootMember(IManagementFacade facade) throws BIModelRemoteException {
        DefaultKingdeeTreeNode rootNode = new DefaultKingdeeTreeNode();
        rootNode.add((MutableTreeNode)this.modelToCtrl(this.getRootNode(facade)));
        return rootNode;
    }

    public Object[] getPropertyValues(IManagementFacade facade, Property prop) throws BIModelRemoteException {
        try {
            return new MMViewService(facade).getPropertyValues(this, prop);
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
    }

    private DefaultKingdeeTreeNode modelToCtrl(AbstractTreeNode moNode) {
        DefaultKingdeeTreeNode ctrlNode = new DefaultKingdeeTreeNode();
        this.initCtrlNode(ctrlNode, moNode);
        int c = moNode.getChildCount();
        for (int i = 0; i < c; ++i) {
            AbstractTreeNode moChild = moNode.getChildNode(i);
            DefaultKingdeeTreeNode ctrlChild = this.modelToCtrl(moChild);
            ctrlNode.add((MutableTreeNode)ctrlChild);
        }
        return ctrlNode;
    }

    private void initCtrlNode(DefaultKingdeeTreeNode ctrlNode, AbstractTreeNode moNode) {
        ctrlNode.setUserObject((Object)moNode);
        ctrlNode.setText(moNode.getModel().getName());
    }

    public abstract AbstractTreeNode getRootNode(IManagementFacade var1) throws BIModelRemoteException;

    public Member[] getMembers(IManagementFacade facade) throws SQLException {
        return new MMViewService(facade).getMembers(this);
    }

    public Member[] getMembers(Context ctx) throws SQLException {
        return new MMViewService(ctx).getMembers(this);
    }

    public Member findMember(IManagementFacade facade, String number) throws SQLException {
        return this._findMember(this.getMembers(facade), number);
    }

    public Member findMember(Context ctx, String number) throws SQLException {
        return this._findMember(this.getMembers(ctx), number);
    }

    private Member _findMember(Member[] ms, String number) {
        int len = ms.length;
        for (int i = 0; i < len; ++i) {
            if (!ms[i].getNumber().equals(number)) continue;
            return ms[i];
        }
        return null;
    }

    public String getTablename() {
        return this.view_table;
    }

    public String getId() {
        return this.id;
    }

    public boolean isMeasure() {
        return this.dm.isMeasure();
    }

    public DimensionMeta getDimensionDef() {
        return this.dm;
    }

    public void publish(String pubNumber, Connection cn, int order) throws SQLException {
        String index;
        String tablename = this.dm.getTablename(pubNumber);
        DBUtil.createTable(tablename, this.id, this.dm.getFields(), this.dm.hasCreateInnerID(), cn);
        this.transData(pubNumber, cn);
        String fieldPK = this.dm.getPK();
        if (fieldPK != null) {
            String pkname = this.dm.getPKName(pubNumber, order);
            DBUtil.createPK(tablename, fieldPK, pkname, cn);
        }
        if ((index = this.dm.getIndex()) != null) {
            String indexname = this.dm.getIndexName(pubNumber, order);
            DBUtil.createIndex(tablename, index, indexname, cn);
        }
    }

    public void unpublish(String pubNumber, Connection cn) throws SQLException {
        DBUtil.dropTable(this.dm.hasCreateInnerID(), this.dm.getTablename(pubNumber), cn);
    }

    public void synModel(String pubNumber, Connection cn, int order) throws SQLException {
        String indexname;
        String tablename = this.dm.getTablename(pubNumber);
        String index = this.dm.getIndex();
        if (index != null) {
            indexname = this.dm.getIndexName(pubNumber, order);
            DBUtil.dropIndex(tablename, indexname, cn);
        }
        try {
            if (this.dm.getPK() != null) {
                String pkname = this.dm.getPKName(pubNumber, order);
                DBUtil.dropPK(tablename, pkname, cn);
            }
        }
        catch (SQLException pkname) {
            // empty catch block
        }
        this.synData(pubNumber, this.id, cn);
        try {
            String fieldPK = this.dm.getPK();
            if (fieldPK != null) {
                String pkname = this.dm.getPKName(pubNumber, order);
                DBUtil.createPK(tablename, fieldPK, pkname, cn);
            }
        }
        catch (SQLException fieldPK) {
            // empty catch block
        }
        if (index != null) {
            indexname = this.dm.getIndexName(pubNumber, order);
            DBUtil.createIndex(tablename, index, indexname, cn);
        }
    }

    protected void synData(String pubNumber, String viewid, Connection cn) throws SQLException {
        String tablename = this.dm.getTablename(pubNumber);
        String bizKey = this.dm.getBizKey();
        String viewSql = "select " + bizKey + " from " + this.getTablename() + " where FViewID='" + viewid + "'";
        String sql = "update " + tablename + " set FFlag = 1 where " + bizKey + " not in (" + viewSql + ")";
        DBUtil.executeUpdate(sql, cn);
        this.compareAndUpdateData(pubNumber, viewid, cn);
        String where = bizKey + " not in (select " + bizKey + " from " + tablename + ")";
        DBUtil.insertIntoSelect(tablename, this.dm.hasCreateInnerID(), this.dm.getFields(), this.view_table, viewid, where, cn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compareAndUpdateData(String pubNumber, String viewid, Connection cn) throws SQLException {
        String compareKeyField = "FID";
        if (!this.dm.hasCreateInnerID()) {
            compareKeyField = this.dm.getBizKey();
        }
        String tablename = this.dm.getTablename(pubNumber);
        PreparedStatement stmt = null;
        try {
            Field f;
            int i;
            StringBuffer sb = new StringBuffer();
            sb.append("update " + tablename);
            sb.append(" set ");
            List fields = this.dm.getFields();
            int len = fields.size();
            for (i = 0; i < len; ++i) {
                f = (Field)fields.get(i);
                if (f.value != null) continue;
                sb.append(f.name + "=?,");
            }
            sb.append("FLastUpdateTime=getdate(),FFlag=0");
            sb.append(" where " + compareKeyField + "=?");
            sb.append(" and (");
            for (i = 0; i < len; ++i) {
                f = (Field)fields.get(i);
                if (f.value != null) continue;
                if (i > 0) {
                    sb.append(" or ");
                }
                if (f.type.indexOf("char") != -1) {
                    sb.append("?<>isnull(" + f.name + ",' ')");
                    continue;
                }
                if (f.type.indexOf("varchar") != -1) {
                    sb.append("?<>isnull(" + f.name + ",0)");
                    continue;
                }
                sb.append(f.name + "<>? ");
            }
            sb.append(")");
            stmt = cn.prepareStatement(sb.toString());
            String bizKey = this.dm.getBizKey();
            String sql = "select " + tablename + "." + compareKeyField + "," + this.view_table + ".* from " + tablename + " inner JOIN " + this.view_table + " ON " + tablename + "." + bizKey + "=" + this.view_table + "." + bizKey + " and " + this.view_table + ".FViewID='" + viewid + "'";
            RDRowSet rs = DBUtil.executeQuery(sql, cn);
            while (rs.next()) {
                Object o;
                Field f2;
                int i2;
                Object key = rs.getObject(compareKeyField);
                len = fields.size();
                int counter = 1;
                for (i2 = 0; i2 < len; ++i2) {
                    f2 = (Field)fields.get(i2);
                    if (f2.value != null) continue;
                    o = rs.getObject(f2.name);
                    if (o == null) {
                        stmt.setNull(counter++, rs.getColumnType(f2.name));
                        continue;
                    }
                    stmt.setObject(counter++, o);
                }
                stmt.setObject(counter++, key);
                for (i2 = 0; i2 < len; ++i2) {
                    f2 = (Field)fields.get(i2);
                    if (f2.value != null) continue;
                    o = rs.getObject(f2.name);
                    if (f2.type.indexOf("char") != -1) {
                        if (StringUtils.isEmpty((String)((String)o))) {
                            stmt.setString(counter++, "  ");
                            continue;
                        }
                        stmt.setString(counter++, (String)o);
                        continue;
                    }
                    if (o == null) {
                        stmt.setNull(counter++, rs.getColumnType(f2.name));
                        continue;
                    }
                    stmt.setObject(counter++, o);
                }
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(stmt);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)stmt);
    }

    protected void transData(String pubnumber, Connection cn) throws SQLException {
        DBUtil.insertIntoSelect(this.dm.getTablename(pubnumber), this.dm.hasCreateInnerID(), this.dm.getFields(), this.getTablename(), this.id, null, cn);
    }
}

