/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.dim.custom.general;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.bi.model.common.mm.org.OrgDimensionNode;
import com.kingdee.bos.bi.model.common.mm.org.OrgModel;
import com.kingdee.bos.bi.model.rt.appmodel.AppModel;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.rt.dim.DimensionMeta;
import com.kingdee.bos.bi.model.rt.fact.Fact;
import com.kingdee.bos.bi.model.security.SecureUtil;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GeneralDimension
extends Dimension {
    public GeneralDimension(AppModel appmodel, DimensionMeta df) {
        super(appmodel, df);
    }

    @Override
    protected int getMaxCacheSize() {
        return 200;
    }

    public List getMembers(Connection cn, Context ctx, boolean bPermissionFilter) throws SQLException {
        String sqlPermission;
        String tablename = this.dm.getTablename(this.appmodel.getPubnumber());
        StringBuffer sb = new StringBuffer();
        sb.append("select * from ");
        sb.append(tablename);
        sb.append(" where FFlag<>1  or FFlag is NULL  ");
        sb.append(" order by FParentNumber, FOrder");
        String sql = sb.toString();
        if (bPermissionFilter && !StringUtils.isEmpty((String)(sqlPermission = SecureUtil.getRowSecureSQL(ctx, this)))) {
            sql = "select * from (" + sql + ") as xxx where " + sqlPermission;
        }
        RDRowSet rowset = DBUtil.executeQuery(sql, cn);
        rowset.reset();
        if (rowset.isEof()) {
            return null;
        }
        HashMap<String, ArrayList<OrgDimensionNode>> mapForTree = new HashMap<String, ArrayList<OrgDimensionNode>>();
        OrgDimensionNode rootNode = null;
        while (rowset.next()) {
            String number = rowset.getString("FNumber");
            String name = rowset.getString("FName");
            String parentNumber = rowset.getString("FParentNumber");
            OrgModel model = new OrgModel();
            model.setNumber(number);
            model.setName(name);
            OrgDimensionNode node = new OrgDimensionNode();
            node.setOrgModel(model);
            if (rootNode == null && (parentNumber == null || parentNumber.equals(number))) {
                rootNode = node;
                continue;
            }
            ArrayList<OrgDimensionNode> children = (ArrayList<OrgDimensionNode>)mapForTree.get(parentNumber);
            if (children == null) {
                children = new ArrayList<OrgDimensionNode>();
                mapForTree.put(parentNumber, children);
            }
            children.add(node);
        }
        if (rootNode != null) {
            this.buildOrgTree(rootNode, mapForTree);
        }
        ArrayList<String> lstRet = new ArrayList<String>();
        if (null != rootNode) {
            lstRet.add(rootNode.getOrgModel().getNumber());
            this.addNode(lstRet, rootNode);
            Collections.reverse(lstRet);
        }
        return lstRet;
    }

    private void addNode(List lstRet, OrgDimensionNode node) {
        int len = node.getChildCount();
        for (int i = 0; i < len; ++i) {
            lstRet.add(node.getChild(i).getOrgModel().getNumber());
            this.addNode(lstRet, node.getChild(i));
        }
    }

    private void buildOrgTree(OrgDimensionNode parent, Map mapForTree) {
        String number = parent.getOrgModel().getNumber();
        List children = (List)mapForTree.get(number);
        int childrenCount = children == null ? 0 : children.size();
        for (int i = 0; i < childrenCount; ++i) {
            OrgDimensionNode child = (OrgDimensionNode)children.get(i);
            parent.addChild(child);
            this.buildOrgTree(child, mapForTree);
        }
    }

    public Number aggration(String aggType, Map bizMap, Map keyMap, Connection cn) throws SQLException {
        String pubNumber = this.appmodel.getPubnumber();
        StringBuffer sb = new StringBuffer();
        sb.append("select ");
        sb.append(aggType + "(FM_");
        sb.append((String)bizMap.get("measure"));
        sb.append(") from ");
        String type = this.dm.getType();
        sb.append(Fact.getTablename(pubNumber));
        sb.append(" where ");
        sb.append("FOrgID in(");
        sb.append("select FID from ");
        sb.append(this.getTablename());
        sb.append(" where FParentNumber='");
        sb.append((String)bizMap.get(type));
        sb.append("' and FNumber<>'");
        sb.append((String)bizMap.get(type));
        sb.append("') and ");
        sb.append("FPeriodID=");
        sb.append(keyMap.get("period"));
        sb.append(" and ");
        sb.append("FMetricID=");
        sb.append(keyMap.get("metric"));
        sb.append(" and ");
        sb.append("FYearID=");
        sb.append(keyMap.get("year"));
        return (Number)DBUtil.getRecord(sb.toString(), cn);
    }
}

