/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.security.row;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.rt.dim.DimensionMeta;
import com.kingdee.bos.bi.model.security.SecureFilter;
import com.kingdee.bos.bi.model.security.SecureFilterItem;
import com.kingdee.bos.bi.model.security.SecureFilterItems;
import com.kingdee.bos.bi.model.security.SecurityObjectType;
import com.kingdee.bos.bi.model.security.SelSecurityObjects;
import com.kingdee.bos.bi.model.security.exception.BISecurityException;
import com.kingdee.bos.bi.model.security.row.IRowSecure;
import com.kingdee.bos.bi.model.security.ui.FilterMethod;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class RowSecureFilter
extends SecureFilter
implements IRowSecure,
Serializable {
    private static final long serialVersionUID = 1L;
    private FilterMethod fm;

    public RowSecureFilter() {
    }

    public RowSecureFilter(SecureFilterItems filterItems, SelSecurityObjects so, FilterMethod fm) {
        super(filterItems, so);
        this.fm = fm;
    }

    public FilterMethod getFilterMethod() {
        return this.fm;
    }

    public static RowSecureFilter fromXML(String xml, Context ctx, String objectType, String[] objectIds, FilterMethod fm, DimensionMeta dm) throws IOException, JDOMException, BISecurityException {
        Element e = XmlUtil.loadXmlString((String)xml);
        SecureFilterItems sfis = SecureFilterItems.fromNode(e, dm);
        return new RowSecureFilter(sfis, new SelSecurityObjects(objectType, objectIds, ctx), fm);
    }

    @Override
    public String toXML() {
        StringBuffer xb = new StringBuffer();
        xb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        xb.append("<SFilterExp type=\"row\" version=\"1.0\">");
        for (SecureFilterItem item : this.filterItems.getItems()) {
            xb.append(item.toXML());
        }
        xb.append("</SFilterExp>");
        return xb.toString();
    }

    @Override
    public SecurityObjectType getObjectType() {
        return this.sos.getType();
    }

    @Override
    public String toSql(Context ctx, Dimension dim) {
        StringBuffer sb = new StringBuffer();
        if (this.fm.getValue() == 0) {
            sb.append(" not (");
        }
        sb.append(this.filterItems.toSql(ctx));
        if (this.fm.getValue() == 0) {
            sb.append(") ");
        }
        return sb.toString();
    }

    @Override
    public String getSecureType() {
        return "filter";
    }

    @Override
    public boolean match(Context ctx) throws SQLException {
        return this.sos.match(ctx);
    }

    @Override
    public String getFilterInfo() {
        StringBuffer xb = new StringBuffer();
        for (SecureFilterItem item : this.filterItems.getItems()) {
            xb.append(item.getInfo());
        }
        return xb.toString();
    }
}

