/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.security.ui;

import com.kingdee.bos.bi.model.rt.appmodel.AppModelView;
import com.kingdee.bos.bi.model.rt.dim.DimensionMeta;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.rt.dim.DimensionView;
import com.kingdee.bos.bi.model.rt.dim.Member;
import com.kingdee.bos.bi.model.security.Logic;
import com.kingdee.bos.bi.model.security.Operator;
import com.kingdee.bos.bi.model.security.Parenthesis;
import com.kingdee.bos.bi.model.security.SecureFilterItem;
import com.kingdee.bos.bi.model.security.SecureFilterItems;
import com.kingdee.bos.bi.model.security.cell.CellSecureFilter;
import com.kingdee.bos.bi.model.security.ui.ExprException;
import com.kingdee.bos.bi.model.security.ui.RowFilterDialog;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class CellSecureConditionDialog
extends TypicalDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger log = CommonLogger.getLogger(CellSecureConditionDialog.class);
    private AppModelView apv;
    private IManagementFacade facade;
    private Member member;
    private KDLabel lblMember;
    private KDLabel lblMeasure;
    private KDWorkButton btnAddRow1;
    private KDWorkButton btnDelRow1;
    private KDWorkButton btnAddRow2;
    private KDWorkButton btnDelRow2;
    private KDTable tblList1;
    private KDTable tblList2;
    private static final String COL_LEFT_P = "LeftP";
    private static final String COL_RIGHT_P = "RightP";
    private static final String COL_ATTR = "attr";
    private static final String COL_OPERATOR = "operator";
    private static final String COL_MEMBERS = "members";
    private static final String COL_LOGIC = "logic";
    private static final String COL_DIM = "FDim";
    private static final String COL_DIM_CONDITION = "FCondition";

    public CellSecureConditionDialog() {
    }

    public CellSecureConditionDialog(Dialog dialog) {
        super(dialog);
    }

    public CellSecureConditionDialog(Frame frame) {
        super(frame);
    }

    public void setMeasureMember(Member m) {
        this.member = m;
    }

    public void setAppModelView(AppModelView apv) {
        this.apv = apv;
    }

    public void setFacade(IManagementFacade facade) {
        this.facade = facade;
    }

    public void setCurrentValue(CellSecureFilter csf) {
        if (csf == null) {
            return;
        }
        Map mapDimFilterItems = csf.getDimFilterItems();
        if (mapDimFilterItems != null) {
            for (DimensionType dt : mapDimFilterItems.keySet()) {
                SecureFilterItems sfis = (SecureFilterItems)mapDimFilterItems.get(dt);
                this.addDimFilterRow(dt, sfis);
            }
        }
        SecureFilterItems sfis = csf.getFilterItems();
        for (SecureFilterItem sfi : sfis.getItems()) {
            this.addMeasureFilterRow(sfi);
        }
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        Table tbl = thisCell.splitRow(4);
        tbl.rowStyle(0).lockHeight(30);
        tbl.rowStyle(0).setMarginBottom(5);
        tbl.rowStyle(1).lockHeight(200);
        tbl.rowStyle(2).lockHeight(35);
        tbl.rowStyle(2).setMarginBottom(5);
        tbl.rowStyle(2).setMarginTop(5);
        Table tbl01 = tbl.cell(0).splitCol(4);
        parent.add((Component)this.lblMember, tbl01.cell(0));
        parent.add((Component)this.btnAddRow1, tbl01.cell(1));
        parent.add((Component)this.btnDelRow1, tbl01.cell(3));
        tbl01.colStyle(1).lockWidth(80);
        tbl01.colStyle(2).lockWidth(10);
        tbl01.colStyle(3).lockWidth(80);
        parent.add((Component)this.tblList1, tbl.cell(1));
        Table tbl02 = tbl.cell(2).splitCol(4);
        parent.add((Component)this.lblMeasure, tbl02.cell(0));
        parent.add((Component)this.btnAddRow2, tbl02.cell(1));
        parent.add((Component)this.btnDelRow2, tbl02.cell(3));
        tbl02.colStyle(1).lockWidth(80);
        tbl02.colStyle(2).lockWidth(10);
        tbl02.colStyle(3).lockWidth(80);
        parent.add((Component)this.tblList2, tbl.cell(3));
    }

    protected void todoInit() {
        this.lblMember = new KDLabel("\u8bf7\u8bbe\u7f6e\u9700\u8981\u5c4f\u853d\u5ea6\u91cf\u7684\u7ef4\u5ea6\u6210\u5458\uff1a");
        this.lblMeasure = new KDLabel("\u8bf7\u8bbe\u7f6e\u5ea6\u91cf\u503c\u5c4f\u853d\u6761\u4ef6\uff1a");
        this.btnAddRow1 = new KDWorkButton("\u65b0\u589e\u884c");
        this.btnAddRow1.addActionListener((ActionListener)new addRowActionHandler1());
        this.btnDelRow1 = new KDWorkButton("\u5220\u9664\u884c");
        this.btnDelRow1.addActionListener((ActionListener)new delRowActionHandler1());
        this.btnAddRow2 = new KDWorkButton("\u65b0\u589e\u884c");
        this.btnAddRow2.addActionListener((ActionListener)new addRowActionHandler2());
        this.btnDelRow2 = new KDWorkButton("\u5220\u9664\u884c");
        this.btnDelRow2.addActionListener((ActionListener)new delRowActionHandler2());
        this.tblList1 = new KDTable();
        this.tblList2 = new KDTable();
        String[] columnKeys = new String[]{COL_DIM, COL_DIM_CONDITION};
        Object[] headNames = new String[]{"\u7ef4\u5ea6", "\u6210\u5458\u6761\u4ef6"};
        KDTableHelper.initTable((KDTable)this.tblList1, (String[])columnKeys, (Object[])headNames, (Object[][])null);
        this.tblList1.getColumn(COL_DIM).setWidth(100);
        this.tblList1.getColumn(COL_DIM_CONDITION).setWidth(630);
        String[] columnKeys2 = new String[]{COL_LEFT_P, COL_ATTR, COL_OPERATOR, COL_MEMBERS, COL_RIGHT_P, COL_LOGIC};
        Object[] headNames2 = new String[]{"\u5de6\u62ec\u53f7", "\u5ea6\u91cf", "\u6bd4\u8f83\u7b26", "\u6bd4\u8f83\u503c", "\u53f3\u62ec\u53f7", "\u903b\u8f91\u7b26"};
        KDTableHelper.initTable((KDTable)this.tblList2, (String[])columnKeys2, (Object[])headNames2, (Object[][])null);
        this.tblList2.getColumn(COL_LEFT_P).setWidth(60);
        this.tblList2.getColumn(COL_ATTR).setWidth(120);
        this.tblList2.getColumn(COL_OPERATOR).setWidth(80);
        this.tblList2.getColumn(COL_MEMBERS).setWidth(330);
        this.tblList2.getColumn(COL_RIGHT_P).setWidth(60);
        this.tblList2.getColumn(COL_LOGIC).setWidth(80);
    }

    public SecureFilterItems getMeasureFilterItems() {
        SecureFilterItems fi = null;
        try {
            fi = new SecureFilterItems(this.getFilterItems());
        }
        catch (ExprException e) {
            log.error((Object)"\u7ef4\u5ea6\u5b9a\u4e49\u8bed\u6cd5\u9519\u8bef\uff01", (Throwable)e);
        }
        return fi;
    }

    public Map getDimFilterItems() {
        HashMap<DimensionType, SecureFilterItems> mapDimFilterItems = new HashMap<DimensionType, SecureFilterItems>();
        int rows = this.tblList1.getRowCount();
        for (int i = 0; i < rows; ++i) {
            IRow row_RX = this.tblList1.getRow(i);
            DimensionType dt = (DimensionType)row_RX.getCell(0).getValue();
            SecureFilterItems sfi = (SecureFilterItems)row_RX.getCell(1).getValue();
            mapDimFilterItems.put(dt, sfi);
        }
        return mapDimFilterItems;
    }

    private boolean checkSelectedTbl(KDTable tblMain) {
        if (tblMain.getRowCount() == 0 || tblMain.getSelectManager().size() == 0) {
            WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        return true;
    }

    private void delDimFilterRow() {
        if (this.checkSelectedTbl(this.tblList1)) {
            ArrayList selectBlocks = this.tblList1.getSelectManager().getBlocks();
            KDTSelectBlock selectBlock = null;
            for (int i = 0; i < selectBlocks.size(); ++i) {
                selectBlock = (KDTSelectBlock)selectBlocks.get(i);
                if (selectBlock.getTop() != selectBlock.getBottom()) {
                    WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u62e9\u5355\u6761\u8bb0\u5f55\u5220\u9664\uff01", (String)this.getTitle(), (Component)((Object)this));
                    return;
                }
                this.tblList1.removeRow(selectBlock.getTop());
            }
        }
    }

    private void delMeasureFilterRow() {
        if (this.checkSelectedTbl(this.tblList2)) {
            ArrayList selectBlocks = this.tblList2.getSelectManager().getBlocks();
            KDTSelectBlock selectBlock = null;
            for (int i = 0; i < selectBlocks.size(); ++i) {
                selectBlock = (KDTSelectBlock)selectBlocks.get(i);
                if (selectBlock.getTop() != selectBlock.getBottom()) {
                    WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u62e9\u5355\u6761\u8bb0\u5f55\u5220\u9664\uff01", (String)this.getTitle(), (Component)((Object)this));
                    return;
                }
                this.tblList2.removeRow(selectBlock.getTop());
            }
        }
    }

    private void addDimFilterRow(DimensionType dt, SecureFilterItems sfs) {
        IRow row = this.tblList1.addRow();
        ICell cell = row.getCell(0);
        KDComboBox cmbDimType = new KDComboBox();
        List views = this.apv.getDimRef().getDimensionViews();
        for (DimensionView dv : views) {
            if (dv.isMeasure()) continue;
            DimensionType d = dv.getDimensionDef().getDimensionType();
            cmbDimType.addItem((Object)d);
        }
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbDimType));
        cell.setValue((Object)dt);
        cell = row.getCell(1);
        KDPromptBox promFilterCondition = new KDPromptBox();
        promFilterCondition.setEditable(false);
        promFilterCondition.addSelectorListener((SelectorListener)new dimFilterListerner(cell, row));
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promFilterCondition));
        cell.setValue((Object)sfs);
    }

    private void addMeasureFilterRow(SecureFilterItem fi) {
        IRow row_RX = this.tblList2.addRow();
        ICell cell = row_RX.getCell(COL_LEFT_P);
        KDComboBox cmbLeftP = new KDComboBox();
        cmbLeftP.addItem((Object)new Parenthesis(true, 0));
        cmbLeftP.addItem((Object)new Parenthesis(true, 1));
        cmbLeftP.addItem((Object)new Parenthesis(true, 2));
        cmbLeftP.addItem((Object)new Parenthesis(true, 3));
        cmbLeftP.addItem((Object)new Parenthesis(true, 4));
        cmbLeftP.setEditable(false);
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbLeftP));
        if (fi != null) {
            cell.setValue((Object)fi.getLeftP());
        }
        cell = row_RX.getCell(COL_ATTR);
        KDComboBox cmbAttr = new KDComboBox();
        cmbAttr.addItem((Object)this.member);
        cmbLeftP.setEditable(false);
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbAttr));
        cell.setValue((Object)this.member);
        cell = row_RX.getCell(COL_OPERATOR);
        KDComboBox cmbOperator = new KDComboBox();
        Operator[] oprs = Operator.getAllObjs();
        for (int i = 0; i < oprs.length; ++i) {
            if (!oprs[i].isOprNumber()) continue;
            cmbOperator.addItem((Object)oprs[i]);
        }
        cmbOperator.setEditable(false);
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbOperator));
        if (fi != null) {
            cell.setValue((Object)fi.op);
        }
        cell = row_RX.getCell(COL_MEMBERS);
        KDTextField selValue = new KDTextField();
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)selValue));
        if (fi != null) {
            cell.setValue(fi.value);
        }
        cell = row_RX.getCell(COL_RIGHT_P);
        KDComboBox cmbRightP = new KDComboBox();
        cmbRightP.addItem((Object)new Parenthesis(false, 0));
        cmbRightP.addItem((Object)new Parenthesis(false, 1));
        cmbRightP.addItem((Object)new Parenthesis(false, 2));
        cmbRightP.addItem((Object)new Parenthesis(false, 3));
        cmbRightP.addItem((Object)new Parenthesis(false, 4));
        cmbRightP.setEditable(false);
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbRightP));
        if (fi != null) {
            cell.setValue((Object)fi.getRightP());
        }
        cell = row_RX.getCell(COL_LOGIC);
        KDComboBox cmbLogic = new KDComboBox();
        Logic[] logics = Logic.getAllObjs();
        for (int i = 0; i < logics.length; ++i) {
            cmbLogic.addItem((Object)logics[i]);
        }
        cmbLogic.setEditable(false);
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbLogic));
        if (fi != null) {
            cell.setValue((Object)fi.logic);
        }
    }

    protected boolean verify() {
        int rows = this.tblList1.getRowCount();
        ArrayList<String> lstDim = new ArrayList<String>();
        for (int i = 0; i < rows; ++i) {
            IRow row_RX = this.tblList1.getRow(i);
            DimensionType dt = (DimensionType)row_RX.getCell(0).getValue();
            if (dt == null) {
                WindowUtil.msgboxError((Object)("\u7b2c" + (i + 1) + "\u884c\u7ef4\u5ea6\u672a\u9009\u62e9\uff01"), (String)"\u7cfb\u7edf\u8b66\u544a", (Component)this.getRootPane());
                return false;
            }
            if (lstDim.indexOf(dt.getName()) != -1) {
                WindowUtil.msgboxError((Object)(dt.getAlias() + "\u5b58\u5728\u91cd\u590d\u5b9a\u4e49"), (String)"\u7cfb\u7edf\u8b66\u544a", (Component)this.getRootPane());
                return false;
            }
            lstDim.add(dt.getName());
            SecureFilterItems sfi = (SecureFilterItems)row_RX.getCell(1).getValue();
            if (sfi != null) continue;
            WindowUtil.msgboxError((Object)("\u7b2c" + (i + 1) + "\u884c\u6210\u5458\u6761\u4ef6\u672a\u9009\u62e9\uff01"), (String)"\u7cfb\u7edf\u8b66\u544a", (Component)this.getRootPane());
            return false;
        }
        List filterItems = null;
        try {
            filterItems = this.getFilterItems();
            new SecureFilterItems(filterItems).verify();
        }
        catch (ExprException e) {
            WindowUtil.msgboxError((Object)e.getMessage(), (String)"\u7cfb\u7edf\u8b66\u544a", (Component)this.getRootPane());
            return false;
        }
        return true;
    }

    public List getFilterItems() throws ExprException {
        ArrayList<SecureFilterItem> filterItems = new ArrayList<SecureFilterItem>();
        int rows = this.tblList2.getRowCount();
        for (int i = 0; i < rows; ++i) {
            IRow row = this.tblList2.getRow(i);
            Parenthesis lp = (Parenthesis)row.getCell(COL_LEFT_P).getValue();
            int leftP = lp == null ? 0 : lp.getCount();
            Parenthesis left = new Parenthesis(true, leftP);
            Parenthesis rp = (Parenthesis)row.getCell(COL_RIGHT_P).getValue();
            int rightP = rp == null ? 0 : rp.getCount();
            Parenthesis right = new Parenthesis(false, rightP);
            Member measure = (Member)row.getCell(COL_ATTR).getValue();
            if (measure == null) {
                throw new ExprException("\u7b2c" + (i + 1) + "\u884c\u5ea6\u91cf\u672a\u9009\u62e9!");
            }
            Operator op = (Operator)row.getCell(COL_OPERATOR).getValue();
            if (op == null) {
                throw new ExprException("\u7b2c" + (i + 1) + "\u884c\u64cd\u4f5c\u7b26\u672a\u9009\u62e9!");
            }
            Object value = row.getCell(COL_MEMBERS).getValue();
            if (value == null) {
                throw new ExprException("\u7b2c" + (i + 1) + "\u884c\u6570\u503c\u672a\u8f93\u5165!");
            }
            try {
                Double.parseDouble(value.toString());
            }
            catch (NumberFormatException e) {
                throw new ExprException("\u7b2c" + (i + 1) + "\u884c\u4e0d\u5408\u6cd5\u7684\u6570\u503c\u8f93\u5165\uff1a" + value.toString());
            }
            Logic logic = (Logic)row.getCell(COL_LOGIC).getValue();
            if (logic == null && i != rows - 1) {
                throw new ExprException("\u7b2c" + (i + 1) + "\u884c\u903b\u8f91\u7b26\u672a\u9009\u62e9!");
            }
            DimensionMeta dm = this.apv.getDimRef().getMeasureDimensionView().getDimensionDef();
            SecureFilterItem item = new SecureFilterItem(left, measure, op, value, right, logic, dm);
            filterItems.add(item);
        }
        return filterItems;
    }

    class delRowActionHandler2
    implements ActionListener {
        delRowActionHandler2() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CellSecureConditionDialog.this.delMeasureFilterRow();
        }
    }

    class addRowActionHandler2
    implements ActionListener {
        addRowActionHandler2() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CellSecureConditionDialog.this.addMeasureFilterRow(null);
        }
    }

    class delRowActionHandler1
    implements ActionListener {
        delRowActionHandler1() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CellSecureConditionDialog.this.delDimFilterRow();
        }
    }

    class addRowActionHandler1
    implements ActionListener {
        addRowActionHandler1() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CellSecureConditionDialog.this.addDimFilterRow(null, null);
        }
    }

    class dimFilterListerner
    implements SelectorListener {
        ICell cell;
        IRow row;

        public dimFilterListerner(ICell cell, IRow row) {
            this.cell = cell;
            this.row = row;
        }

        public void willShow(SelectorEvent e) {
            DimensionType dt = (DimensionType)this.row.getCell(0).getValue();
            if (dt == null) {
                WindowUtil.msgboxError((Object)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6", (String)"\u7cfb\u7edf\u8b66\u544a", (Component)CellSecureConditionDialog.this.getRootPane());
                return;
            }
            SecureFilterItems sfis = (SecureFilterItems)this.row.getCell(1).getValue();
            RowFilterDialog dlg = (RowFilterDialog)((Object)WindowUtil.createWindow(RowFilterDialog.class, (Component)CellSecureConditionDialog.this.getRootPane()));
            dlg.setSize(800, 600);
            dlg.setTitle("\u7b5b\u9009\u6761\u4ef6\u5b9a\u4e49");
            dlg.setDimensionView(CellSecureConditionDialog.this.apv.getDimRef().getDimensionView(dt.getName()), CellSecureConditionDialog.this.facade);
            dlg.setCurrentValue(sfis);
            if (dlg.showDialog()) {
                this.cell.setValue((Object)dlg.getRowSecureFilterItems());
            }
        }
    }
}

