/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.security.ui;

import com.kingdee.bos.bi.model.rt.dim.DimensionMeta;
import com.kingdee.bos.bi.model.rt.dim.DimensionView;
import com.kingdee.bos.bi.model.rt.dim.Member;
import com.kingdee.bos.bi.model.rt.dim.MemberBaseTreeNode;
import com.kingdee.bos.bi.model.rt.dim.Property;
import com.kingdee.bos.bi.model.security.Logic;
import com.kingdee.bos.bi.model.security.Operator;
import com.kingdee.bos.bi.model.security.Parenthesis;
import com.kingdee.bos.bi.model.security.SecureFilterItem;
import com.kingdee.bos.bi.model.security.SecureFilterItems;
import com.kingdee.bos.bi.model.security.ui.ExprException;
import com.kingdee.bos.bi.model.security.ui.SelViewMemberDialog;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class RowFilterDialog
extends TypicalDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger log = CommonLogger.getLogger(RowFilterDialog.class);
    private KDLabel lblFilterMember;
    private KDWorkButton btnAddRow;
    private KDWorkButton btnDelRow;
    private KDTable tblFilter;
    private DimensionView dv;
    private IManagementFacade facade;
    private static final String COL_LEFT_P = "LeftP";
    private static final String COL_RIGHT_P = "RightP";
    private static final String COL_ATTR = "attr";
    private static final String COL_OPERATOR = "operator";
    private static final String COL_MEMBERS = "members";
    private static final String COL_LOGIC = "logic";

    public RowFilterDialog() {
    }

    public RowFilterDialog(Frame owner) {
        super(owner);
    }

    public RowFilterDialog(Dialog owner) {
        super(owner);
    }

    public void setDimensionView(DimensionView dv, IManagementFacade facade) {
        this.dv = dv;
        this.facade = facade;
    }

    public void setCurrentValue(SecureFilterItems sfis) {
        if (sfis == null) {
            return;
        }
        for (SecureFilterItem sfi : sfis.getItems()) {
            this.addFilterRow(sfi);
        }
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        Table tbl = thisCell.splitRow(2);
        tbl.rowStyle(0).lockHeight(30);
        tbl.rowStyle(0).setMarginBottom(5);
        Table tblTop = tbl.cell(0).splitCol(4);
        parent.add((Component)this.lblFilterMember, tblTop.cell(0));
        parent.add((Component)this.btnAddRow, tblTop.cell(1));
        parent.add((Component)this.btnDelRow, tblTop.cell(3));
        tblTop.colStyle(1).lockWidth(80);
        tblTop.colStyle(2).lockWidth(10);
        tblTop.colStyle(3).lockWidth(80);
        parent.add((Component)this.tblFilter, tbl.cell(1));
    }

    private void addFilterRow(SecureFilterItem fi) {
        IRow row_RX = this.tblFilter.addRow();
        ICell cell = row_RX.getCell(COL_LEFT_P);
        KDComboBox cmbLeftP = new KDComboBox();
        cmbLeftP.addItem((Object)new Parenthesis(true, 0));
        cmbLeftP.addItem((Object)new Parenthesis(true, 1));
        cmbLeftP.addItem((Object)new Parenthesis(true, 2));
        cmbLeftP.addItem((Object)new Parenthesis(true, 3));
        cmbLeftP.addItem((Object)new Parenthesis(true, 4));
        cmbLeftP.setEditable(false);
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbLeftP));
        if (fi != null) {
            cell.setValue((Object)fi.getLeftP());
        }
        cell = row_RX.getCell(COL_ATTR);
        KDComboBox cmbAttr = new KDComboBox();
        List props = this.dv.getDimensionDef().getProperties();
        if (props != null && props.size() > 0) {
            boolean hasInsDefault = false;
            for (Property prop : props) {
                if (!prop.isInner()) {
                    cmbAttr.addItem((Object)prop);
                    continue;
                }
                if (hasInsDefault) continue;
                prop.setAlias(this.dv.getDimensionDef().getDimensionType().getAlias());
                cmbAttr.addItem((Object)prop);
                hasInsDefault = true;
            }
        }
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbAttr));
        Property curProp = null;
        if (fi != null) {
            if (fi.prop.isInner()) {
                fi.prop.setAlias(this.dv.getDimensionDef().getDimensionType().getAlias());
            }
            cell.setValue((Object)fi.prop);
            curProp = fi.prop;
        } else {
            cell.setValue(cmbAttr.getItemAt(0));
            curProp = (Property)cmbAttr.getItemAt(0);
        }
        cell = row_RX.getCell(COL_OPERATOR);
        KDComboBox cmbOperator = new KDComboBox();
        this.loadOperator(curProp, cmbOperator);
        cmbOperator.setEditable(false);
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbOperator));
        if (fi != null) {
            cell.setValue((Object)fi.op);
        }
        cell = row_RX.getCell(COL_MEMBERS);
        KDPromptBox selMembers = new KDPromptBox();
        selMembers.addSelectorListener((SelectorListener)new selMemberListerner(cell, row_RX));
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)selMembers));
        if (fi != null) {
            cell.setValue(fi.value);
        }
        selMembers.setHistoryRecordName("STO_SECRURITY_MEMBERS");
        Operator opNow = (Operator)row_RX.getCell(COL_OPERATOR).getValue();
        if (opNow != null) {
            if (Operator.METHOD_INPUT.equalsIgnoreCase(opNow.getMethod())) {
                selMembers.setEditable(true);
            } else {
                selMembers.setEditable(false);
            }
        }
        cell = row_RX.getCell(COL_RIGHT_P);
        KDComboBox cmbRightP = new KDComboBox();
        cmbRightP.addItem((Object)new Parenthesis(false, 0));
        cmbRightP.addItem((Object)new Parenthesis(false, 1));
        cmbRightP.addItem((Object)new Parenthesis(false, 2));
        cmbRightP.addItem((Object)new Parenthesis(false, 3));
        cmbRightP.addItem((Object)new Parenthesis(false, 4));
        cmbRightP.setEditable(false);
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbRightP));
        if (fi != null) {
            cell.setValue((Object)fi.getRightP());
        }
        cell = row_RX.getCell(COL_LOGIC);
        KDComboBox cmbLogic = new KDComboBox();
        Logic[] logics = Logic.getAllObjs();
        for (int i = 0; i < logics.length; ++i) {
            cmbLogic.addItem((Object)logics[i]);
        }
        cmbLogic.setEditable(false);
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbLogic));
        if (fi != null) {
            cell.setValue((Object)fi.logic);
        }
    }

    private void loadOperator(Property curProp, KDComboBox cmb) {
        cmb.removeAllItems();
        if (curProp == null) {
            return;
        }
        if (curProp.isInner()) {
            cmb.addItem((Object)Operator.equals);
            cmb.addItem((Object)Operator.include);
            cmb.addItem((Object)Operator.notInclude);
        } else {
            Operator[] oprs = Operator.getAllObjs();
            for (int i = 0; i < oprs.length; ++i) {
                cmb.addItem((Object)oprs[i]);
            }
        }
    }

    private void delFilterRow() {
        if (this.checkSelectedTbl(this.tblFilter)) {
            ArrayList selectBlocks = this.tblFilter.getSelectManager().getBlocks();
            KDTSelectBlock selectBlock = null;
            for (int i = 0; i < selectBlocks.size(); ++i) {
                selectBlock = (KDTSelectBlock)selectBlocks.get(i);
                if (selectBlock.getTop() != selectBlock.getBottom()) {
                    WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u62e9\u5355\u6761\u8bb0\u5f55\u5220\u9664\uff01", (String)this.getTitle(), (Component)((Object)this));
                    return;
                }
                this.tblFilter.removeRow(selectBlock.getTop());
            }
        }
    }

    private boolean checkSelectedTbl(KDTable tblMain) {
        if (tblMain.getRowCount() == 0 || tblMain.getSelectManager().size() == 0) {
            WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        return true;
    }

    protected void todoInit() {
        this.lblFilterMember = new KDLabel("\u7b5b\u9009\u6210\u5458");
        this.btnAddRow = new KDWorkButton("\u65b0\u589e\u884c");
        this.btnAddRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RowFilterDialog.this.addFilterRow(null);
            }
        });
        this.btnDelRow = new KDWorkButton("\u5220\u9664\u884c");
        this.btnDelRow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RowFilterDialog.this.delFilterRow();
            }
        });
        this.tblFilter = new KDTable();
        String[] columnKeys = new String[]{COL_LEFT_P, COL_ATTR, COL_OPERATOR, COL_MEMBERS, COL_RIGHT_P, COL_LOGIC};
        Object[] headNames = new String[]{"\u5de6\u62ec\u53f7", "\u7ef4\u5ea6\u5c5e\u6027", "\u6bd4\u8f83\u7b26", "\u6210\u5458", "\u53f3\u62ec\u53f7", "\u903b\u8f91\u7b26"};
        Object[][] bodyDatas = null;
        KDTableHelper.initTable((KDTable)this.tblFilter, (String[])columnKeys, (Object[])headNames, (Object[][])bodyDatas);
        this.tblFilter.getColumn(COL_LEFT_P).setWidth(50);
        this.tblFilter.getColumn(COL_ATTR).setWidth(100);
        this.tblFilter.getColumn(COL_OPERATOR).setWidth(80);
        this.tblFilter.getColumn(COL_RIGHT_P).setWidth(50);
        this.tblFilter.getColumn(COL_LOGIC).setWidth(50);
        this.tblFilter.getColumn(COL_MEMBERS).setWidth(400);
        this.tblFilter.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                int curCol = e.getColIndex();
                String curColKey = RowFilterDialog.this.tblFilter.getColumnKey(curCol);
                int curRow = e.getRowIndex();
                if (RowFilterDialog.COL_ATTR.equalsIgnoreCase(curColKey) && (e.getValue() == null || !e.getValue().equals(e.getOldValue()))) {
                    RowFilterDialog.this.tblFilter.getCell(curRow, RowFilterDialog.COL_MEMBERS).setValue(null);
                    ICell c = RowFilterDialog.this.tblFilter.getCell(curRow, RowFilterDialog.COL_OPERATOR);
                    RowFilterDialog.this.loadOperator((Property)e.getValue(), (KDComboBox)c.getEditor().getComponent());
                    c.setValue(null);
                } else if (RowFilterDialog.COL_OPERATOR.equalsIgnoreCase(curColKey) && (e.getValue() == null || !e.getValue().equals(e.getOldValue()))) {
                    RowFilterDialog.this.tblFilter.getCell(curRow, RowFilterDialog.COL_MEMBERS).setValue(null);
                    Operator op = (Operator)RowFilterDialog.this.tblFilter.getCell(curRow, RowFilterDialog.COL_OPERATOR).getValue();
                    KDPromptBox selMembers = (KDPromptBox)RowFilterDialog.this.tblFilter.getCell(curRow, RowFilterDialog.COL_MEMBERS).getEditor().getComponent();
                    if (op != null) {
                        if (Operator.METHOD_INPUT.equalsIgnoreCase(op.getMethod())) {
                            selMembers.setEditable(true);
                        } else {
                            selMembers.setEditable(false);
                        }
                    }
                }
            }
        });
    }

    protected boolean verify() {
        List filterItems = null;
        try {
            filterItems = this.getFilterItems();
            new SecureFilterItems(filterItems).verify();
        }
        catch (ExprException e) {
            WindowUtil.msgboxWarning((Object)e.getMessage(), (String)"\u7cfb\u7edf\u8b66\u544a", (Component)this.getRootPane());
            return false;
        }
        return true;
    }

    public List getFilterItems() throws ExprException {
        ArrayList<SecureFilterItem> filterItems = new ArrayList<SecureFilterItem>();
        int rows = this.tblFilter.getRowCount();
        for (int i = 0; i < rows; ++i) {
            Logic logic;
            IRow row = this.tblFilter.getRow(i);
            Parenthesis lp = (Parenthesis)row.getCell(COL_LEFT_P).getValue();
            int leftP = lp == null ? 0 : lp.getCount();
            Parenthesis left = new Parenthesis(true, leftP);
            Parenthesis rp = (Parenthesis)row.getCell(COL_RIGHT_P).getValue();
            int rightP = rp == null ? 0 : rp.getCount();
            Parenthesis right = new Parenthesis(false, rightP);
            Property prop = (Property)row.getCell(COL_ATTR).getValue();
            if (prop == null) {
                throw new ExprException("\u7b2c" + (i + 1) + "\u884c\u5c5e\u6027\u5217\u672a\u9009\u62e9!");
            }
            Operator op = (Operator)row.getCell(COL_OPERATOR).getValue();
            if (op == null) {
                throw new ExprException("\u7b2c" + (i + 1) + "\u884c\u64cd\u4f5c\u7b26\u672a\u9009\u62e9!");
            }
            Object value = row.getCell(COL_MEMBERS).getValue();
            if (op.getMethod().equalsIgnoreCase(Operator.METHOD_INPUT)) {
                if (StringUtils.isEmpty((String)((String)value))) {
                    throw new ExprException("\u7b2c" + (i + 1) + "\u884c\u503c\u4e0d\u80fd\u4e3a\u7a7a!");
                }
            } else {
                List members = (List)value;
                if (members == null || members.size() == 0) {
                    throw new ExprException("\u7b2c" + (i + 1) + "\u884c\u6210\u5458\u672a\u9009\u62e9!");
                }
            }
            if ((logic = (Logic)row.getCell(COL_LOGIC).getValue()) == null && i != rows - 1) {
                throw new ExprException("\u7b2c" + (i + 1) + "\u884c\u903b\u8f91\u7b26\u672a\u9009\u62e9!");
            }
            DimensionMeta dm = this.dv.getDimensionDef();
            SecureFilterItem item = new SecureFilterItem(left, prop, op, value, right, logic, dm);
            filterItems.add(item);
        }
        return filterItems;
    }

    public SecureFilterItems getRowSecureFilterItems() {
        SecureFilterItems rs = null;
        try {
            rs = new SecureFilterItems(this.getFilterItems());
        }
        catch (ExprException exprException) {
            // empty catch block
        }
        return rs;
    }

    private MemberBaseTreeNode[] changetoMemberBaseTreeNode(Member[] m) {
        if (m == null) {
            return null;
        }
        MemberBaseTreeNode[] ms = new MemberBaseTreeNode[m.length];
        for (int i = 0; i < ms.length; ++i) {
            ms[i] = new MemberBaseTreeNode(m[i].getNumber(), m[i].getName());
        }
        return ms;
    }

    private MemberBaseTreeNode[] changetoMemberBaseTreeNode(Object[] o) {
        if (o == null) {
            return null;
        }
        MemberBaseTreeNode[] ms = new MemberBaseTreeNode[o.length];
        for (int i = 0; i < ms.length; ++i) {
            ms[i] = o[i] == null ? new MemberBaseTreeNode("", "") : new MemberBaseTreeNode(o[i].toString(), o[i].toString());
        }
        return ms;
    }

    class selMemberListerner
    implements SelectorListener {
        private ICell cell;
        private IRow row;

        public selMemberListerner(ICell cell, IRow row) {
            this.cell = cell;
            this.row = row;
        }

        public void willShow(SelectorEvent e) {
            Property prop = (Property)this.row.getCell(RowFilterDialog.COL_ATTR).getValue();
            if (prop == null) {
                WindowUtil.msgboxError((Object)"\u8bf7\u5148\u9009\u62e9\u5c5e\u6027\u5217\uff0c\u518d\u9009\u62e9\u6210\u5458\uff01", (String)"\u7cfb\u7edf\u8b66\u544a", (Component)RowFilterDialog.this.getRootPane());
                return;
            }
            Operator opr = (Operator)this.row.getCell(RowFilterDialog.COL_OPERATOR).getValue();
            if (opr == null) {
                WindowUtil.msgboxError((Object)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u7b26\uff0c\u518d\u9009\u62e9\u6210\u5458\uff01", (String)"\u7cfb\u7edf\u8b66\u544a", (Component)RowFilterDialog.this.getRootPane());
                return;
            }
            if (Operator.METHOD_INPUT.equalsIgnoreCase(opr.getMethod())) {
                WindowUtil.msgboxInfo((Object)"\u8bf7\u76f4\u63a5\u8f93\u5165\u6587\u672c\uff0c\u8fdb\u884c\u5339\u914d\uff01", (String)"\u7cfb\u7edf\u63d0\u793a", (Component)RowFilterDialog.this.getRootPane());
                return;
            }
            SelViewMemberDialog dlg = (SelViewMemberDialog)((Object)WindowUtil.createWindow(SelViewMemberDialog.class, (Component)RowFilterDialog.this.getRootPane()));
            dlg.setSize(650, 600);
            dlg.setTitle("\u9009\u62e9\u6210\u5458");
            try {
                boolean isSingle = Operator.METHOD_SEL_SIGNLE.equalsIgnoreCase(opr.getMethod());
                if (prop.isInner()) {
                    if (RowFilterDialog.this.dv.isMeasure()) {
                        dlg.setRoot(RowFilterDialog.this.changetoMemberBaseTreeNode(RowFilterDialog.this.dv.getMembers(RowFilterDialog.this.facade)), isSingle);
                    } else if (RowFilterDialog.this.dv.getDimensionDef().getType().equals("year")) {
                        dlg.setRoot(RowFilterDialog.this.changetoMemberBaseTreeNode(RowFilterDialog.this.dv.getMembers(RowFilterDialog.this.facade)), isSingle);
                    } else if (RowFilterDialog.this.dv.getDimensionDef().getType().equals("period")) {
                        DefaultKingdeeTreeNode root = RowFilterDialog.this.dv.getRootMember(RowFilterDialog.this.facade);
                        dlg.setRoot((DefaultKingdeeTreeNode)root.getChildAt(0), isSingle);
                    } else if ("general".equals(RowFilterDialog.this.dv.getDimensionDef().getDimensionType().getInnerType())) {
                        dlg.setRoot((DefaultKingdeeTreeNode)RowFilterDialog.this.dv.getRootMember(RowFilterDialog.this.facade).getChildAt(0), isSingle);
                    } else if ("time".equals(RowFilterDialog.this.dv.getDimensionDef().getDimensionType().getInnerType())) {
                        dlg.setRoot((DefaultKingdeeTreeNode)RowFilterDialog.this.dv.getRootMember(RowFilterDialog.this.facade).getChildAt(0), isSingle);
                    } else {
                        dlg.setRoot(RowFilterDialog.this.dv.getRootMember(RowFilterDialog.this.facade), isSingle);
                    }
                } else {
                    dlg.setRoot(RowFilterDialog.this.changetoMemberBaseTreeNode(RowFilterDialog.this.dv.getPropertyValues(RowFilterDialog.this.facade, prop)), isSingle);
                }
            }
            catch (BIModelRemoteException e1) {
                log.error((Object)"\u8bfb\u53d6\u89c6\u56fe\u6570\u636e\u65f6\u51fa\u9519", (Throwable)((Object)e1));
            }
            catch (SQLException e2) {
                log.error((Object)"\u8bfb\u53d6\u89c6\u56fe\u6570\u636e\u65f6\u51fa\u9519", (Throwable)e2);
            }
            dlg.setCurrentSelected((List)this.cell.getValue());
            if (dlg.showDialog()) {
                this.cell.setValue((Object)dlg.getSelectedMembers());
            }
        }
    }
}

