/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.security.ui;

import com.kingdee.bos.bi.model.common.mm.org.OrgDimensionNode;
import com.kingdee.bos.bi.model.common.mm.org.OrgModel;
import com.kingdee.bos.bi.model.security.SecurityObject;
import com.kingdee.bos.bi.model.security.SecurityObjectType;
import com.kingdee.bos.bi.model.security.SelSecurityObjects;
import com.kingdee.bos.bi.model.security.ui.SelUserRoleDialog;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.dialog.org.OrgDimensionDialog;
import com.kingdee.bos.bi.model.ui.dialog.org.OrgImportDialog;
import com.kingdee.bos.bi.model.ui.exception.BIModelBizException;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import java.awt.Component;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class SecurityObjectSelectorListener
implements SelectorListener {
    private static final Logger log = CommonLogger.getLogger(SecurityObjectSelectorListener.class);
    private OrgDimensionDialog.IImportSourceFactory _importSourceFactory;
    private ICell cell;
    private Component parent;
    private IManagementFacade facade;
    private ICell stCell;

    public SecurityObjectSelectorListener(ICell stCell, ICell cell, Component parent, IManagementFacade facade) {
        this.cell = cell;
        this.parent = parent;
        this.facade = facade;
        this.stCell = stCell;
    }

    public void willShow(SelectorEvent e) {
        SelSecurityObjects selRet = null;
        SecurityObjectType st = (SecurityObjectType)this.stCell.getValue();
        if (SecurityObjectType.user.equals(st)) {
            selRet = this.selUser();
        } else if (SecurityObjectType.org.equals(st)) {
            selRet = this.selOrg();
        } else if (SecurityObjectType.role.equals(st)) {
            selRet = this.selRole();
        }
        if (selRet != null && selRet.getSecurityObjectList().size() > 0) {
            this.cell.setValue((Object)selRet);
        }
    }

    private SelSecurityObjects selRole() {
        SelUserRoleDialog dlg = (SelUserRoleDialog)((Object)WindowUtil.createWindow(SelUserRoleDialog.class, (Component)this.parent));
        dlg.setTitle("\u9009\u62e9\u89d2\u8272");
        dlg.setSize(400, 600);
        try {
            dlg.setUserInfo(SecurityObjectType.role, this.facade.getSecurityObjectList(SecurityObjectType.role.getName(), ""));
            dlg.setCurrent((SelSecurityObjects)this.cell.getValue());
        }
        catch (SQLException e) {
            log.error((Object)"\u83b7\u53d6\u7b5b\u9009\u5bf9\u8c61\u7684\u5217\u8868\u65f6\u51fa\u9519", (Throwable)e);
        }
        if (dlg.showDialog()) {
            return dlg.getSelectedUsers();
        }
        return null;
    }

    private SelSecurityObjects selUser() {
        SelUserRoleDialog dlg = (SelUserRoleDialog)((Object)WindowUtil.createWindow(SelUserRoleDialog.class, (Component)this.parent));
        dlg.setTitle("\u9009\u62e9\u7528\u6237");
        dlg.setSize(400, 600);
        try {
            dlg.setUserInfo(SecurityObjectType.user, this.facade.getSecurityObjectList(SecurityObjectType.user.getName(), ""));
            dlg.setCurrent((SelSecurityObjects)this.cell.getValue());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (dlg.showDialog()) {
            return dlg.getSelectedUsers();
        }
        return null;
    }

    private OrgDimensionDialog.IImportSourceFactory getImportSourceFactory() {
        if (this._importSourceFactory == null) {
            this._importSourceFactory = new OrgDimensionDialog.DefaultImportSourceFactory();
        }
        return this._importSourceFactory;
    }

    private SelSecurityObjects selOrg() {
        OrgDimensionNode root;
        SelSecurityObjects sos = null;
        try {
            HashMap todoParams = new HashMap();
            root = this.getImportSourceFactory().loadEnvOrgTree(this.facade, todoParams);
        }
        catch (BIModelBizException ex) {
            WindowUtil.msgboxError((Object)("\u6784\u9020\u5bfc\u5165\u5907\u9009\u6570\u636e\u51fa\u9519\u3002\r\n" + ex.getMessage()), (String)"\u5bfc\u5165", null);
            return sos;
        }
        OrgImportDialog dlg = (OrgImportDialog)((Object)WindowUtil.createWindow(OrgImportDialog.class, (Component)this.parent));
        dlg.setTitle("\u9009\u62e9\u7ec4\u7ec7");
        dlg.setSize(480, 600);
        dlg.setSupply(root);
        dlg.setCurrent((SelSecurityObjects)this.cell.getValue());
        ArrayList lstSO = new ArrayList();
        if (dlg.showDialog()) {
            OrgDimensionNode[] subTrees = dlg.getSelected();
            int c = subTrees.length;
            for (int i = 0; i < c; ++i) {
                this.addSelectedNode(lstSO, subTrees[i]);
            }
        }
        return new SelSecurityObjects(SecurityObjectType.org, lstSO);
    }

    private void addSelectedNode(List lst, OrgDimensionNode parent) {
        OrgModel om = parent.getOrgModel();
        SecurityObject so = new SecurityObject(om.getId(), om.getNumber(), om.getName());
        lst.add(so);
        if (parent.getChildCount() > 0) {
            int len = parent.getChildCount();
            for (int i = 0; i < len; ++i) {
                this.addSelectedNode(lst, parent.getChild(i));
            }
        }
    }
}

