/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.common.mm.customdim.CustomDimUtil;
import com.kingdee.bos.bi.model.common.mm.customdim.GeneralDimProperty;
import com.kingdee.bos.bi.model.common.mm.general.GeneralDimensionNode;
import com.kingdee.bos.bi.model.common.mm.general.GeneralModel;
import com.kingdee.bos.bi.model.common.mm.measure.MeasureDimensionNode;
import com.kingdee.bos.bi.model.common.mm.measure.MeasureTreeModel;
import com.kingdee.bos.bi.model.common.mm.metric.MetricDimensionNode;
import com.kingdee.bos.bi.model.common.mm.metric.MetricModel;
import com.kingdee.bos.bi.model.common.mm.metric.TimeAgg;
import com.kingdee.bos.bi.model.common.mm.metric.TimeCycle;
import com.kingdee.bos.bi.model.common.mm.org.OrgDimensionNode;
import com.kingdee.bos.bi.model.common.mm.org.OrgModel;
import com.kingdee.bos.bi.model.common.mm.period.PeriodDimensionNode;
import com.kingdee.bos.bi.model.common.mm.period.PeriodTreeModel;
import com.kingdee.bos.bi.model.common.mm.time.TimeDimensionNode;
import com.kingdee.bos.bi.model.common.mm.time.TimeModel;
import com.kingdee.bos.bi.model.common.mm.time.TimeTreeModel;
import com.kingdee.bos.bi.model.common.mm.time.builder.AbstractTimeLevel;
import com.kingdee.bos.bi.model.common.mm.year.YearDimensionNode;
import com.kingdee.bos.bi.model.common.mm.year.YearTreeModel;
import com.kingdee.bos.bi.model.rt.appmodel.AppModel;
import com.kingdee.bos.bi.model.rt.appmodel.AppModelView;
import com.kingdee.bos.bi.model.rt.dim.Dimension;
import com.kingdee.bos.bi.model.rt.dim.DimensionMeta;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.service.impl.ManagementFacadeImpl;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.analysis.web.appmodel.AbstractMainModel;
import com.kingdee.bos.ctrl.analysis.web.appmodel.AbstractTreeNode;
import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.JDOMException;

class ModelIO {
    private ManagementFacadeImpl _facade;

    public ModelIO(ManagementFacadeImpl facade) {
        this._facade = facade;
    }

    public MeasureDimensionNode getPublishedMeasureTree(String appmodelId, boolean bSecurityFilter, Map params) throws BIModelRemoteException {
        RDRowSet rs;
        String displayNameField = "FName";
        String returnValueField = "FNumber";
        if (params != null && params.size() != 0) {
            returnValueField = (String)params.get("value");
            displayNameField = (String)params.get("alias");
        }
        String pubnumber = (String)this._facade.getAppmodelInfo(appmodelId, "pubnumber");
        String tablename = DimensionMeta.getTablename(pubnumber, "measure");
        String sql = this.getDimensionMemberSql(appmodelId, bSecurityFilter, DimensionType.measure, true);
        HashMap<String, ArrayList<MeasureDimensionNode>> mapForTree = new HashMap<String, ArrayList<MeasureDimensionNode>>();
        MeasureDimensionNode rootNode = null;
        MeasureDimensionNode r = new MeasureDimensionNode();
        MeasureTreeModel m = new MeasureTreeModel();
        m.setCode(tablename);
        m.setName(tablename);
        r.setMeasureModel(m);
        rootNode = r;
        try {
            rs = this._facade.executeQuery(sql);
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
        String number = null;
        String parentNumber = null;
        String displayName = null;
        String returnValue = null;
        while (rs.next()) {
            MeasureTreeModel model = new MeasureTreeModel();
            displayName = rs.getString(displayNameField);
            returnValue = rs.getString(returnValueField);
            number = rs.getString("FNumber");
            parentNumber = m.getNumber();
            model.setNumber(number);
            model.setName(displayName);
            model.setExtProps("alias", displayName);
            model.setExtProps("value", returnValue);
            MeasureDimensionNode node = new MeasureDimensionNode();
            node.setMeasureModel(model);
            ArrayList<MeasureDimensionNode> children = (ArrayList<MeasureDimensionNode>)mapForTree.get(parentNumber);
            if (children == null) {
                children = new ArrayList<MeasureDimensionNode>();
                mapForTree.put(parentNumber, children);
            }
            children.add(node);
        }
        if (rootNode != null) {
            ModelIO.buildMeasureTree(rootNode, mapForTree);
        }
        return rootNode;
    }

    public MeasureDimensionNode getPublishedMeasureTree(String appmodelId, boolean bSecurityFilter) throws BIModelRemoteException {
        RDRowSet rs;
        String pubnumber = (String)this._facade.getAppmodelInfo(appmodelId, "pubnumber");
        String tablename = DimensionMeta.getTablename(pubnumber, "measure");
        String sql = this.getDimensionMemberSql(appmodelId, bSecurityFilter, DimensionType.measure, true);
        HashMap<String, ArrayList<MeasureDimensionNode>> mapForTree = new HashMap<String, ArrayList<MeasureDimensionNode>>();
        MeasureDimensionNode rootNode = null;
        MeasureDimensionNode r = new MeasureDimensionNode();
        MeasureTreeModel m = new MeasureTreeModel();
        m.setCode(tablename);
        m.setName(tablename);
        r.setMeasureModel(m);
        rootNode = r;
        try {
            rs = this._facade.executeQuery(sql);
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
        while (rs.next()) {
            MeasureTreeModel model = new MeasureTreeModel();
            model.setCode(rs.getString("FNumber"));
            model.setName(rs.getString("FName"));
            model.setFormula(rs.getString("FFormula"));
            String parentNumber = m.getCode();
            MeasureDimensionNode node = new MeasureDimensionNode();
            node.setMeasureModel(model);
            ArrayList<MeasureDimensionNode> children = (ArrayList<MeasureDimensionNode>)mapForTree.get(parentNumber);
            if (children == null) {
                children = new ArrayList<MeasureDimensionNode>();
                mapForTree.put(parentNumber, children);
            }
            children.add(node);
        }
        if (mapForTree.size() == 0) {
            throw new BIModelRemoteException("\u6ca1\u6709\u60a8\u53ef\u4ee5\u67e5\u770b\u7684\u5ea6\u91cf\uff01");
        }
        if (rootNode != null) {
            ModelIO.buildMeasureTree(rootNode, mapForTree);
        }
        return rootNode;
    }

    private static void buildMeasureTree(MeasureDimensionNode parent, Map mapForTree) {
        String number = parent.getMeasureModel().getCode();
        List children = (List)mapForTree.get(number);
        int childrenCount = children == null ? 0 : children.size();
        for (int i = 0; i < childrenCount; ++i) {
            MeasureDimensionNode child = (MeasureDimensionNode)children.get(i);
            parent.addChild(child);
            ModelIO.buildMeasureTree(child, mapForTree);
        }
    }

    private AbstractTreeNode getDimensionNodes(DimensionType type, String appmodelId, boolean bSecurityFilter, Map mapNodes, Map mapForTree, Map params) throws BIModelRemoteException {
        RDRowSet rs;
        String displayNameField = "FName";
        String returnValueField = "FNumber";
        boolean isDashBoard = false;
        if (params != null && params.size() != 0) {
            isDashBoard = true;
            displayNameField = (String)params.get("alias");
            returnValueField = (String)params.get("value");
        }
        String sql = this.getDimensionMemberSql(appmodelId, bSecurityFilter, type, false);
        try {
            rs = this._facade.executeQuery(sql);
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
        rs.reset();
        if (rs.isEof()) {
            return null;
        }
        AbstractTreeNode rootNode = null;
        while (rs.next()) {
            String number = rs.getString("FNumber");
            String name = rs.getString("FName");
            String parentNumber = rs.getString("FParentNumber");
            int order = rs.getInt("FOrder");
            AbstractMainModel model = null;
            model = DimensionType.org == type ? new OrgModel() : (DimensionType.metric == type ? new MetricModel() : new AbstractMainModel());
            model.setNumber(number);
            model.setName(name);
            if (isDashBoard) {
                model.setExtProps((Object)"alias", rs.getObject(displayNameField));
                model.setExtProps((Object)"value", rs.getObject(returnValueField));
            }
            AbstractTreeNode node = null;
            node = DimensionType.org == type ? new OrgDimensionNode() : (DimensionType.metric == type ? new MetricDimensionNode() : new AbstractTreeNode());
            node.setModel(model);
            node.setOrder(order);
            mapNodes.put(model.getNumber(), node);
            if (rootNode == null && (parentNumber == null || parentNumber.equals("") || parentNumber.equals(number))) {
                rootNode = node;
                continue;
            }
            ArrayList<OrgDimensionNode> children = (ArrayList<OrgDimensionNode>)mapForTree.get(parentNumber);
            if (children == null) {
                children = new ArrayList<OrgDimensionNode>();
                mapForTree.put(parentNumber, children);
            }
            children.add((OrgDimensionNode)node);
        }
        return rootNode;
    }

    public OrgDimensionNode getPublishedOrgTree(String appmodelId, boolean bSecurityFilter, Map params) throws BIModelRemoteException {
        return (OrgDimensionNode)this.getPublishedDimensionTree(DimensionType.org, appmodelId, bSecurityFilter, params);
    }

    private AbstractTreeNode getPublishedDimensionTree(DimensionType type, String appmodelId, boolean bSecurityFilter, Map params) throws BIModelRemoteException {
        HashMap mapNodes = new HashMap();
        HashMap mapForTree = new HashMap();
        AbstractTreeNode rootNode = this.getDimensionNodes(type, appmodelId, bSecurityFilter, mapNodes, mapForTree, params);
        if (mapNodes.size() == 0) {
            throw new BIModelRemoteException("\u6ca1\u6709\u60a8\u53ef\u4ee5\u67e5\u770b\u7684" + type.getAlias() + "!");
        }
        HashMap mapNodesAll = new HashMap();
        HashMap mapForTreeAll = new HashMap();
        rootNode = this.getDimensionNodes(type, appmodelId, false, mapNodesAll, mapForTreeAll, params);
        if (bSecurityFilter) {
            rootNode = this.checkPermission(rootNode, mapNodes, mapForTree, mapNodesAll, mapForTreeAll);
        }
        if (rootNode != null) {
            ModelIO.buildDimensionTree(rootNode, mapForTree);
        }
        return rootNode;
    }

    public OrgDimensionNode getPublishedOrgTree(String appmodelId, boolean bSecurityFilter) throws BIModelRemoteException {
        return this.getPublishedOrgTree(appmodelId, bSecurityFilter, null);
    }

    private AbstractTreeNode checkPermission(AbstractTreeNode root, Map mapNodes, Map mapForTree, Map mapNodesAll, Map mapForTreeAll) throws BIModelRemoteException {
        HashMap mapAddNodes = new HashMap();
        for (String parent : mapForTree.keySet()) {
            this.checkAndPutParentNode(root, parent, mapNodes, mapAddNodes, mapNodesAll, mapForTreeAll);
        }
        for (String parent : mapAddNodes.keySet()) {
            List children = null;
            if (mapForTree.containsKey(parent)) {
                children = (List)mapForTree.get(parent);
            } else {
                children = new ArrayList();
                mapForTree.put(parent, children);
            }
            children.addAll((List)mapAddNodes.get(parent));
        }
        return root;
    }

    private String findNodeParentNumber(AbstractTreeNode node, Map mapForTreeAll) {
        for (String n : mapForTreeAll.keySet()) {
            List lChildren = (List)mapForTreeAll.get(n);
            if (lChildren.indexOf(node) == -1) continue;
            return n;
        }
        return null;
    }

    private void checkAndPutParentNode(AbstractTreeNode rootNode, String parentNumber, Map mapNodes, Map mapAddNodes, Map mapNodesAll, Map mapForTreeAll) {
        if (!mapNodes.containsKey(parentNumber)) {
            AbstractTreeNode node = (AbstractTreeNode)mapNodesAll.get(parentNumber);
            node.setCanSelect(false);
            String pNumber = this.findNodeParentNumber(node, mapForTreeAll);
            if (pNumber == null) {
                rootNode = node;
            } else {
                List<AbstractTreeNode> children = null;
                if (!mapAddNodes.containsKey(pNumber)) {
                    children = new ArrayList();
                    mapAddNodes.put(pNumber, children);
                } else {
                    children = (List)mapAddNodes.get(pNumber);
                }
                children.add(node);
                this.checkAndPutParentNode(rootNode, pNumber, mapNodes, mapAddNodes, mapNodesAll, mapForTreeAll);
            }
        }
    }

    private static void buildDimensionTree(AbstractTreeNode parent, Map mapForTree) {
        String number = parent.getModel().getNumber();
        List children = (List)mapForTree.get(number);
        int childrenCount = 0;
        if (children != null) {
            Collections.sort(children, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    AbstractTreeNode node0 = (AbstractTreeNode)arg0;
                    AbstractTreeNode node1 = (AbstractTreeNode)arg1;
                    return node0.getOrder() - node1.getOrder();
                }
            });
            childrenCount = children.size();
        }
        for (int i = 0; i < childrenCount; ++i) {
            AbstractTreeNode child = (AbstractTreeNode)children.get(i);
            parent.addChildNode(child);
            ModelIO.buildDimensionTree(child, mapForTree);
        }
    }

    public String getDimensionMemberSql(String appmodelId, boolean bSecurityFilter, DimensionType dt, boolean bTreeFilter) {
        String sql = "";
        AppModelView apv = null;
        try {
            Context ctx = this._facade.getBosContext();
            apv = AppModelView.fromDB(appmodelId, ctx);
            Dimension dim = new AppModel(apv, ctx).getDimension(dt.getName());
            sql = dim.getAllMembersSql(ctx, bSecurityFilter, bTreeFilter);
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        return sql;
    }

    public PeriodDimensionNode getPublishedPeriodTree(String appmodelId, boolean bSecurityFilter, Map params) throws BIModelRemoteException {
        ArrayList<PeriodDimensionNode> children;
        RDRowSet rs;
        String alias = "FPeriod";
        String value = "FPeriod";
        if (params != null && params.size() != 0) {
            value = (String)params.get("value");
            alias = (String)params.get("alias");
        }
        String sql = this.getDimensionMemberSql(appmodelId, bSecurityFilter, DimensionType.period, true);
        HashMap<String, ArrayList<PeriodDimensionNode>> mapForTree = new HashMap<String, ArrayList<PeriodDimensionNode>>();
        HashMap<String, PeriodDimensionNode> mapNodes = new HashMap<String, PeriodDimensionNode>();
        PeriodDimensionNode rootNode = null;
        PeriodDimensionNode r = new PeriodDimensionNode();
        PeriodTreeModel m = new PeriodTreeModel();
        r.setPeriodModel(m);
        mapNodes.put(m.getNumber(), rootNode);
        rootNode = r;
        try {
            rs = this._facade.executeQuery(sql);
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
        String number = null;
        String parentNumber = null;
        while (rs.next()) {
            PeriodDimensionNode node = new PeriodDimensionNode();
            PeriodTreeModel model = new PeriodTreeModel();
            number = Integer.toString(rs.getInt("FPeriod"));
            String returnValue = Integer.toString(rs.getInt(value));
            model.setNumber(number);
            model.setExtProps("key", number);
            model.setExtProps("value", returnValue);
            int code = rs.getInt("FPeriod");
            model.setCode(Integer.toString(code));
            if (code > 100) {
                model.setName("\u7b2c" + (code - 100) + "\u5b63\u5ea6");
                parentNumber = m.getCode();
                model.setExtProps("alias", model.getName());
                model.setExtProps("parentKey", parentNumber);
            } else {
                model.setName("\u7b2c" + code + "\u671f");
                Object parent = rs.getObject("FPeriodParent");
                parentNumber = parent == null || parent.toString().equals(code + "") ? m.getCode() : parent.toString();
                model.setExtProps("alias", model.getName());
                model.setExtProps("parentKey", parentNumber);
            }
            node.setPeriodModel(model);
            children = (ArrayList<PeriodDimensionNode>)mapForTree.get(parentNumber);
            if (children == null) {
                children = new ArrayList<PeriodDimensionNode>();
                mapForTree.put(parentNumber, children);
            }
            children.add(node);
            mapNodes.put(node.getModel().getNumber(), node);
        }
        for (String pNumber : mapForTree.keySet()) {
            if (mapNodes.containsKey(pNumber)) continue;
            PeriodDimensionNode pn = new PeriodDimensionNode();
            pn.setCanSelect(false);
            PeriodTreeModel pm = new PeriodTreeModel();
            pm.setNumber(pNumber);
            pm.setName("\u7b2c" + (Integer.parseInt(pNumber) - 100) + "\u5b63\u5ea6");
            pm.setExtProps("alias", pm.getName());
            pm.setExtProps("parentKey", "");
            pn.setPeriodModel(pm);
            children = (ArrayList<PeriodDimensionNode>)mapForTree.get(rootNode.getModel().getNumber());
            if (children == null) {
                children = new ArrayList<PeriodDimensionNode>();
                mapForTree.put(rootNode.getModel().getNumber(), children);
            }
            children.add(pn);
        }
        if (rootNode != null) {
            ModelIO.buildPeriodTree(rootNode, mapForTree);
        }
        return rootNode;
    }

    public PeriodDimensionNode getPublishedPeriodTree(String appmodelId, boolean bSecurityFilter) throws BIModelRemoteException {
        RDRowSet rs;
        String pubnumber = (String)this._facade.getAppmodelInfo(appmodelId, "pubnumber");
        String tablename = DimensionMeta.getTablename(pubnumber, "period");
        String sql = this.getDimensionMemberSql(appmodelId, bSecurityFilter, DimensionType.period, false);
        HashMap mapForTree = new HashMap();
        HashMap<String, PeriodDimensionNode> mapNodes = new HashMap<String, PeriodDimensionNode>();
        PeriodDimensionNode rootNode = null;
        PeriodDimensionNode r = new PeriodDimensionNode();
        PeriodTreeModel m = new PeriodTreeModel();
        m.setCode(tablename);
        m.setName(tablename);
        r.setPeriodModel(m);
        rootNode = r;
        mapNodes.put(m.getNumber(), rootNode);
        try {
            rs = this._facade.executeQuery(sql);
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
        while (rs.next()) {
            PeriodDimensionNode node = new PeriodDimensionNode();
            PeriodTreeModel model = new PeriodTreeModel();
            String parentNumber = null;
            int code = rs.getInt("FPeriod");
            model.setCode(Integer.toString(code));
            if (code > 100) {
                model.setName("\u7b2c" + (code - 100) + "\u5b63\u5ea6");
                parentNumber = m.getCode();
            } else {
                model.setName("\u7b2c" + code + "\u671f");
                Object parent = rs.getObject("FPeriodParent");
                parentNumber = parent == null || parent.toString().equals(code + "") ? m.getCode() : parent.toString();
            }
            node.setPeriodModel(model);
            ArrayList<PeriodDimensionNode> children = (ArrayList<PeriodDimensionNode>)mapForTree.get(parentNumber);
            if (children == null) {
                children = new ArrayList<PeriodDimensionNode>();
                mapForTree.put(parentNumber, children);
            }
            children.add(node);
            mapNodes.put(node.getModel().getNumber(), node);
        }
        if (mapNodes.size() == 0) {
            throw new BIModelRemoteException("\u6ca1\u6709\u60a8\u53ef\u4ee5\u67e5\u770b\u7684\u671f\u95f4\uff01");
        }
        List<PeriodDimensionNode> children = (ArrayList)mapForTree.get(rootNode.getModel().getNumber());
        if (children == null) {
            children = new ArrayList();
            mapForTree.put(rootNode.getModel().getNumber(), children);
        }
        for (String pNumber : mapForTree.keySet()) {
            if (mapNodes.containsKey(pNumber)) continue;
            PeriodDimensionNode pn = new PeriodDimensionNode();
            pn.setCanSelect(false);
            PeriodTreeModel pm = new PeriodTreeModel();
            pm.setNumber(pNumber);
            pm.setName("\u7b2c" + (Integer.parseInt(pNumber) - 100) + "\u5b63\u5ea6");
            pn.setPeriodModel(pm);
            children = (List)mapForTree.get(rootNode.getModel().getNumber());
            children.add(pn);
        }
        if (rootNode != null) {
            ModelIO.buildPeriodTree(rootNode, mapForTree);
        }
        return rootNode;
    }

    private static void buildPeriodTree(PeriodDimensionNode parent, Map mapForTree) {
        String number = parent.getPeriodModel().getCode();
        List children = (List)mapForTree.get(number);
        int childrenCount = children == null ? 0 : children.size();
        for (int i = 0; i < childrenCount; ++i) {
            PeriodDimensionNode child = (PeriodDimensionNode)children.get(i);
            parent.addChild(child);
            ModelIO.buildPeriodTree(child, mapForTree);
        }
    }

    public YearDimensionNode getPublishedYearTree(String appmodelId, boolean bSecurityFilter, Map params) throws BIModelRemoteException {
        RDRowSet rs;
        String disPlayNameField = "FYear";
        String returnValueField = "FYear";
        if (params != null && params.size() != 0) {
            returnValueField = (String)params.get("value");
            disPlayNameField = (String)params.get("alias");
        }
        String sql = this.getDimensionMemberSql(appmodelId, bSecurityFilter, DimensionType.year, true);
        HashMap<String, ArrayList<YearDimensionNode>> mapForTree = new HashMap<String, ArrayList<YearDimensionNode>>();
        YearDimensionNode rootNode = null;
        YearDimensionNode r = new YearDimensionNode();
        YearTreeModel m = new YearTreeModel();
        r.setYearModel(m);
        rootNode = r;
        try {
            rs = this._facade.executeQuery(sql);
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
        String number = null;
        String parentNumber = null;
        String displayName = null;
        String returnValue = null;
        while (rs.next()) {
            returnValue = Integer.toString(rs.getInt(returnValueField));
            displayName = Integer.toString(rs.getInt(disPlayNameField)) + "\u5e74";
            number = Integer.toString(rs.getInt("FYear"));
            parentNumber = m.getNumber();
            YearTreeModel model = new YearTreeModel();
            model.setNumber(number);
            model.setName(displayName);
            model.setExtProps("alias", displayName);
            model.setExtProps("value", returnValue);
            YearDimensionNode node = new YearDimensionNode();
            node.setYearModel(model);
            ArrayList<YearDimensionNode> children = (ArrayList<YearDimensionNode>)mapForTree.get(parentNumber);
            if (children == null) {
                children = new ArrayList<YearDimensionNode>();
                mapForTree.put(parentNumber, children);
            }
            children.add(node);
        }
        if (rootNode != null) {
            ModelIO.buildYearTree(rootNode, mapForTree);
        }
        return rootNode;
    }

    public YearDimensionNode getPublishedYearTree(String appmodelId, boolean bSecurityFilter) throws BIModelRemoteException {
        RDRowSet rs;
        String pubnumber = (String)this._facade.getAppmodelInfo(appmodelId, "pubnumber");
        String tablename = DimensionMeta.getTablename(pubnumber, "year");
        String sql = this.getDimensionMemberSql(appmodelId, bSecurityFilter, DimensionType.year, true);
        HashMap<String, ArrayList<YearDimensionNode>> mapForTree = new HashMap<String, ArrayList<YearDimensionNode>>();
        YearDimensionNode rootNode = null;
        YearDimensionNode r = new YearDimensionNode();
        YearTreeModel m = new YearTreeModel();
        m.setCode(tablename);
        m.setName(tablename);
        r.setYearModel(m);
        rootNode = r;
        try {
            rs = this._facade.executeQuery(sql);
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
        while (rs.next()) {
            YearTreeModel model = new YearTreeModel();
            int y = rs.getInt("FYear");
            model.setCode(Integer.toString(y));
            model.setName(y + "\u5e74");
            String parentNumber = m.getCode();
            YearDimensionNode node = new YearDimensionNode();
            node.setYearModel(model);
            ArrayList<YearDimensionNode> children = (ArrayList<YearDimensionNode>)mapForTree.get(parentNumber);
            if (children == null) {
                children = new ArrayList<YearDimensionNode>();
                mapForTree.put(parentNumber, children);
            }
            children.add(node);
        }
        if (mapForTree.size() == 0) {
            throw new BIModelRemoteException("\u6ca1\u6709\u60a8\u53ef\u4ee5\u67e5\u770b\u7684\u5e74\uff01");
        }
        if (rootNode != null) {
            ModelIO.buildYearTree(rootNode, mapForTree);
        }
        return rootNode;
    }

    private static void buildYearTree(YearDimensionNode parent, Map mapForTree) {
        String number = parent.getYearModel().getCode();
        List children = (List)mapForTree.get(number);
        int childrenCount = children == null ? 0 : children.size();
        for (int i = 0; i < childrenCount; ++i) {
            YearDimensionNode child = (YearDimensionNode)children.get(i);
            parent.addChild(child);
            ModelIO.buildYearTree(child, mapForTree);
        }
    }

    public List getPublishedMetricList(String appmodelId, boolean bSecurityFilter) throws BIModelRemoteException {
        RDRowSet rowset;
        ArrayList<MetricDimensionNode> ret = new ArrayList<MetricDimensionNode>();
        String sql = this.getDimensionMemberSql(appmodelId, bSecurityFilter, DimensionType.metric, false);
        try {
            rowset = this._facade.executeQuery(sql);
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
        rowset.reset();
        if (rowset.isEof()) {
            return null;
        }
        while (rowset.next()) {
            String number = rowset.getString("FNumber");
            String name = rowset.getString("FName");
            String parentNumber = rowset.getString("FParentNumber");
            String timeCycle = rowset.getString("FTimeCycle");
            String timeAgg = rowset.getString("FTimeAggType");
            String formula = rowset.getString("FFormula");
            String formatString = rowset.getString("FFormat");
            MetricModel model = new MetricModel();
            model.setNumber(number);
            model.setName(name);
            model.setTimeCycle(TimeCycle.getObj(timeCycle));
            model.setTimeAgg(TimeAgg.getObj(timeAgg));
            model.setFormula(formula);
            model.setFormatString(formatString);
            MetricDimensionNode node = new MetricDimensionNode();
            node.setMetricModel(model);
            ret.add(node);
        }
        return ret;
    }

    public List getPublishedOrgList(String appmodelId, boolean bSecurityFilter) throws BIModelRemoteException {
        RDRowSet rowset;
        ArrayList<OrgDimensionNode> ret = new ArrayList<OrgDimensionNode>();
        String sql = this.getDimensionMemberSql(appmodelId, bSecurityFilter, DimensionType.org, false);
        try {
            rowset = this._facade.executeQuery(sql);
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
        rowset.reset();
        if (rowset.isEof()) {
            return null;
        }
        while (rowset.next()) {
            String number = rowset.getString("FNumber");
            String name = rowset.getString("FName");
            OrgModel model = new OrgModel();
            model.setNumber(number);
            model.setName(name);
            OrgDimensionNode node = new OrgDimensionNode();
            node.setOrgModel(model);
            ret.add(node);
        }
        return ret;
    }

    public MetricDimensionNode getPublishedMetricTree(String appmodelId, boolean bSecurityFilter, Map params) throws BIModelRemoteException {
        return (MetricDimensionNode)this.getPublishedDimensionTree(DimensionType.metric, appmodelId, bSecurityFilter, params);
    }

    public MetricDimensionNode getPublishedMetricTree(String appmodelId, boolean bSecurityFilter) throws BIModelRemoteException {
        RDRowSet rowset;
        String sql = this.getDimensionMemberSql(appmodelId, bSecurityFilter, DimensionType.metric, true);
        try {
            rowset = this._facade.executeQuery(sql);
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
        rowset.reset();
        if (rowset.isEof()) {
            return null;
        }
        HashMap<String, ArrayList<MetricDimensionNode>> mapForTree = new HashMap<String, ArrayList<MetricDimensionNode>>();
        MetricDimensionNode rootNode = null;
        while (rowset.next()) {
            String number = rowset.getString("FNumber");
            String name = rowset.getString("FName");
            String parentNumber = rowset.getString("FParentNumber");
            String timeCycle = rowset.getString("FTimeCycle");
            String timeAgg = rowset.getString("FTimeAggType");
            String formula = rowset.getString("FFormula");
            String formatString = rowset.getString("FFormat");
            MetricModel model = new MetricModel();
            model.setNumber(number);
            model.setName(name);
            model.setTimeCycle(TimeCycle.getObj(timeCycle));
            model.setTimeAgg(TimeAgg.getObj(timeAgg));
            model.setFormula(formula);
            model.setFormatString(formatString);
            MetricDimensionNode node = new MetricDimensionNode();
            node.setMetricModel(model);
            if (rootNode == null && (parentNumber == null || parentNumber.equals("") || StringUtil.equals(parentNumber, number))) {
                rootNode = node;
                continue;
            }
            ArrayList<MetricDimensionNode> children = (ArrayList<MetricDimensionNode>)mapForTree.get(parentNumber);
            if (children == null) {
                children = new ArrayList<MetricDimensionNode>();
                mapForTree.put(parentNumber, children);
            }
            children.add(node);
        }
        if (rootNode != null) {
            ModelIO.buildMetricTree(rootNode, mapForTree);
        }
        return rootNode;
    }

    private static void buildMetricTree(MetricDimensionNode parent, Map mapForTree) {
        String number = parent.getMetricModel().getNumber();
        List children = (List)mapForTree.get(number);
        int childrenCount = children == null ? 0 : children.size();
        for (int i = 0; i < childrenCount; ++i) {
            MetricDimensionNode child = (MetricDimensionNode)children.get(i);
            parent.addChild(child);
            ModelIO.buildMetricTree(child, mapForTree);
        }
    }

    public AbstractTreeNode getPublishedCustomDefineList(String appmodelId, String dimNumber, boolean bSecurityFilter, Map params) throws BIModelRemoteException {
        String sql = "select FType from T_BI_MM_CUSTOM where FNumber='" + dimNumber + "'";
        try {
            RDRowSet rs = this._facade.executeQuery(sql);
            String type = null;
            if (rs.next()) {
                type = rs.getString("FType");
            }
            if ("time".equals(type)) {
                TimeModel timeModel = TimeModel.load3(this._facade, appmodelId, dimNumber);
                TimeDimensionNode rootNode = new TimeDimensionNode();
                TimeTreeModel m = new TimeTreeModel();
                m.setDimensionType(dimNumber);
                rootNode.setTimeModel(m);
                List timeList = TimeDimensionNode.createTimeLevelChain(timeModel, params);
                if (timeList.size() > 0) {
                    AbstractTimeLevel yearLevel = (AbstractTimeLevel)timeList.get(0);
                    yearLevel.builder(rootNode);
                }
                return rootNode;
            }
            if ("general".equals(type)) {
                return this.getPublishedGeneralTree(true, appmodelId, dimNumber, params);
            }
            return null;
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
        catch (JDOMException e) {
            throw new BIModelRemoteException(e);
        }
        catch (IOException e) {
            throw new BIModelRemoteException(e);
        }
        catch (ParseException e) {
            throw new BIModelRemoteException(e);
        }
    }

    public GeneralDimensionNode getPublishedGeneralTree(boolean bSecurityFilter, String appmodelId, String dimNumber, Map params) throws BIModelRemoteException {
        HashMap mapNodes = new HashMap();
        HashMap mapForTree = new HashMap();
        GeneralDimensionNode rootNode = this.getGeneralDimensionNodes(dimNumber, appmodelId, bSecurityFilter, mapNodes, mapForTree, params);
        HashMap mapNodesAll = new HashMap();
        HashMap mapForTreeAll = new HashMap();
        rootNode = this.getGeneralDimensionNodes(dimNumber, appmodelId, false, mapNodesAll, mapForTreeAll, params);
        if (bSecurityFilter) {
            rootNode = (GeneralDimensionNode)this.checkPermission(rootNode, mapNodes, mapForTree, mapNodesAll, mapForTreeAll);
        }
        if (rootNode != null) {
            ModelIO.buildDimensionTree(rootNode, mapForTree);
        }
        return rootNode;
    }

    private GeneralDimensionNode getGeneralDimensionNodes(String dimNumber, String appmodelId, boolean bSecurityFilter, Map mapNodes, Map mapForTree, Map params) throws BIModelRemoteException {
        List attrDefineList;
        String displayNameField = "FName";
        String returnValueField = "FNumber";
        if (params != null && params.size() != 0) {
            returnValueField = (String)params.get("value");
            displayNameField = (String)params.get("alias");
        }
        String pubnumber = (String)this._facade.getAppmodelInfo(appmodelId, "pubnumber");
        String tableName = DimensionMeta.getTablename(pubnumber, dimNumber);
        try {
            attrDefineList = CustomDimUtil.loadGeneralDimModelProperties3(this._facade, appmodelId, dimNumber);
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
        catch (JDOMException e) {
            throw new BIModelRemoteException(e);
        }
        catch (IOException e) {
            throw new BIModelRemoteException(e);
        }
        catch (ParseException e) {
            throw new BIModelRemoteException(e);
        }
        DimensionType dt = null;
        try {
            dt = DimensionType.getObj(this._facade.getBosContext(), dimNumber);
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
        String sql = this.getDimensionMemberSql(appmodelId, bSecurityFilter, dt, true);
        RDRowSet rs = null;
        try {
            rs = this._facade.executeQuery(sql);
        }
        catch (SQLException e) {
            throw new BIModelRemoteException(e);
        }
        rs.reset();
        GeneralDimensionNode rootNode = null;
        GeneralDimensionNode r = new GeneralDimensionNode();
        GeneralModel m = new GeneralModel(dimNumber);
        m.setPropertyList(attrDefineList);
        m.setId(0);
        m.setNumber(null);
        m.setName("\u8fd9\u662f\u865a\u62df\u7684\u6839\u8282\u70b9");
        r.setGeneralModel(m);
        rootNode = r;
        mapNodes.put(m.getNumber(), r);
        if (rs.isEof()) {
            return rootNode;
        }
        while (rs.next()) {
            int id = rs.getInt("FId");
            String number = rs.getString("FNumber");
            String parentNumber = rs.getString("FParentNumber");
            String name = rs.getString("FName");
            String description = rs.getString("FMemo");
            String originalId = rs.getString("FOriginalId");
            String displayName = rs.getString(displayNameField);
            String returnValue = rs.getString(returnValueField);
            GeneralModel model = new GeneralModel(dimNumber);
            model.setNumber(number);
            model.setName(name);
            model.setMemo(description);
            model.setId(id);
            model.setOriginalId(originalId);
            model.setExtProps("alias", displayName);
            model.setExtProps("value", returnValue);
            List attrValueList = GeneralDimensionNode.deepCopy(attrDefineList);
            GeneralDimProperty attr = null;
            String key = null;
            int n = attrValueList.size();
            for (int i = 0; i < n; ++i) {
                attr = (GeneralDimProperty)attrValueList.get(i);
                key = StringUtil.isEmpty(attr.getFieldName()) ? "F" + attr.getNumber() : attr.getFieldName();
                attr.setValue(rs.getObject(key));
            }
            model.setPropertyList(attrValueList);
            GeneralDimensionNode node = new GeneralDimensionNode();
            node.setGeneralModel(model);
            mapNodes.put(model.getNumber(), node);
            if (rootNode == null && (StringUtil.isEmpty(parentNumber) || StringUtil.equals(parentNumber, number))) {
                rootNode = node;
                continue;
            }
            ArrayList<GeneralDimensionNode> children = (ArrayList<GeneralDimensionNode>)mapForTree.get(parentNumber);
            if (children == null) {
                children = new ArrayList<GeneralDimensionNode>();
                mapForTree.put(parentNumber, children);
            }
            children.add(node);
        }
        return rootNode;
    }
}

