/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.dialog.general.importscheme;

import com.kingdee.bos.bi.model.common.mm.general.db.Column;
import com.kingdee.bos.bi.model.common.mm.general.importscheme.SchemeModel;
import com.kingdee.bos.bi.model.common.mm.general.importscheme.SchemeUtil;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.dialog.general.importscheme.AbstractImportWizardStep;
import com.kingdee.bos.bi.model.ui.dialog.general.importscheme.PreviewDialog;
import com.kingdee.bos.bi.model.ui.dialog.general.importscheme.Step3_Mapping;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.DBCenterException;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.EnumObj;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;

public class Step2_3_DBCenterSql
extends AbstractImportWizardStep {
    protected KDPanel panMain;
    protected KDLabelContainer lctnSelectDBCenter;
    protected KDComboBox cbxSelectDBCenter;
    protected KDLabel lblSql;
    protected KDButton btnSql;
    protected KDScrollPane scroPane;
    protected KDTextArea txaSql;
    protected AbstractImportWizardStep step3 = null;
    private boolean readOnly = false;
    private static final String PROMPT_TEXT = "\u9009\u62e9\u6570\u636e\u6765\u6e90\u7684\u6570\u636e\u4e2d\u5fc3\u548c\u6570\u636e\u8868\u3002";

    public Step2_3_DBCenterSql(IManagementFacade facade, Component owner) {
        super(facade, owner);
    }

    @Override
    public void beforeIntoThisStep() {
        this.initDBCenterDropdownList();
    }

    private void initDBCenterDropdownList() {
        try {
            if (this.getCbxSelectDBCenter().getItemCount() == 0) {
                this.getCbxSelectDBCenter().addItems((Vector)this.facade.getDBCenterList());
            }
        }
        catch (DBCenterException e) {
            log.error((Object)("\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u5217\u8868\u51fa\u9519" + e.getMessage()));
        }
        catch (SQLException e) {
            log.error((Object)("\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u5217\u8868\u51fa\u9519" + e.getMessage()));
        }
    }

    @Override
    protected AbstractImportWizardStep getNextStep() {
        if (this.step3 == null) {
            this.step3 = new Step3_Mapping(this.facade, this.getOwner());
        }
        return this.step3;
    }

    @Override
    protected String getPromptText() {
        return PROMPT_TEXT;
    }

    @Override
    public Component getPanMain() {
        if (this.panMain == null) {
            this.panMain = new KDPanel();
            this.setPanMainLayout();
            this.addPanMainComponent();
        }
        return this.panMain;
    }

    private void setPanMainLayout() {
        TableLayout2 tly = new TableLayout2(3, 2);
        tly.setRowsSpacing(TableLayout2.ALL, 5);
        tly.setFixedHeight(TableLayout2.ALL, 21);
        tly.setRatableHeight(2, 100);
        tly.setFixedWidth(1, 78);
        tly.setRatableWidth(0, 100);
        this.panMain.setLayout((LayoutManager)tly);
    }

    private void addPanMainComponent() {
        this.panMain.add(this.getLctnSelectDBCenter(), (Object)TableLayout2.param((int)0, (int)0, (int)0, (int)1));
        this.panMain.add(this.getLblSql(), (Object)TableLayout2.param((int)1, (int)0));
        this.panMain.add(this.getBtnSql(), (Object)TableLayout2.param((int)1, (int)1));
        this.panMain.add(this.getScroPane(), (Object)TableLayout2.param((int)2, (int)0, (int)2, (int)1));
    }

    public Component getLctnSelectDBCenter() {
        if (this.lctnSelectDBCenter == null) {
            this.lctnSelectDBCenter = CtrlSwingUtilities.createLabelContainer((JComponent)this.getCbxSelectDBCenter(), (String)"\u9009\u62e9\u6570\u636e\u4e2d\u5fc3", (int)120);
        }
        return this.lctnSelectDBCenter;
    }

    private KDComboBox getCbxSelectDBCenter() {
        if (this.cbxSelectDBCenter == null) {
            this.cbxSelectDBCenter = new KDComboBox();
            this.cbxSelectDBCenter.setEnabled(!this.readOnly);
        }
        return this.cbxSelectDBCenter;
    }

    public Component getLblSql() {
        if (this.lblSql == null) {
            this.lblSql = new KDLabel("SQL\u8bed\u53e5:");
        }
        return this.lblSql;
    }

    public Component getBtnSql() {
        if (this.btnSql == null) {
            this.btnSql = new KDButton("\u6267\u884c");
            this.btnSql.setEnabled(!this.readOnly);
            this.btnSql.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Step2_3_DBCenterSql.this.action_RunSql(Step2_3_DBCenterSql.this.getCbxSelectDBCenter().getSelectedItem(), Step2_3_DBCenterSql.this.getTxaSql().getText().trim());
                }
            });
        }
        return this.btnSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void action_RunSql(Object obj, String sql) {
        if (obj == null || StringUtil.isEmpty(sql)) {
            WindowUtil.msgboxInfo((Object)"\u6570\u636e\u4e2d\u5fc3\u548cSQL\u5747\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"\u63d0\u793a\u4fe1\u606f", (Component)this.getOwner());
            return;
        }
        if (obj instanceof EnumObj) {
            boolean success = false;
            String message = null;
            try {
                success = this.facade.testDBCenterSQL(((EnumObj)obj).getNumber(), sql);
            }
            catch (Exception e) {
                message = e.getMessage();
                e.printStackTrace();
            }
            finally {
                if (!success) {
                    WindowUtil.msgboxInfo((Object)("\u6267\u884cSQL\u8bed\u53e5\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5SQL\uff01\n" + message), (String)"\u63d0\u793a\u4fe1\u606f", (Component)this.getOwner());
                } else {
                    PreviewDialog dlg = (PreviewDialog)((Object)WindowUtil.createWindow(PreviewDialog.class, (Component)this.getOwner()));
                    dlg.setFacade(this.facade);
                    dlg.setSql(sql);
                    dlg.setDbcId(((EnumObj)obj).getNumber());
                    dlg.showDialog();
                }
            }
        } else {
            WindowUtil.msgboxInfo((Object)"\u6570\u636e\u4e2d\u5fc3\u9009\u62e9\u6709\u8bef\uff01\u8bf7\u68c0\u67e5\u6570\u636e\u4e2d\u5fc3\u5b9a\u4e49", (String)"\u63d0\u793a\u4fe1\u606f", (Component)this.getOwner());
        }
    }

    public Component getScroPane() {
        if (this.scroPane == null) {
            this.scroPane = new KDScrollPane((Component)this.getTxaSql());
        }
        return this.scroPane;
    }

    public KDTextArea getTxaSql() {
        if (this.txaSql == null) {
            this.txaSql = new KDTextArea();
            this.txaSql.setEnabled(!this.readOnly);
        }
        return this.txaSql;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        if (readOnly) {
            // empty if block
        }
    }

    @Override
    protected void loadModel() {
        SchemeModel model = (SchemeModel)this.stepsManager.getUserObject();
        this.getTxaSql().setText(model.getDbCenterSql());
        String dbCenterId = model.getDbCenterId();
        EnumObj obj = null;
        int n = this.getCbxSelectDBCenter().getItemCount();
        for (int i = 0; i < n; ++i) {
            obj = (EnumObj)this.getCbxSelectDBCenter().getItemAt(i);
            if (!obj.getNumber().equalsIgnoreCase(dbCenterId)) continue;
            this.getCbxSelectDBCenter().setSelectedItem((Object)obj);
            break;
        }
    }

    @Override
    protected boolean injectModel() {
        SchemeModel model = (SchemeModel)this.stepsManager.getUserObject();
        String dbCenterId = ((EnumObj)this.getCbxSelectDBCenter().getSelectedItem()).getNumber();
        String dbCenterSql = this.getTxaSql().getText().trim();
        List srcColumnList = null;
        try {
            srcColumnList = SchemeUtil.getSrcColumnListFromSQL(this.facade, dbCenterId, dbCenterSql);
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
        }
        if (srcColumnList != null) {
            srcColumnList.add(0, Column.BLANK_COLUMN);
        }
        model.setSrcColumnList(srcColumnList);
        model.setDbCenterId(dbCenterId);
        model.setDbCenterSql(dbCenterSql);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean checkBeforeInject() {
        if (this.getCbxSelectDBCenter().getSelectedItem() == null) {
            WindowUtil.msgboxInfo((Object)"\u5fc5\u987b\u9009\u62e9\u6570\u636e\u4e2d\u5fc3\uff01", (String)"\u63d0\u793a\u4fe1\u606f", (Component)this.getOwner());
            return false;
        }
        String sql = this.getTxaSql().getText().trim();
        if (StringUtil.isEmpty(sql)) {
            WindowUtil.msgboxInfo((Object)"SQL\u8bed\u53e5\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01", (String)"\u63d0\u793a\u4fe1\u606f", (Component)this.getOwner());
            return false;
        }
        boolean success = false;
        String message = null;
        try {
            success = this.facade.testDBCenterSQL(((EnumObj)this.getCbxSelectDBCenter().getSelectedItem()).getNumber(), sql);
            if (!success) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            message = e.getMessage();
            e.printStackTrace();
        }
        finally {
            if (!success) {
                WindowUtil.msgboxInfo((Object)("\u6267\u884cSQL\u8bed\u53e5\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5SQL\uff01\n" + message), (String)"\u63d0\u793a\u4fe1\u606f", (Component)this.getOwner());
            }
        }
        return true;
    }
}

