/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.dialog.measure;

import com.kingdee.bos.bi.model.common.formularengine.FormularChecker;
import com.kingdee.bos.bi.model.common.formularengine.FormularParser;
import com.kingdee.bos.bi.model.common.formularengine.exception.StringParsingException;
import com.kingdee.bos.bi.model.common.formularengine.expr.AbstractExpr;
import com.kingdee.bos.bi.model.common.mm.ComboBoxObject;
import com.kingdee.bos.bi.model.common.mm.measure.MeasureModel;
import com.kingdee.bos.bi.model.ui.dialog.measure.AbstractMeasureDimensionDialog;
import com.kingdee.bos.bi.model.ui.dialog.measure.MeasureAttributeDialog;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MeasureDimensionDialog
extends AbstractMeasureDimensionDialog {
    private static final long serialVersionUID = -7575884892279992780L;
    private List model = null;

    public MeasureDimensionDialog() {
    }

    public MeasureDimensionDialog(Frame owner) {
        super(owner);
    }

    public MeasureDimensionDialog(Dialog owner) {
        super(owner);
    }

    @Override
    protected void todoAddControls(Container parent, Cell thisCell) {
        super.todoAddControls(parent, thisCell);
        if (this.model != null && this.model.size() != 0) {
            for (int i = 0; i < this.model.size(); ++i) {
                this.tblMain.addRow();
                MeasureModel m = (MeasureModel)this.model.get(i);
                this.fillTableRow(this.tblMain.getRowCount() - 1, m);
            }
        }
    }

    @Override
    protected void action_Add() {
        this.callAttributeDialog(-1);
    }

    @Override
    protected void action_Edit() {
        if (!this.checkSelected()) {
            return;
        }
        this.callAttributeDialog(this.tblMain.getSelectManager().getActiveRowIndex());
    }

    private void callAttributeDialog(int rowIndex) {
        MeasureAttributeDialog dlg = (MeasureAttributeDialog)((Object)WindowUtil.createWindow(MeasureAttributeDialog.class, (Component)((Object)this)));
        dlg.init(this.getTableDatas(this.tblMain), rowIndex);
        if (dlg.showDialog()) {
            MeasureModel model = new MeasureModel();
            model.setNumber(dlg._txtNumber.getText().trim());
            model.setName(dlg._txtName.getText().trim());
            model.setFormat(dlg._cbxFormat.getSelectedItem().toString());
            model.setAggregationComboBox(dlg._cbxAggregation.getSelectedItem());
            model.setDatatype(((ComboBoxObject)dlg._cbxDataType.getSelectedItem()).getCode(), dlg._txt_sign.getText().trim(), dlg._txt_prec.getText().trim());
            model.setFormular(dlg._txaFormular.getText().trim());
            model.setFFormulaCalcFlag(dlg.chxFormula.getSelected() == 32 ? 1 : 0);
            model.setFMemo(dlg._txaFMemo.getText().trim());
            if (rowIndex < 0) {
                this.tblMain.addRow();
                this.fillTableRow(this.tblMain.getRowCount() - 1, model);
            } else {
                this.fillTableRow(rowIndex, model);
            }
        }
    }

    private List getTableDatas(KDTable tbl) {
        ArrayList<MeasureModel> list = new ArrayList<MeasureModel>();
        IRow row = null;
        MeasureModel m = null;
        for (int i = 0; i < tbl.getRowCount(); ++i) {
            row = tbl.getRow(i);
            m = new MeasureModel();
            m.setNumber((String)row.getCell(0).getValue());
            m.setName((String)row.getCell(1).getValue());
            m.setFormat((String)row.getCell(2).getValue());
            m.setAggregationComboBox((ComboBoxObject)row.getCell(3).getValue());
            m.setDatatype((MeasureModel.DataType)row.getCell(4).getValue());
            m.setFormular((String)row.getCell(5).getValue());
            m.setFFormulaCalcFlag(row.getCell(6).getValue().equals("\u662f") ? 1 : 0);
            m.setFMemo((String)row.getCell(7).getValue());
            list.add(m);
        }
        return list;
    }

    @Override
    protected void action_Delete() {
        if (this.checkSelected()) {
            List selList = this.getAllSelectedRow(this.tblMain);
            for (int i = this.tblMain.getRowCount(); i >= 0; --i) {
                IRow row = this.tblMain.getRow(i);
                if (row == null || row.getCell("FNumber") == null || !selList.contains(row.getCell("FNumber").getValue() == null ? "" : row.getCell("FNumber").getValue().toString())) continue;
                this.tblMain.removeRow(i);
            }
        }
    }

    private List getAllSelectedRow(KDTable tbl) {
        ArrayList selectBlocks = tbl.getSelectManager().getBlocks();
        KDTSelectBlock selectBlock = null;
        ArrayList<String> rowList = new ArrayList<String>();
        for (int i = 0; i < selectBlocks.size(); ++i) {
            selectBlock = (KDTSelectBlock)selectBlocks.get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                IRow row = tbl.getRow(j);
                rowList.add(row.getCell("FNumber").getValue() == null ? "" : row.getCell("FNumber").getValue().toString());
            }
        }
        return rowList;
    }

    @Override
    protected void action_Click() {
        this.action_Edit();
    }

    protected void onOk() {
        if (this.checkHas()) {
            super.onOk();
        } else {
            WindowUtil.msgboxInfo((Object)"\u5ea6\u91cf\u7ef4\u5ea6\u89c6\u56fe\u4e0d\u5141\u8bb8\u6761\u76ee\u4e3a\u7a7a\uff01", (String)this.getTitle(), (Component)((Object)this));
        }
    }

    private boolean checkHas() {
        if (this.getDiscriptionTxt().length() > 2000) {
            WindowUtil.msgboxWarning((Object)"\u8bf4\u660e\u6587\u5b57\u7684\u6700\u5927\u957f\u5ea6\u4e3a2000\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        List l = this.getTableDatas(this.tblMain);
        return l != null && l.size() > 0;
    }

    private void fillTableRow(int rowIndex, MeasureModel m) {
        IRow row = this.tblMain.getRow(rowIndex);
        row.getCell("FNumber").setValue((Object)m.getNumber());
        row.getCell("FName").setValue((Object)m.getName());
        row.getCell("FFormat").setValue((Object)m.getFormat());
        row.getCell("FAggregation").setValue(m.getAggregationComboBox());
        row.getCell("FDataType").setValue((Object)m.getDatatype());
        row.getCell("FFormular").setValue((Object)m.getFormular());
        row.getCell("FFormulaCalcFlag").setValue((Object)(m.getFFormulaCalcFlag() == 1 ? "\u662f" : "\u5426"));
        row.getCell("FMemo").setValue((Object)m.getFMemo());
    }

    private boolean checkSelected() {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            WindowUtil.msgboxInfo((Object)"\u8bf7\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        return true;
    }

    public List getModel() {
        return this.getTableDatas(this.tblMain);
    }

    public void setModel(List model) {
        this.model = model;
    }

    protected boolean verify() {
        AbstractExpr rootExpr;
        HashMap refers = new HashMap();
        try {
            rootExpr = MeasureDimensionDialog.pickAllFormulas(this.getTableDatas(this.tblMain), refers);
        }
        catch (StringParsingException e) {
            WindowUtil.msgboxWarning((Object)("\u516c\u5f0f\u9519\u8bef" + StringUtil.RETURN + e.getMessage() + " \u3002"), (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        FormularChecker checker = new FormularChecker();
        for (String number : refers.keySet()) {
            Object value = refers.get(number);
            if (value instanceof AbstractExpr) {
                checker.addRefersFormula(number, (AbstractExpr)value);
                continue;
            }
            checker.addExistVarName(number);
        }
        return rootExpr == null || checker.check(rootExpr, this.getTitle(), (Component)((Object)this));
    }

    private static AbstractExpr pickAllFormulas(List lst, Map refers) throws StringParsingException {
        AbstractExpr expr = null;
        for (int i = 0; i < lst.size(); ++i) {
            MeasureModel m = (MeasureModel)lst.get(i);
            String number = m.getNumber();
            String formula = m.getFormular();
            if (StringUtil.isEmptyString((String)formula)) {
                refers.put(number, Boolean.TRUE);
                continue;
            }
            FormularParser fp = new FormularParser();
            expr = fp.parse(formula);
            expr.setNumber(number);
            refers.put(number, expr);
        }
        return expr;
    }
}

