/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.dialog.schedule.logs;

import com.kingdee.bos.bi.model.common.mm.schedule.ScheduleLog;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.dialog.schedule.logs.AbstractScheduleLogDialog;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.List;
import java.util.Vector;

public class ScheduleLogDialog
extends AbstractScheduleLogDialog {
    private static final long serialVersionUID = 5922897707994475658L;
    private Vector ComBoxSerialNumberIteams = null;
    private Vector ComBoxLogTypeIteams = null;
    private ScheduleLog logModel = null;

    public ScheduleLogDialog() {
    }

    public ScheduleLogDialog(Dialog owner) {
        super(owner);
    }

    public ScheduleLogDialog(Frame owner) {
        super(owner);
    }

    @Override
    protected void todoInit() {
        super.todoInit();
        this.btnOk.setVisible(false);
        this.btnCancel.setText("\u5173\u95ed");
    }

    @Override
    protected void todoAddControls(Container parent, Cell thisCell) {
        super.todoAddControls(parent, thisCell);
        this.loadDatas(this.facade, this.scheduleId);
    }

    private void loadDatas(IManagementFacade facade, String scheduleId) {
        try {
            this.ComBoxSerialNumberIteams = ScheduleLog.loadSerialNumberIteams(facade, scheduleId);
            this.ComBoxLogTypeIteams = ScheduleLog.loadLogTypeIteams();
        }
        catch (BIModelRemoteException bIModelRemoteException) {
            // empty catch block
        }
        this.cbxSerialnumber.addItems(this.ComBoxSerialNumberIteams);
        if (this.ComBoxSerialNumberIteams == null || this.ComBoxSerialNumberIteams.size() == 0) {
            this.cbxSerialnumber.setEnabled(false);
            this.cbxLogType.setEnabled(false);
            this.tblMain.setEnabled(false);
            this.btnDelOne.setEnabled(false);
            this.btnDelAll.setEnabled(false);
        }
    }

    @Override
    protected void action_loadAllDatas() {
        try {
            this.logModel = ScheduleLog.load(this.facade, this.currLogId, "all");
        }
        catch (BIModelRemoteException bIModelRemoteException) {
            // empty catch block
        }
        this.initBaseInfo(this.logModel);
    }

    private void initBaseInfo(ScheduleLog model) {
        this.txtBeginTime.setText(model.getFStartTime().toString());
        this.txtExecuteType.setText("manual".equals(model.getFCallType()) ? "\u624b\u5de5" : "\u81ea\u52a8");
        this.txtExecutePerson.setText(model.getFExecutor());
        this.txtTotalTime.setText(model.getAllTime() + "\u79d2");
        this.txtBeginTime.setText(model.getFStartTime().toString());
        this.cbxLogType.removeAllItems();
        this.cbxLogType.addItems(this.ComBoxLogTypeIteams);
        this.initTblMain(model.getLogDetailList());
    }

    private void initTblMain(List logDetailList) {
        this.tblMain.removeRows();
        IRow row = null;
        int n = logDetailList.size();
        for (int r = 0; r < n; ++r) {
            ScheduleLog.LogDetail d = (ScheduleLog.LogDetail)logDetailList.get(r);
            row = this.tblMain.addRow();
            row.getCell("FAMID");
            row.getCell("FAMID").setValue((Object)d.getFAMName());
            row.getCell("FSchemaID").setValue((Object)d.getFSchemaName());
            row.getCell("FType").setValue((Object)(d.getFSchemaType().equals("eas") ? "EAS\u53d6\u6570\u516c\u5f0f" : d.getFSchemaType()));
            row.getCell("FOrder").setValue((Object)Integer.toString(d.getFItemOrder()));
            row.getCell("FLogType").setValue((Object)("error".equals(d.getFLogType()) ? "\u51fa\u9519" : "\u6240\u6709"));
            row.getCell("FLogMemo").setValue((Object)d.getFLogMemo());
        }
    }

    @Override
    protected void action_loadTblDatas() {
        try {
            this.logModel = ScheduleLog.load(this.facade, this.currLogId, this.currLogType);
        }
        catch (BIModelRemoteException bIModelRemoteException) {
            // empty catch block
        }
        if (this.logModel == null) {
            return;
        }
        this.initTblMain(this.logModel.getLogDetailList());
    }

    @Override
    protected void action_DelOne() {
        if (!WindowUtil.msgboxYesNo((Component)((Object)this), (Object)"\u786e\u8ba4\u5220\u9664\u672c\u6761\u8c03\u5ea6\u5e8f\u53f7\u4e0b\u7684\u6240\u6709\u65e5\u5fd7\uff1f", (String)this.getTitle())) {
            return;
        }
        ScheduleLog.DelOne(this.facade, this.currLogId);
        this.cbxSerialnumber.removeAllItems();
        this.cbxLogType.removeAllItems();
        this.loadDatas(this.facade, this.scheduleId);
    }

    @Override
    protected void action_DelAll() {
        if (!WindowUtil.msgboxYesNo((Component)((Object)this), (Object)"\u786e\u8ba4\u5220\u9664\u672c\u6761\u8c03\u5ea6\u65b9\u6848\u4e0b\u7684\u6240\u6709\u65e5\u5fd7\uff1f", (String)this.getTitle())) {
            return;
        }
        ScheduleLog.DelAll(this.facade, this.scheduleId);
        this.cbxSerialnumber.removeAllItems();
        this.cbxLogType.removeAllItems();
        this.tblMain.removeRows();
        this.loadDatas(this.facade, this.scheduleId);
    }
}

