/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Properties;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.InputSource;

public class XmlUtil {
    public static String toGBKString(Element rootElement) throws IOException {
        Document document = new Document(rootElement);
        Format format = Format.getPrettyFormat();
        format.setEncoding("GBK");
        XMLOutputter out = new XMLOutputter(format);
        ByteArrayOutputStream bop = new ByteArrayOutputStream();
        out.output(document, (OutputStream)bop);
        return bop.toString();
    }

    public static String toUTF8String(Element rootElement) throws IOException {
        Document document = new Document(rootElement);
        Format format = Format.getPrettyFormat();
        format.setEncoding("GBK");
        XMLOutputter out = new XMLOutputter(format);
        ByteArrayOutputStream bop = new ByteArrayOutputStream();
        out.output(document, (OutputStream)bop);
        return bop.toString();
    }

    public static String toDefaultString(Element rootElement) throws IOException {
        Document document = new Document(rootElement);
        Format format = Format.getPrettyFormat();
        format.setEncoding("GBK");
        XMLOutputter out = new XMLOutputter(format);
        ByteArrayOutputStream bop = new ByteArrayOutputStream();
        out.output(document, (OutputStream)bop);
        return bop.toString();
    }

    public static String toString(Element rootElement) throws IOException {
        Document document = new Document(rootElement);
        ByteArrayOutputStream bop = new ByteArrayOutputStream();
        Format format = Format.getPrettyFormat();
        format.setEncoding("UTF-8");
        XMLOutputter outter = new XMLOutputter(format);
        outter.output(document, (OutputStream)bop);
        return new String(bop.toByteArray(), "UTF-8");
    }

    public static String getSysFileEncoding() {
        Properties sysProp = new Properties(System.getProperties());
        return sysProp.getProperty("file.encoding");
    }

    public static Element createElement(String elementName) {
        return new Element(elementName);
    }

    public static Element toRootElement(String xml) throws JDOMException, IOException {
        SAXBuilder sb = new SAXBuilder();
        StringReader stringReader = new StringReader(xml);
        InputSource inputSource = new InputSource(stringReader);
        Document doc = sb.build(inputSource);
        return doc.getRootElement();
    }

    public static void main(String[] args) {
        try {
            Element rootElement = new Element("root");
            rootElement.setAttribute("abc", "\u4e2d\u6587");
            byte[] xmlBytes = com.kingdee.bos.ctrl.common.util.xml.XmlUtil.saveXmlBytes((Element)rootElement);
            System.out.println(new String(xmlBytes, "UTF-8"));
            rootElement = new Element("root");
            rootElement.setAttribute("abc", "\u4e2d\u6587");
            System.out.println(XmlUtil.toString(rootElement));
            rootElement = new Element("root");
            rootElement.setAttribute("abc", "\u4e2d\u6587");
            System.out.println(XmlUtil.toUTF8String(rootElement));
            rootElement = new Element("root");
            rootElement.setAttribute("abc", "\u4e2d\u6587");
            System.out.println(XmlUtil.toGBKString(rootElement));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

