/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.app.servo;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.framework.session.SessionInfo;
import com.kingdee.bos.framework.session.SessionListener;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.olap.Connection;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.eas.framework.bireport.app.servo.IBIServo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OlapConnectionServo
implements IBIServo,
SessionListener {
    private static Logger logger = CommonLogger.getLogger((String)OlapConnectionServo.class.getName());
    private static OlapConnectionServo self = null;
    private Map conMap = new HashMap();
    private Map methodMap = new HashMap();
    private Map ctxKeyMap = new HashMap();

    public OlapConnectionServo() {
        if (self != null) {
            throw new RuntimeException("OLAP\u8fde\u63a5\u6c60\u5df2\u7ecf\u521b\u5efa\uff01");
        }
        self = this;
        logger.info((Object)"OLAP\u8fde\u63a5\u6c60\u88ab\u521b\u5efa\u3002");
    }

    public static OlapConnectionServo getInstance() {
        if (self == null) {
            new OlapConnectionServo();
        }
        return self;
    }

    public synchronized Method getMethod(Class cl, String method, Class[] argTypes) throws NoSuchMethodException, SecurityException {
        String key = this.buildMethodKey(cl, method, argTypes);
        Method mm = (Method)this.methodMap.get(key);
        if (mm == null) {
            mm = cl.getMethod(method, argTypes);
            this.methodMap.put(key, mm);
        }
        return mm;
    }

    public Connection get(Context ctx, int caller) {
        return (Connection)this.conMap.get(this.buildConKey(ctx, caller));
    }

    private void addCtxKey(String ctx, String key) {
        ArrayList list = null;
        list = !this.ctxKeyMap.containsKey(ctx) ? new ArrayList(2) : (ArrayList)this.ctxKeyMap.get(ctx);
        list.add(key);
    }

    public void put(Context ctx, int caller, Connection con) {
        String key = this.buildConKey(ctx, caller);
        this.addCtxKey(ctx.getContextID(), key);
        this.conMap.put(key, con);
    }

    public void remove(Context ctx, int caller, boolean doClose) throws OLAPException {
        Connection con = (Connection)this.conMap.remove(this.buildConKey(ctx, caller));
        if (con != null) {
            con.close();
        }
    }

    private String buildConKey(Context ctx, int caller) {
        return ctx.getContextID() + "_" + caller;
    }

    private String buildMethodKey(Class cl, String method, Class[] argTypes) {
        StringBuffer sb = new StringBuffer().append(cl.getName()).append('#').append(method);
        int n = argTypes.length;
        for (int i = 0; i < n; ++i) {
            sb.append(',').append(argTypes[i].getName());
        }
        return sb.toString();
    }

    @Override
    public void startup() {
        logger.info((Object)"OLAP\u8fde\u63a5\u6c60\u521d\u59cb\u5316...");
        SessionManager.addSessionListener((SessionListener)this);
    }

    @Override
    public void shutdown() {
        logger.info((Object)"\u9500\u6bc1OLAP\u8fde\u63a5\u6c60...");
        Iterator iter = this.conMap.values().iterator();
        while (iter.hasNext()) {
            try {
                ((Connection)iter.next()).close();
            }
            catch (Exception exception) {}
        }
        this.conMap.clear();
        this.methodMap.clear();
    }

    public void create(String sessionID, SessionInfo session) {
    }

    public void destory(String sessionID, SessionInfo session) {
        Context ctx = session.getContext();
        List list = (List)this.ctxKeyMap.get(ctx.getContextID());
        if (list == null) {
            return;
        }
        for (String key : list) {
            try {
                Connection con = (Connection)this.conMap.remove(key);
                con.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logger.info((Object)("Session\u8d85\u65f6\u6216\u5ba2\u6237\u7aef\u9000\u51fa\uff0c\u9500\u6bc1OLAP\u8fde\u63a5.SessionID=" + sessionID));
    }
}

