/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.app;

import java.io.File;
import java.io.FileInputStream;
import java.security.AccessControlException;
import java.security.Permission;
import java.util.Properties;
import org.apache.log4j.Logger;

public class EASSecurityManager
extends SecurityManager {
    private static Logger logger = Logger.getLogger(EASSecurityManager.class);
    private static boolean enable = false;
    private static String[] blackWriteList = new String[]{"jsp", "jspx", "php", "py", "bat", "exe", "sh", "asp", "aspx", "cgi", "html", "htm"};
    private static String APUSIC_CONONICAL_PATH = null;

    public static boolean isEnable() {
        return enable;
    }

    @Override
    public void checkWrite(String file) {
        try {
            if (blackWriteList != null && blackWriteList.length > 0) {
                File tmp = new File(file);
                if (APUSIC_CONONICAL_PATH != null && tmp.getCanonicalPath().startsWith(APUSIC_CONONICAL_PATH)) {
                    return;
                }
                String fileName = tmp.getName();
                for (String suffix : blackWriteList) {
                    if (!fileName.endsWith("." + suffix)) continue;
                    logger.error((Object)("write " + file + " is forbidden"));
                    throw new AccessControlException("write " + tmp.getName() + " is forbidden");
                }
            }
        }
        catch (AccessControlException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        super.checkWrite(file);
    }

    @Override
    public void checkPermission(Permission perm) {
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
    }

    static {
        try {
            String APUSIC_HOME;
            String easHome = System.getProperty("EAS_HOME");
            boolean flag = false;
            String javaSecurityPolicy = System.getProperty("java.security.policy");
            File easPolicyFile = new File(easHome + File.separator + "server" + File.separator + "properties" + File.separator + "eas.policy");
            if (easPolicyFile.exists() && javaSecurityPolicy != null && easPolicyFile.getCanonicalPath().equals(new File(javaSecurityPolicy).getCanonicalPath())) {
                flag = true;
            }
            File file = new File(easHome + File.separator + "server" + File.separator + "properties" + File.separator + "easSecurityPolicy.properties");
            if (flag && file.exists()) {
                Properties prop = new Properties();
                prop.load(new FileInputStream(file));
                enable = "true".equals(prop.getProperty("enableEASSecurityManager"));
                String value = prop.getProperty("blackWriteList");
                if (value != null && value.trim().length() == 0) {
                    blackWriteList = null;
                }
                if (value != null && value.trim().length() > 0) {
                    blackWriteList = value.split(",");
                }
            }
            if ((APUSIC_HOME = System.getProperty("APP_SERVER_HOME")) != null) {
                APUSIC_CONONICAL_PATH = new File(APUSIC_HOME).getCanonicalPath();
            }
        }
        catch (Throwable e) {
            logger.error((Object)e);
        }
    }
}

