/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.cache.Utils;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.AbstractF7ConfigFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.app.PinYinHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class F7ConfigFacadeControllerBean
extends AbstractF7ConfigFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.common.app.F7ConfigFacadeControllerBean");
    private static final int HIS_RECORD_NUM = 50;

    @Override
    protected boolean _initPinYin(Context ctx, String entityName) throws BOSException, EASBizException {
        return PinYinHelper.initPinYin(ctx, entityName);
    }

    @Override
    protected boolean _isPinYinField(Context ctx, String queryPK, String field) throws BOSException, EASBizException {
        IMetaDataLoader mdLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        QueryInfo qInfo = (QueryInfo)mdLoader.get(MetaDataTypeList.BASEQUERY, (IMetaDataPK)MetaDataPK.create((String)queryPK));
        EntityObjectInfo entity = (EntityObjectInfo)qInfo.getMainObject().get("entityRef");
        PropertyInfo pinYinPro = entity.getPropertyByName(field + "PinYin");
        PropertyInfo shortPinYinPro = entity.getPropertyByName(field + "ShortPinYin");
        return pinYinPro != null && shortPinYinPro != null;
    }

    @Override
    protected void _addF7HistoryRecord(Context ctx, String pageId, String ctrlId, String[] bizIds) throws BOSException, EASBizException {
        String isolationStr = this.getIsolation(ctx, pageId, ctrlId);
        String updateSql = "update t_bas_webF7history  set FLastUseTime=now() where FIsolation=? and FBizId=?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (String bizId : bizIds) {
            Object[] params = new Object[]{isolationStr, bizId};
            paramsList.add(params);
        }
        DbUtil.executeBatch(ctx, updateSql, paramsList);
        String insertSql = "insert into t_bas_webF7history (FIsolation ,FBizId ,FLastUseTime )select ?,?,now() where not exists (select 1 from t_bas_webF7history where FIsolation=? and FBizId=?)";
        paramsList = new ArrayList();
        for (String bizId : bizIds) {
            Object[] params = new Object[]{isolationStr, bizId, isolationStr, bizId};
            paramsList.add(params);
        }
        DbUtil.executeBatch(ctx, insertSql, paramsList);
        try {
            this.deleteRecords(ctx, isolationStr);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void deleteRecords(Context ctx, String isolation) throws BOSException, SQLException {
        int deleteCount;
        String querySql = "select count(1) c from t_bas_webF7history where FIsolation=?";
        IRowSet rs = DbUtil.executeQuery(ctx, querySql, new Object[]{isolation});
        int count = 0;
        if (rs.next()) {
            count = rs.getInt("c");
        }
        int n = deleteCount = count > 50 ? count - 50 : 0;
        if (deleteCount > 0) {
            String deleteSql = "delete from t_bas_webF7history where fisolation = ? and fbizid in (select top " + deleteCount + " fbizid from t_bas_webF7history where fisolation=? order by flastusetime)";
            DbUtil.execute(ctx, deleteSql, new Object[]{isolation, isolation});
        }
    }

    private String getIsolation(Context ctx, String pageId, String ctrlId) throws BOSException {
        String curUserId = ctx.getCaller().toString();
        String isolationStr = curUserId + pageId + ctrlId;
        return Utils.transMD5((String)isolationStr);
    }

    @Override
    protected Map _getF7HistoryRecords(Context ctx, String pageId, String ctrlId) throws BOSException, EASBizException {
        String isolationStr = this.getIsolation(ctx, pageId, ctrlId);
        String sql = "select FBizId,FLastUseTime from t_bas_webF7history where FIsolation = ? order by FLastUseTime desc";
        IRowSet rs = DbUtil.executeQuery(ctx, sql, new Object[]{isolationStr});
        ArrayList bizIdList = new ArrayList();
        HashMap<String, Timestamp> idAndTimeMap = new HashMap<String, Timestamp>();
        try {
            while (rs.next()) {
                String bizId = rs.getString("FBizId");
                Timestamp lastUseTime = rs.getTimestamp("FLastUseTime");
                if (StringUtils.isEmpty((String)bizId)) continue;
                idAndTimeMap.put(bizId, lastUseTime);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return idAndTimeMap;
    }

    @Override
    protected List _getReturnData(Context ctx, String queryPK, String[] ids, String[] selectors, String bosType) throws BOSException, EASBizException {
        MetaDataPK query = MetaDataPK.create((String)queryPK);
        IMetaDataLoader loader = null;
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        QueryInfo queryInfo = loader.getQuery((IMetaDataPK)query);
        BOSObjectType bosObjectType = null;
        bosObjectType = StringUtils.isEmpty((String)bosType) ? ((SubEntityInfo)queryInfo.getMainObject()).getEntityRef().getType() : BOSObjectType.create((String)bosType);
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        for (String string : selectors) {
            SelectorItemInfo selectorItem = new SelectorItemInfo(string);
            selectorCol.add(selectorItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> idSet = new HashSet<String>();
        for (String id : ids) {
            idSet.add(id);
        }
        FilterItemInfo filterItemInfo = new FilterItemInfo("id", idSet, CompareType.INCLUDE);
        filter.getFilterItems().add(filterItemInfo);
        view.setFilter(filter);
        view.setSelector(selectorCol);
        IObjectCollection coll = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(bosObjectType, view);
        ArrayList<IObjectValue> ret = new ArrayList<IObjectValue>();
        int count = coll.size();
        for (int i = 0; i < count; ++i) {
            IObjectValue ov = coll.getObject(i);
            ret.add(ov);
        }
        return ret;
    }

    @Override
    public List getReturnData(Context ctx, String queryPK, String[] ids, String[] selectors, String bosType, EntityViewInfo entityViewInfo) throws BOSException {
        MetaDataPK query = MetaDataPK.create((String)queryPK);
        IMetaDataLoader loader = null;
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        QueryInfo queryInfo = loader.getQuery((IMetaDataPK)query);
        BOSObjectType bosObjectType = null;
        bosObjectType = StringUtils.isEmpty((String)bosType) ? ((SubEntityInfo)queryInfo.getMainObject()).getEntityRef().getType() : BOSObjectType.create((String)bosType);
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        for (String selector : selectors) {
            SelectorItemInfo selectorItem = new SelectorItemInfo(selector);
            selectorCol.add(selectorItem);
        }
        FilterInfo filter = new FilterInfo();
        HashSet<String> idSet = new HashSet<String>();
        for (String id : ids) {
            idSet.add(id);
        }
        FilterItemInfo filterItem = new FilterItemInfo("id", idSet, CompareType.INCLUDE);
        filter.getFilterItems().add(filterItem);
        entityViewInfo.setFilter(filter);
        entityViewInfo.setSelector(selectorCol);
        IObjectCollection coll = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(bosObjectType, entityViewInfo);
        ArrayList<IObjectValue> ret = new ArrayList<IObjectValue>();
        int count = coll.size();
        for (int i = 0; i < count; ++i) {
            IObjectValue ov = coll.getObject(i);
            ret.add(ov);
        }
        return ret;
    }

    @Override
    protected String _getOpenId(Context ctx, String personId) throws BOSException, EASBizException {
        String openId = null;
        try {
            String checkSql = "select * from KSQL_USERTABLES where KSQL_TABNAME='t_pm_easxtusermap'";
            IRowSet rs = DbUtil.executeQuery(ctx, checkSql);
            if (!rs.next()) {
                return null;
            }
            String querySql = "select fxtid from t_pm_easxtusermap where fpersonId=?";
            rs = DbUtil.executeQuery(ctx, querySql, new Object[]{personId});
            if (rs.next()) {
                openId = rs.getString("fxtid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return openId;
    }
}

