/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.LocaleUtils;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;

public class MetaDataLoaderListener
implements ServletContextListener {
    private static final Logger logger = Logger.getLogger(MetaDataLoaderListener.class);

    public void contextInitialized(ServletContextEvent arg0) {
        Context ctx = new Context(null, "eas", null, LocaleUtils.locale_zh_CN);
        MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        ConfigurationItem item = Configuration.getInstance().getConfigItem("DebugOptions");
        if (item != null) {
            String exceptionCell = item.getProperty("exceptionCellNumber");
            String logCell = item.getProperty("logCellNumber");
            String criIDList = item.getProperty("criticalIDList");
            String criCol = item.getProperty("criticalCollection");
            if (exceptionCell != null) {
                try {
                    int exceptionCellNumber;
                    JdbcRowSet.UPPER_CELLNUMBER_FOR_EXCEPTION = exceptionCellNumber = Integer.parseInt(exceptionCell);
                    logger.debug((Object)("Exception cell number = " + exceptionCellNumber));
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)"Exception cell number config must be integer!", (Throwable)e);
                }
            }
            if (logCell != null) {
                try {
                    int logCellNumber;
                    JdbcRowSet.UPPER_CELLNUMBER_FOR_LOG = logCellNumber = Integer.parseInt(logCell);
                    logger.debug((Object)("Log cell number = " + logCellNumber));
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)"Log cell number config must be integer!", (Throwable)e);
                }
            }
            if (criIDList != null) {
                try {
                    JdbcRowSet.CriticalIDList = Integer.parseInt(criIDList);
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)"criticalIDList config must be integer!", (Throwable)e);
                }
            }
            if (criCol != null) {
                try {
                    JdbcRowSet.CriticalCollection = Integer.parseInt(criCol);
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)"criticalCollection config must be integer!", (Throwable)e);
                }
            }
        }
    }

    public void contextDestroyed(ServletContextEvent arg0) {
    }
}

