/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.message.common.KDMessageAttachment;
import com.kingdee.eas.base.message.IMessageCenter;
import com.kingdee.eas.base.message.MessageCenterFactory;
import com.kingdee.eas.common.CodeTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.IMobileCode;
import com.kingdee.eas.common.MobileCodeException;
import com.kingdee.eas.common.MobileCodeFactory;
import com.kingdee.eas.common.MobileCodeInfo;
import com.kingdee.eas.common.app.AbstractMobileCodeFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mobile.EmailAddressInfo;
import com.kingdee.eas.mobile.EmailSendMessageInfo;
import com.kingdee.eas.mobile.MimeTypeEnum;
import com.kingdee.eas.mobile.dao.DefaultEmailMessageDAO;
import com.kingdee.eas.mobile.util.AppMsgUtil;
import com.kingdee.eas.util.CryptException;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.util.StringUtils;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class MobileCodeFacadeControllerBean
extends AbstractMobileCodeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mobile.app.MobileCodeFacadeControllerBean");
    private static final long defKeepAliveTime = 5L;
    private static final long maxKeepAliveTime = 15L;
    private static final long repeatGenerateTime = 1L;
    private static String smsContent = "\u9a8c\u8bc1\u7801\uff1a%s\uff08%s\u5206\u949f\u5185\u6709\u6548\uff09\u3002\u8be5\u9a8c\u8bc1\u7801\u4ec5\u7528\u4e8e\u91d1\u8776EAS Cloud%s\uff0c\u8bf7\u52ff\u6cc4\u9732\u8be5\u9a8c\u8bc1\u7801\u3002\u5982\u975e\u672c\u4eba\u64cd\u4f5c\uff0c\u8bf7\u5ffd\u7565\u6b64\u6d88\u606f\u3002";

    @Override
    protected boolean _generateSmscode(Context ctx, String num, String funtionName, long keepAliveTime, CodeTypeEnum codeType) throws BOSException, EASBizException {
        IMobileCode mobileCodeInstance = null;
        IMessageCenter messageCenterInstance = null;
        if (StringUtils.isEmpty((String)num)) {
            throw new MobileCodeException(MobileCodeException.NUM_NOT_NULL, new String[]{codeType.getAlias()});
        }
        mobileCodeInstance = MobileCodeFactory.getLocalInstance(ctx);
        messageCenterInstance = MessageCenterFactory.getLocalInstance((Context)ctx);
        MobileCodeInfo mobileCodeInfo = null;
        CoreBaseCollection collection = mobileCodeInstance.getCollection("SELECT * WHERE NUMBER = '" + num + "'");
        if (collection.size() > 0) {
            mobileCodeInfo = (MobileCodeInfo)collection.get(0);
        }
        if (mobileCodeInfo == null) {
            String code = this.getCode();
            String newCode = null;
            try {
                newCode = CryptoTean.encrypt("", code);
            }
            catch (CryptException e) {
                throw new MobileCodeException(MobileCodeException.ENCRYPT_FAIL);
            }
            MobileCodeInfo createMobileCodeInfo = MobileCodeFacadeControllerBean.createMobileCodeInfo(num, keepAliveTime, newCode);
            mobileCodeInstance.addnew(createMobileCodeInfo);
            String content = String.format(smsContent, code, keepAliveTime, funtionName == null ? "" : funtionName);
            if (codeType.getValue() == 1) {
                messageCenterInstance.sendMsg(false, content, num);
            } else {
                MobileCodeFacadeControllerBean.msgMail(ctx, funtionName, 20, false, content, num, null, null, null);
            }
        } else {
            long expiredTime;
            long currentTime = new Date().getTime();
            if (currentTime > (expiredTime = mobileCodeInfo.getExpiredTime().getTime())) {
                this.onMessage(num, funtionName, keepAliveTime, mobileCodeInstance, messageCenterInstance, mobileCodeInfo, ctx, codeType);
            } else {
                long time = currentTime - mobileCodeInfo.getCreateTime().getTime();
                if (time > 60000L) {
                    this.onMessage(num, funtionName, keepAliveTime, mobileCodeInstance, messageCenterInstance, mobileCodeInfo, ctx, codeType);
                } else {
                    throw new MobileCodeException(MobileCodeException.CANNOT_CREATE_REPEATEDLY);
                }
            }
        }
        return true;
    }

    private String getCode() {
        return (int)((new SecureRandom().nextDouble() * 9.0 + 1.0) * 100000.0) + "";
    }

    private void onMessage(String num, String funtionName, long keepAliveTime, IMobileCode mobileCodeInstance, IMessageCenter messageCenterInstance, MobileCodeInfo mobileCodeInfo, Context ctx, CodeTypeEnum codeType) throws MobileCodeException, BOSException, EASBizException {
        String code = this.getCode();
        String newCode = null;
        try {
            newCode = CryptoTean.encrypt("", code);
        }
        catch (CryptException e) {
            throw new MobileCodeException(MobileCodeException.ENCRYPT_FAIL);
        }
        MobileCodeInfo createMobileCodeInfo = MobileCodeFacadeControllerBean.createMobileCodeInfo(num, keepAliveTime, newCode);
        createMobileCodeInfo.setId(mobileCodeInfo.getId());
        mobileCodeInstance.update((IObjectPK)new ObjectUuidPK(mobileCodeInfo.getId()), createMobileCodeInfo);
        String content = String.format(smsContent, code, keepAliveTime, funtionName == null ? "" : funtionName);
        if (codeType.getValue() == 1) {
            messageCenterInstance.sendMsg(false, content, num);
        } else {
            MobileCodeFacadeControllerBean.msgMail(ctx, funtionName, 20, false, content, num, null, null, null);
        }
    }

    private static MobileCodeInfo createMobileCodeInfo(String num, long keepAliveTime, String code) throws MobileCodeException {
        MobileCodeInfo mobileCodeInfo = new MobileCodeInfo();
        mobileCodeInfo.setNumber(num);
        mobileCodeInfo.setCode(code);
        long createTime = new Date().getTime();
        if (keepAliveTime < 0L) {
            keepAliveTime = 5L;
        }
        if (keepAliveTime > 15L) {
            keepAliveTime = 15L;
        }
        long expiredTime = createTime + keepAliveTime * 60L * 1000L;
        mobileCodeInfo.setCreateTime(new Timestamp(createTime));
        mobileCodeInfo.setExpiredTime(new Timestamp(expiredTime));
        return mobileCodeInfo;
    }

    @Override
    protected boolean _checkSmscode(Context ctx, String num, String code, CodeTypeEnum codeType) throws BOSException, EASBizException {
        long expiredTime;
        if (StringUtils.isEmpty((String)num)) {
            throw new MobileCodeException(MobileCodeException.NUM_NOT_NULL, new String[]{codeType.getAlias()});
        }
        IMobileCode mobileCodeInstance = MobileCodeFactory.getLocalInstance(ctx);
        MobileCodeInfo mobileCodeInfo = null;
        CoreBaseCollection collection = mobileCodeInstance.getCollection("SELECT * WHERE NUMBER ='" + num + "'");
        if (collection.size() > 0) {
            mobileCodeInfo = (MobileCodeInfo)collection.get(0);
        }
        if (mobileCodeInfo == null) {
            return false;
        }
        long currentTime = new Date().getTime();
        if (currentTime > (expiredTime = mobileCodeInfo.getExpiredTime().getTime())) {
            throw new MobileCodeException(MobileCodeException.CODE_EXPIRED);
        }
        try {
            code = CryptoTean.encrypt("", code);
        }
        catch (CryptException e) {
            throw new MobileCodeException(MobileCodeException.ENCRYPT_FAIL);
        }
        if (mobileCodeInfo.getCode().equals(code)) {
            mobileCodeInfo.setExpiredTime(new Timestamp(currentTime));
            mobileCodeInstance.update((IObjectPK)new ObjectUuidPK(mobileCodeInfo.getId()), mobileCodeInfo);
            return true;
        }
        return false;
    }

    public static boolean msgMail(Context ctx, String title, int priority, boolean revertible, String content, String address, KDMessageAttachment[] attachment, String assignID, MimeTypeEnum mimeType) throws EASBizException, BOSException {
        EmailSendMessageInfo emailSendMsgInfo = new EmailSendMessageInfo();
        if (mimeType != null) {
            emailSendMsgInfo.setMimeType(mimeType);
        }
        emailSendMsgInfo.setPriority(AppMsgUtil.getPriorityEnum((int)priority));
        emailSendMsgInfo.setRevertible(revertible);
        emailSendMsgInfo.setAssignID(assignID);
        emailSendMsgInfo.setContent(content);
        emailSendMsgInfo.setTitle(title);
        EmailAddressInfo addressInfo = new EmailAddressInfo();
        addressInfo.setTo(address);
        emailSendMsgInfo.setAddress(addressInfo);
        boolean sendSuccess = false;
        IObjectPK pk = DefaultEmailMessageDAO.addNew((Context)ctx, (EmailSendMessageInfo)emailSendMsgInfo);
        if (pk != null) {
            sendSuccess = true;
        }
        return sendSuccess;
    }
}

