/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.common.app.cache;

import com.kingdee.bos.rpc.io.loadbalance.IRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.RPCServerView;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.eas.common.app.cache.ConfigCacheImp;
import com.kingdee.eas.common.app.cache.IConfigCache;
import com.kingdee.eas.common.app.cache.SyncClusterFileUtil;
import com.kingdee.util.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ConfigCacheUtils {
    private static Logger logger = Logger.getLogger(ConfigCacheUtils.class);

    public static void clearBizCache(ConfigCacheImp configCacheImp, Map map) {
        RPCServerView sv = RPCServerView.getLast();
        if (sv == null) {
            logger.error((Object)"sv\u4e3a\u7a7a");
            return;
        }
        IRPCServer[] ss = sv.getServers();
        for (int i = 0; i < ss.length; ++i) {
            String url;
            IRPCServer s = ss[i];
            if (s.connectionFailed() || StringUtils.isEmpty((String)(url = s.getUrl())) || ConfigCacheUtils.isLocal(url)) continue;
            try {
                IConfigCache qct = (IConfigCache)RPCEngineFactory.getEngine((String)url).createObject(configCacheImp.getClass().getName(), IConfigCache.class, new Class[]{List.class}, new Object[]{configCacheImp.getBizList()});
                qct.clearCache(map);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"\u6e05\u9664\u7f13\u5b58\u5931\u8d25\uff01", (Throwable)e);
            }
        }
    }

    public static void syncBizConfig(ConfigCacheImp configCacheImp, Properties properties, Map map) {
        try {
            String syncUrl = SyncClusterFileUtil.getSyncUrl();
            if (StringUtils.isEmpty((String)syncUrl)) {
                logger.error((Object)"syncUrl\u4e3a\u7a7a");
                return;
            }
            IConfigCache srv = (IConfigCache)RPCEngineFactory.getEngine((String)syncUrl).createObject(configCacheImp.getClass().getName(), IConfigCache.class, new Class[]{List.class}, new Object[]{configCacheImp.getBizList()});
            srv.syncClusterConfig(properties, map);
        }
        catch (Exception e) {
            logger.error((Object)"\u540c\u6b65\u4ece\u673a\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    private static boolean isLocal(String url) {
        IServer[] servers = ServerManager.listServers();
        for (int i = 0; i < servers.length; ++i) {
            if (!servers[i].match(url)) continue;
            return true;
        }
        return false;
    }
}

