/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.util.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.BizBalanceException;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.BizHasDealException;
import com.kingdee.eas.common.BizOccrFilterSet;
import com.kingdee.eas.common.BizParamUsedException;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.common.app.IBizCheckBalance;
import com.kingdee.eas.common.app.IBizHasDeal;
import com.kingdee.eas.common.app.IBizHasDeal4Update;
import com.kingdee.eas.common.app.IBizHasDealNew;
import com.kingdee.eas.common.app.IBizParamIsUsed;
import com.kingdee.eas.common.app.IBizReference;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.scm.common.app.bizHasDeal.SCMSupplierCustomerBizHasDeal;
import com.kingdee.eas.util.ResourceBase;
import org.apache.log4j.Logger;

public class BizCheckerUtil {
    static Logger logger = Logger.getLogger(BizCheckerUtil.class);

    public static BizCheckResult bizParamIsUsed(Context ctx, String FNunmber, String orgUnitID) throws BizParamUsedException {
        String[] checkers = null;
        try {
            checkers = RefCheckersDAO.getCheckers(ctx, "A881F3E7", IBizParamIsUsed.class);
        }
        catch (EASDBException e) {
            throw new BizParamUsedException(BizParamUsedException.SQL_ERR, (Throwable)((Object)e));
        }
        logger.debug((Object)(ResourceBase.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "16_BizCheckerUtil", ctx.getLocale()) + FNunmber + ResourceBase.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "17_BizCheckerUtil", ctx.getLocale()) + orgUnitID));
        if (checkers == null || checkers.length == 0) {
            return BizCheckResult.NOTFOUND;
        }
        for (int i = 0; i < checkers.length; ++i) {
            logger.debug((Object)(ResourceBase.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "18_BizCheckerUtil", ctx.getLocale()) + checkers[i]));
            BizCheckResult checkResult = BizCheckResult.NOTFOUND;
            try {
                Class<?> checkerClass = Class.forName(checkers[i]);
                IBizParamIsUsed checker = (IBizParamIsUsed)checkerClass.newInstance();
                if (checker != null) {
                    checkResult = checker.checkParamUsed(ctx, FNunmber, orgUnitID);
                }
            }
            catch (BizParamUsedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BizParamUsedException(BizParamUsedException.CHECK_ERR, e);
            }
            if (!checkResult.isFound()) continue;
            return checkResult;
        }
        return BizCheckResult.NOTFOUND;
    }

    public static BizCheckResult hasBalance(Context ctx, BOSUuid objID) throws BizBalanceException {
        String[] checkers = null;
        try {
            checkers = RefCheckersDAO.getCheckers(ctx, objID.getType().toString(), IBizCheckBalance.class);
        }
        catch (EASDBException e) {
            throw new BizBalanceException(BizBalanceException.SQL_ERR, (Throwable)((Object)e));
        }
        logger.debug((Object)(ResourceBase.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "19_BizCheckerUtil", ctx.getLocale()) + objID.toString()));
        if (checkers == null || checkers.length == 0) {
            return BizCheckResult.NOTFOUND;
        }
        for (int i = 0; i < checkers.length; ++i) {
            logger.debug((Object)(ResourceBase.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "18_BizCheckerUtil", ctx.getLocale()) + checkers[i]));
            BizCheckResult checkResult = BizCheckResult.NOTFOUND;
            try {
                Class<?> checkerClass = Class.forName(checkers[i]);
                IBizCheckBalance checker = (IBizCheckBalance)checkerClass.newInstance();
                if (checker != null) {
                    checkResult = checker.checkHasBalance(ctx, objID);
                }
            }
            catch (BizBalanceException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BizBalanceException(BizBalanceException.CHECK_ERROR, e);
            }
            if (!checkResult.isFound()) continue;
            return checkResult;
        }
        return BizCheckResult.NOTFOUND;
    }

    public static BizCheckResult hasDeal(Context ctx, BOSUuid objID, BizOccrFilterSet filterSet) throws BizHasDealException {
        String[] checkers = null;
        try {
            checkers = RefCheckersDAO.getCheckers(ctx, objID.getType().toString(), IBizHasDeal.class, filterSet);
        }
        catch (EASDBException e) {
            throw new BizHasDealException(BizHasDealException.SQL_ERR, (Throwable)((Object)e));
        }
        if (checkers == null || checkers.length == 0) {
            return BizCheckResult.NOTFOUND;
        }
        for (int i = 0; i < checkers.length; ++i) {
            BizCheckResult checkResult = BizCheckResult.NOTFOUND;
            try {
                Class<?> checkerClass = Class.forName(checkers[i]);
                IBizHasDeal checker = (IBizHasDeal)checkerClass.newInstance();
                if (checker != null) {
                    checkResult = checker.checkHasDeal(ctx, objID);
                }
            }
            catch (BizHasDealException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BizHasDealException(BizHasDealException.CHECK_ERROR, e);
            }
            if (!checkResult.isFound()) continue;
            return checkResult;
        }
        return BizCheckResult.NOTFOUND;
    }

    public static BizCheckResult hasDeal(Context ctx, BOSUuid objID) throws BizHasDealException {
        String[] checkers = null;
        try {
            checkers = RefCheckersDAO.getCheckers(ctx, objID.getType().toString(), IBizHasDeal.class);
        }
        catch (EASDBException e) {
            throw new BizHasDealException(BizHasDealException.SQL_ERR, (Throwable)((Object)e));
        }
        logger.debug((Object)(ResourceBase.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "20_BizCheckerUtil", ctx.getLocale()) + objID.toString()));
        if (checkers == null || checkers.length == 0) {
            return BizCheckResult.NOTFOUND;
        }
        for (int i = 0; i < checkers.length; ++i) {
            logger.debug((Object)(ResourceBase.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "18_BizCheckerUtil", ctx.getLocale()) + checkers[i]));
            BizCheckResult checkResult = BizCheckResult.NOTFOUND;
            try {
                Object checker;
                Class<?> checkerClass = Class.forName(checkers[i]);
                if (checkerClass == SCMSupplierCustomerBizHasDeal.class) {
                    checker = (IBizHasDealNew)checkerClass.newInstance();
                    if (checker != null) {
                        checkResult = checker.checkHasDeal(ctx, new BOSUuid[]{objID});
                    }
                } else {
                    checker = (IBizHasDeal)checkerClass.newInstance();
                    if (checker != null) {
                        checkResult = checker.checkHasDeal(ctx, objID);
                    }
                }
            }
            catch (BizHasDealException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BizHasDealException(BizHasDealException.CHECK_ERROR, e);
            }
            if (!checkResult.isFound()) continue;
            return checkResult;
        }
        return BizCheckResult.NOTFOUND;
    }

    public static BizCheckResult hasDeal4Update(Context ctx, BOSUuid objID) throws BizHasDealException {
        String[] checkers = null;
        try {
            checkers = RefCheckersDAO.getCheckers(ctx, objID.getType().toString(), IBizHasDeal4Update.class);
        }
        catch (EASDBException e) {
            throw new BizHasDealException(BizHasDealException.SQL_ERR, (Throwable)((Object)e));
        }
        logger.debug((Object)(ResourceBase.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "20_BizCheckerUtil", ctx.getLocale()) + objID.toString()));
        if (checkers == null || checkers.length == 0) {
            return BizCheckResult.NOTFOUND;
        }
        for (int i = 0; i < checkers.length; ++i) {
            logger.debug((Object)(ResourceBase.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "18_BizCheckerUtil", ctx.getLocale()) + checkers[i]));
            BizCheckResult checkResult = BizCheckResult.NOTFOUND;
            try {
                Class<?> checkerClass = Class.forName(checkers[i]);
                IBizHasDeal4Update checker = (IBizHasDeal4Update)checkerClass.newInstance();
                if (checker != null) {
                    checkResult = checker.checkHasDeal4Update(ctx, objID);
                }
            }
            catch (BizHasDealException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BizHasDealException(BizHasDealException.CHECK_ERROR, e);
            }
            if (!checkResult.isFound()) continue;
            return checkResult;
        }
        return BizCheckResult.NOTFOUND;
    }

    public static BizCheckResult isReferenced(Context ctx, BOSUuid objID) throws BizReferenceException {
        String[] checkers = null;
        try {
            checkers = RefCheckersDAO.getCheckers(ctx, objID.getType().toString(), IBizReference.class);
        }
        catch (EASDBException e) {
            throw new BizReferenceException(BizReferenceException.SQL_ERR, (Throwable)((Object)e));
        }
        logger.debug((Object)(ResourceBase.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "21_BizCheckerUtil", ctx.getLocale()) + objID.toString()));
        if (checkers == null || checkers.length == 0) {
            return BizCheckResult.NOTFOUND;
        }
        for (int i = 0; i < checkers.length; ++i) {
            logger.debug((Object)(ResourceBase.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "18_BizCheckerUtil", ctx.getLocale()) + checkers[i]));
            BizCheckResult checkResult = BizCheckResult.NOTFOUND;
            try {
                Class<?> checkerClass = Class.forName(checkers[i]);
                IBizReference checker = (IBizReference)checkerClass.newInstance();
                if (checker != null) {
                    checkResult = checker.checkReferenced(ctx, objID);
                }
            }
            catch (BizReferenceException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BizReferenceException(BizReferenceException.CHECK_ERROR, e);
            }
            if (!checkResult.isFound()) continue;
            return checkResult;
        }
        return BizCheckResult.NOTFOUND;
    }

    public static BizCheckResult hasDeal(Context ctx, BOSUuid[] objIDs) throws BizHasDealException {
        String[] checkers = null;
        try {
            checkers = RefCheckersDAO.getCheckers(ctx, objIDs[0].getType().toString(), IBizHasDealNew.class);
        }
        catch (EASDBException e) {
            throw new BizHasDealException(BizHasDealException.SQL_ERR, (Throwable)((Object)e));
        }
        logger.debug((Object)(ResourceBase.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "20_BizCheckerUtil", ctx.getLocale()) + objIDs.toString()));
        if (checkers == null || checkers.length == 0) {
            return BizCheckResult.NOTFOUND;
        }
        for (int i = 0; i < checkers.length; ++i) {
            logger.debug((Object)(ResourceBase.getString("com.kingdee.eas.common.COMMONAutoGenerateResource", "18_BizCheckerUtil", ctx.getLocale()) + checkers[i]));
            BizCheckResult checkResult = BizCheckResult.NOTFOUND;
            try {
                Class<?> checkerClass = Class.forName(checkers[i]);
                IBizHasDealNew checker = (IBizHasDealNew)checkerClass.newInstance();
                if (checker != null) {
                    checkResult = checker.checkHasDeal(ctx, objIDs);
                }
            }
            catch (BizHasDealException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BizHasDealException(BizHasDealException.CHECK_ERROR, e);
            }
            if (!checkResult.isFound()) continue;
            return checkResult;
        }
        return BizCheckResult.NOTFOUND;
    }
}

