/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.util.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class DbUtil {
    private static final Logger logger = Logger.getLogger(DbUtil.class);
    private static final String SQL_TIP1 = "333 sql is:";
    public static final String CONFIG_EXCEPTION = "CONFIG_EXCEPTION";
    private static final int MAX_DATA_ROW = 8000;

    public static IRowSet executeQueryNoTx(Context ctx, String sql) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getQueryConnection((Context)ctx);
            statement = conn.createStatement();
            rs = statement.executeQuery(sql);
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)("555 is:" + sql), (Throwable)exc);
                throw new BOSException("Sql5 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return jdbcRowSet;
    }

    public static IRowSet executeQueryNoTx(Context ctx, String sql, Object[] params) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getQueryConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                StringBuffer sb = new StringBuffer("");
                for (int i = 0; i < params.length; ++i) {
                    sb.append("param ").append(i).append(" is:").append(params[i]);
                }
                logger.error((Object)("444 sql is:" + sql + " param is:" + sb.toString()), (Throwable)exc);
                throw new BOSException("Sql4 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return jdbcRowSet;
    }

    public static IRowSet executeQuery(Context ctx, String sql) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException(CONFIG_EXCEPTION, (Throwable)exc);
        }
        try {
            statement = conn.createStatement();
            rs = statement.executeQuery(sql);
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)(SQL_TIP1 + sql), (Throwable)exc);
                throw new BOSException("Sql3 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return jdbcRowSet;
    }

    public static IRowSet executeQuery(Context ctx, String sql, int start, int rows) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException(CONFIG_EXCEPTION, (Throwable)exc);
        }
        try {
            statement = conn.createStatement();
            rs = statement.executeQuery(sql);
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs, start, rows, true);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)(SQL_TIP1 + sql), (Throwable)exc);
                throw new BOSException("Sql3 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return jdbcRowSet;
    }

    public static IRowSet executeQuery(Context ctx, String sql, Object[] params) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException(CONFIG_EXCEPTION, (Throwable)exc);
        }
        try {
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                StringBuffer sb = new StringBuffer("");
                for (int i = 0; i < params.length; ++i) {
                    sb.append("param ").append(i).append(" is:").append(params[i]);
                }
                logger.error((Object)("sql is:" + sql + " param is:" + sb.toString()));
                logger.error((Object)"sql error!", (Throwable)exc);
                throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return jdbcRowSet;
    }

    public static void execute(Context ctx, String sql) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException(CONFIG_EXCEPTION, (Throwable)exc);
        }
        try {
            statement = conn.createStatement();
            statement.execute(sql);
        }
        catch (SQLException exc) {
            logger.error((Object)("sql 1 sql is:" + sql), (Throwable)exc);
            throw new BOSException("Sql1 execute exception : " + sql, (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((Statement)statement, (Connection)conn);
        }
    }

    public static void execute(Context ctx, String sql, Object[] params) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException(CONFIG_EXCEPTION, (Throwable)exc);
        }
        try {
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            ps.execute();
        }
        catch (SQLException exc) {
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < params.length; ++i) {
                sb.append("param ").append(i).append(" is:").append(params[i]);
            }
            logger.error((Object)("222 sql is:" + sql + " param is:" + sb.toString()), (Throwable)exc);
            throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
        }
    }

    public static void prepareVarcharParam(PreparedStatement stmt, int index, String param) throws SQLException {
        stmt.setString(index, param);
    }

    public static int[] executeBatchAndReturn(Context ctx, String sql, List paramsList) throws BOSException {
        return DbUtil.executeBatchAndReturn(ctx, sql, paramsList, null);
    }

    public static int[] executeBatchAndReturn(Context ctx, String sql, List paramsList, int[] types) throws BOSException {
        PreparedStatement ps;
        Connection conn;
        block11: {
            int[] nArray;
            conn = null;
            ps = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                ps = conn.prepareStatement(sql);
                int dbType = KSqlUtil.getDbType((Connection)conn);
                Object[] params = null;
                int k = 1;
                boolean flag = false;
                for (int i = 0; i < paramsList.size(); ++i) {
                    params = (Object[])paramsList.get(i);
                    for (int j = 0; j < params.length; ++j) {
                        if (params[j] != null) {
                            if (types != null) {
                                ps.setObject(j + 1, params[j], types[j]);
                                continue;
                            }
                            ps.setObject(j + 1, params[j]);
                            continue;
                        }
                        if (types != null) {
                            ps.setNull(j + 1, types[j]);
                            continue;
                        }
                        if (dbType == 5 || dbType == 12) {
                            ps.setNull(j + 1, 0);
                            continue;
                        }
                        ps.setNull(j + 1, 12);
                    }
                    ps.addBatch();
                    if (i == k * 8000) {
                        flag = true;
                    }
                    if (i <= k * 8000 || !flag) continue;
                    ps.executeBatch();
                    ++k;
                    flag = false;
                    ps.clearBatch();
                }
                if (flag) break block11;
                nArray = ps.executeBatch();
            }
            catch (SQLException exc) {
                try {
                    Object sb = null;
                    Object params = null;
                    throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
            return nArray;
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return new int[0];
    }

    public static void executeBatch(Context ctx, String sql, List paramsList) throws BOSException {
        DbUtil.executeBatchAndReturn(ctx, sql, paramsList);
    }

    public static void executeBatch(Context ctx, String sql, List paramsList, int[] types) throws BOSException {
        DbUtil.executeBatchAndReturn(ctx, sql, paramsList, types);
    }
}

