/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.behavior.domain;

import com.kingdee.bos.qing.behavior.model.BehaviorChannelMessage;
import com.kingdee.bos.qing.behavior.model.Data;
import com.kingdee.bos.qing.behavior.model.LogResult;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.framework.server.msgpublish.ServerChannelMessagePublisher;
import com.kingdee.bos.qing.util.HttpUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Properties;

public class BehaviorDomain {
    private static String BEHAVIOR_URL = null;
    private static boolean SEND_ON_SERVER = false;
    private static String LOGTYPE_USER_BEHAVIOR_SCENE = null;
    private static String LOGTYPE_OPERATING_ENV = null;
    private static volatile Boolean connAvailable = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isConnAvailable() {
        if (connAvailable != null) return connAvailable;
        Class<BehaviorDomain> clazz = BehaviorDomain.class;
        synchronized (BehaviorDomain.class) {
            if (connAvailable != null) return connAvailable;
            try {
                URL url = new URL(BEHAVIOR_URL);
                URLConnection conn = url.openConnection();
                conn.setRequestProperty("accept", "*/*");
                conn.setRequestProperty("connection", "Keep-Alive");
                conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setConnectTimeout(1000);
                conn.connect();
                connAvailable = true;
            }
            catch (Exception e) {
                connAvailable = false;
            }
            return connAvailable;
        }
    }

    public static void sendBehaviorMessage(QingContext qingContext, Object message, String logtype) {
        ArrayList<Data> dataList = new ArrayList<Data>();
        Data data = new Data();
        data.setLogtype(logtype);
        data.setMessage(message);
        dataList.add(data);
        LogResult logResult = new LogResult();
        logResult.setLogtype(logtype);
        logResult.setData(dataList);
        if (SEND_ON_SERVER && BehaviorDomain.isConnAvailable()) {
            HttpUtil.post(BEHAVIOR_URL, null, JsonUtil.encodeToString(logResult));
        } else {
            BehaviorChannelMessage behaviorChannelMessage = new BehaviorChannelMessage();
            behaviorChannelMessage.setLogResult(logResult);
            behaviorChannelMessage.setUrl(BEHAVIOR_URL);
            ServerChannelMessagePublisher.publish("BehaviorChannel", JsonUtil.encodeToString(behaviorChannelMessage));
        }
    }

    public static String getBehaviorUrl() {
        return BEHAVIOR_URL;
    }

    public static String getSceneLogType() {
        return LOGTYPE_USER_BEHAVIOR_SCENE;
    }

    public static String getOpEnvLogType() {
        return LOGTYPE_OPERATING_ENV;
    }

    static {
        Properties prop = new Properties();
        try {
            InputStream in = BehaviorDomain.class.getResourceAsStream("/behavior.properties");
            prop.load(in);
        }
        catch (Exception e) {
            LogUtil.error("load behavior.properties error", e);
        }
        BEHAVIOR_URL = prop.getProperty("qing_behavior_url");
        SEND_ON_SERVER = Boolean.parseBoolean(prop.getProperty("qing_behavior_sendOnServer"));
        String behaviorClientId = prop.getProperty("qing_behavior_client_id");
        String behaviorClientKey = prop.getProperty("qing_behavior_client_key");
        BEHAVIOR_URL = BEHAVIOR_URL + "?client_id=" + behaviorClientId + "&client_secret=" + behaviorClientKey;
        LOGTYPE_USER_BEHAVIOR_SCENE = prop.getProperty("qing_behavior_logtype_user_behavior_scene");
        LOGTYPE_OPERATING_ENV = prop.getProperty("qing_bahavior_logtype_operating_env");
    }
}

