/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager.fileresource;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.filesystem.manager.api.IFileResourceService;
import com.kingdee.bos.qing.filesystem.manager.fileresource.domain.FileResourceDomain;
import com.kingdee.bos.qing.filesystem.manager.fileresource.model.FileResourcePO;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingFileInfo;
import com.kingdee.bos.qing.filesystem.manager.model.QingFileResourceInfo;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.resource.exception.ResourceManagementException;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.Date;

public class FileResourceService
implements IFileResourceService {
    private QingContext qingContext;
    private FileResourceDomain fileResourceDomain;

    public FileResourceService(QingContext qingContext, ITransactionManagement tx, IDBExcuter idbExcuter) {
        this.qingContext = qingContext;
        this.fileResourceDomain = new FileResourceDomain(qingContext, tx, idbExcuter);
    }

    @Override
    public boolean requestFileSize(long fileSizeByte) throws AbstractQingIntegratedException, ResourceManagementException {
        return this.fileResourceDomain.isEnoughFileSize(fileSizeByte);
    }

    @Override
    public void saveFile(QingFileInfo fileInfo, QingFileResourceInfo resourceInfo) throws AbstractQingIntegratedException, ResourceManagementException {
        String tenantId = this.qingContext.getTenantId();
        String userId = this.qingContext.getUserId();
        FileResourcePO resourceFile = new FileResourcePO();
        resourceFile.setTenantId(tenantId);
        resourceFile.setUserId(userId);
        resourceFile.setFromId(resourceInfo.getFromId());
        resourceFile.setFileSize(fileInfo.getFileSize());
        resourceFile.setFileName(fileInfo.getName());
        resourceFile.setDisplayName(resourceInfo.getDisplayName());
        resourceFile.setFromType(resourceInfo.getFromType());
        if (fileInfo.getFileType() instanceof QingPersistentFileType) {
            QingPersistentFileType fileType = (QingPersistentFileType)fileInfo.getFileType();
            resourceFile.setFileTypeSubFolder(fileType.getSubFolder());
            resourceFile.setCreateDate(new Date());
            this.fileResourceDomain.insert(resourceFile);
        } else {
            LogUtil.warn("saveFile fileType un need save");
        }
    }

    @Override
    public void deleteFile(AbstractQingFileType fileType, String fileName) throws AbstractQingIntegratedException, ResourceManagementException {
        this.fileResourceDomain.deleteFileByFileTypeSubFolderAndFileName(fileType, fileName);
    }
}

