/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager.fileresource.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.filesystem.manager.localimpl.LocalPersistentQingFile;
import com.kingdee.bos.qing.filesystem.manager.model.QingPersistentFileType;
import com.kingdee.bos.qing.filesystem.manager.model.ResourceFromType;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;

public class CleanFileResourceDomain {
    private QingContext qingContext;
    private IDBExcuter dbExcuter;
    private ITransactionManagement tx;
    private static Set<String> IS_CLEANED_ACCOUNTIDS = new HashSet<String>();

    public CleanFileResourceDomain(QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx) {
        this.qingContext = qingContext;
        this.dbExcuter = dbExcuter;
        this.tx = tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncCleanTask() {
        Set<String> set = IS_CLEANED_ACCOUNTIDS;
        synchronized (set) {
            if (IS_CLEANED_ACCOUNTIDS.contains(this.qingContext.getAccountId())) {
                return;
            }
            IS_CLEANED_ACCOUNTIDS.add(this.qingContext.getAccountId());
        }
        CleanTask task = new CleanTask();
        ThreadPoolManage.excuteThreadWithContext(ThreadPoolManage.QingThreadPoolName.QING_RUN_IN_BACKGROUND_HANDLER, task, this.qingContext);
    }

    private void cleanWork() {
        String cleanThemeFileSql = "SELECT FR.FID, FR.FFILENAME, FR.FFROMTYPE FROM T_QING_FILE_RESOURCE FR LEFT JOIN T_QING_THEME TE ON FR.FFROMID = TE.FID WHERE (FR.FFROMTYPE='THEME' or FR.FFROMTYPE='THEMESCHEDULE') AND (TE.FISDELETE = '1' or TE.FID IS NULL) ORDER BY FR.FID";
        this.clean(cleanThemeFileSql);
        String cleanPublishFileSql = "SELECT FR.FID, FR.FFILENAME, FR.FFROMTYPE FROM T_QING_FILE_RESOURCE FR LEFT JOIN T_QING_PUBLISH PUB ON FR.FFROMID = PUB.FID WHERE (FR.FFROMTYPE='CARDTHUMBNAIL' or FR.FFROMTYPE='PUBLISHED') AND PUB.FID IS NULL AND FR.FFROMID LIKE 'QingAnalysis-%'ORDER BY FR.FID";
        this.clean(cleanPublishFileSql);
        String cleanImageFileSql = "SELECT FR.FID, FR.FFILENAME, FR.FFROMTYPE FROM T_QING_FILE_RESOURCE FR LEFT JOIN T_QING_IMGLIB_IMG_INFO IMG ON FR.FFROMID = IMG.FID WHERE FR.FFROMTYPE='IMAGELIBRARY' AND IMG.FID IS NULL ORDER BY FR.FID";
        this.clean(cleanImageFileSql);
    }

    private void clean(String sql) {
        try {
            List<Model> list = this.dbExcuter.query(sql, new Object[0], new ResultHandler<List<Model>>(){

                @Override
                public List<Model> handle(ResultSet rs) throws SQLException {
                    ArrayList<Model> list = new ArrayList<Model>(10);
                    while (rs.next()) {
                        Model model = new Model();
                        model.setId(rs.getString("FID"));
                        model.setFileName(rs.getString("FFILENAME"));
                        model.setFromType(rs.getString("FFROMTYPE"));
                        list.add(model);
                    }
                    return list;
                }
            });
            for (Model model : list) {
                this.delete(model.getId(), model.getFromType(), model.getFileName());
            }
        }
        catch (Exception e) {
            LogUtil.error("clean query error, sql:" + sql, e);
        }
    }

    private void delete(String id, String fromType, String fileName) {
        try {
            this.deleteDisk(fromType, fileName);
            this.deleteDB(id);
        }
        catch (Exception e) {
            LogUtil.error("delete error", e);
        }
    }

    private void deleteDisk(String fromType, String fileName) {
        ResourceFromType resourceFromType = ResourceFromType.fromPersistance(fromType);
        QingPersistentFileType fileType = ResourceFromType.resourceFromTypeToFileType(resourceFromType);
        LocalPersistentQingFile localPersistentQingFile = new LocalPersistentQingFile(fileType, fileName);
        if (localPersistentQingFile.exists()) {
            localPersistentQingFile.delete();
        }
    }

    private void deleteDB(String id) throws AbstractQingIntegratedException, SQLException {
        try {
            this.tx.beginRequired();
            String sql = "DELETE FROM T_QING_FILE_RESOURCE WHERE FID=?";
            this.dbExcuter.execute(sql, new Object[]{id});
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw e;
        }
        finally {
            this.tx.end();
        }
    }

    private static class Model {
        private String id;
        private String fileName;
        private String fromType;

        private Model() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getFromType() {
            return this.fromType;
        }

        public void setFromType(String fromType) {
            this.fromType = fromType;
        }
    }

    class CleanTask
    implements Callable<Object> {
        CleanTask() {
        }

        @Override
        public Object call() throws Exception {
            CleanFileResourceDomain.this.cleanWork();
            return null;
        }
    }
}

