/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.msgbus.deliver;

import com.kingdee.bos.qing.msgbus.deliver.DelivererFactory;
import com.kingdee.bos.qing.msgbus.deliver.IAsynDeliverMsg;
import com.kingdee.bos.qing.msgbus.model.msgpack.MsgPackToDeliver;
import com.kingdee.bos.qing.msgbus.model.node.Node;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import java.util.List;

public class MsgDelivererHelper {
    public static void deliver(List<MsgPackToDeliver> msgPacks) {
        DeliverTask task = new DeliverTask(msgPacks);
        ThreadPoolManage.submit(ThreadPoolManage.QingThreadPoolName.QING_SHORT_TIME_TASK_HANDLER, task);
    }

    private static class DeliverTask
    implements Runnable {
        private List<MsgPackToDeliver> msgPacks;

        public DeliverTask(List<MsgPackToDeliver> msgPacks) {
            this.msgPacks = msgPacks;
        }

        @Override
        public void run() {
            for (MsgPackToDeliver msgPack : this.msgPacks) {
                Node receiver = msgPack.getReceiver();
                IAsynDeliverMsg msgDeliverer = DelivererFactory.getDeliverer(receiver.getNodeType());
                if (msgDeliverer == null) continue;
                msgDeliverer.deliver(receiver, msgPack.getMessage());
            }
        }
    }
}

