/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.msgbus.sort;

import com.kingdee.bos.qing.msgbus.QingIframeNodeHelper;
import com.kingdee.bos.qing.msgbus.model.node.Node;
import com.kingdee.bos.qing.msgbus.model.node.NodeType;
import com.kingdee.bos.qing.msgbus.model.node.QingIframeNode;
import com.kingdee.bos.qing.msgbus.sort.INodeCreate;
import com.kingdee.bos.qing.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class NodeFactory {
    private static Map<NodeType, Class<? extends Node>> nodeMap = new HashMap<NodeType, Class<? extends Node>>();
    private static Set<INodeCreate> nodeCreators = new HashSet<INodeCreate>();

    public static void registCreator(INodeCreate nodeCreator) {
        nodeCreators.add(nodeCreator);
    }

    public static Node createNode(String nodeId) {
        INodeCreate creator;
        Node node = null;
        Iterator<INodeCreate> nodeCreatorIterator = nodeCreators.iterator();
        while (nodeCreatorIterator.hasNext() && (node = (creator = nodeCreatorIterator.next()).createNode(nodeId)) == null) {
        }
        return node;
    }

    static {
        nodeCreators.add(new INodeCreate(){

            @Override
            public Node createNode(String nodeId) {
                String clientId = QingIframeNodeHelper.getClientId(nodeId);
                if (StringUtils.isBlank(clientId)) {
                    return null;
                }
                QingIframeNode node = new QingIframeNode();
                node.setClientId(clientId);
                return node;
            }
        });
    }
}

