/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.resource;

import com.kingdee.bos.qing.behavior.impl.BehaviorService;
import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBAccessable;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.exceptionlog.domain.ExceptionLogDomain;
import com.kingdee.bos.qing.exceptionlog.model.ExceptionLogBizTypeEnum;
import com.kingdee.bos.qing.filesystem.manager.CopyWriteCall;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileUpdater;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.FileTypeUtil;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.resource.AbstractResourceManager;
import com.kingdee.bos.qing.resource.ResourceManagerFactory;
import com.kingdee.bos.qing.resource.domain.ResourceInfoDomain;
import com.kingdee.bos.qing.resource.exception.DownloadFileException;
import com.kingdee.bos.qing.resource.exception.UploadFileException;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.IOUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;

public class ResourceService
extends BehaviorService
implements IQingContextable,
IDBAccessable {
    private QingContext qingContext;
    private ITransactionManagement tx;
    private IDBExcuter dbExcuter;
    private ResourceInfoDomain resourceInfoDomain;
    private ExceptionLogDomain exceptionLogDomain;

    @Override
    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    @Override
    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    @Override
    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    private ResourceInfoDomain getResourceInfoDomain() {
        if (this.resourceInfoDomain == null) {
            AbstractResourceManager resourceManager = ResourceManagerFactory.createResourceManager(this.qingContext);
            this.resourceInfoDomain = new ResourceInfoDomain(resourceManager);
        }
        return this.resourceInfoDomain;
    }

    private ExceptionLogDomain getExceptionLogDomain() {
        if (this.exceptionLogDomain == null) {
            this.exceptionLogDomain = new ExceptionLogDomain(this.tx, this.dbExcuter);
        }
        return this.exceptionLogDomain;
    }

    public byte[] hasResourceManager(Map<String, String> params) {
        ResponseSuccessWrap wrap = new ResponseSuccessWrap(this.getResourceInfoDomain().hasResourceManager());
        this.interestInBehavior(wrap, 0L, null);
        return ResponseUtil.output(wrap);
    }

    public byte[] resourceInfoStatistics(Map<String, String> params) {
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(this.getResourceInfoDomain().resourceInfoStatistics());
            this.interestInBehavior(wrap, 0L, null);
            return ResponseUtil.output(wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output(e);
        }
    }

    public byte[] getResourceInfoDetailList(Map<String, String> params) {
        String resourceType = params.get("resourceType");
        String sortField = params.get("sortField");
        String sortOrder = params.get("sortOrder");
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(this.getResourceInfoDomain().getResourceInfoDetailList(resourceType, sortField, sortOrder));
            this.interestInBehavior(wrap, 0L, null);
            return ResponseUtil.output(wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output(e);
        }
    }

    public byte[] loadExceptionLog(Map<String, String> params) {
        String id = params.get("id");
        try {
            ResponseSuccessWrap wrap = new ResponseSuccessWrap(this.getExceptionLogDomain().selectByBizIdAndBizType(id, ExceptionLogBizTypeEnum.SCHEDULE_EXECUTE));
            this.interestInBehavior(wrap, 0L, null);
            return ResponseUtil.output(wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getFileData(Map<String, String> params) {
        int len;
        byte[] result;
        QingInputStream inputStream;
        block7: {
            String fileName = params.get("fileName");
            String typeIndexString = params.get("typeIndex");
            Integer typeIndex = Integer.valueOf(typeIndexString);
            AbstractQingFileType fileType = FileTypeUtil.getInstanceByTypeIndex(typeIndex);
            long offset = Long.parseLong(params.get("offset"));
            inputStream = null;
            result = new byte[65536];
            len = -1;
            IQingFileVisitor exportFile = FileFactory.newFileVisitor(fileType, fileName);
            inputStream = exportFile.getInputStream();
            inputStream.seek(offset);
            len = inputStream.read(result);
            if (len != -1) break block7;
            byte[] byArray = null;
            CloseUtil.close(inputStream);
            return byArray;
        }
        try {
            result = Arrays.copyOf(result, len);
        }
        catch (IOException e) {
            try {
                DownloadFileException downloadFileException = new DownloadFileException(e);
                result = ResponseUtil.output(downloadFileException);
                len = -1;
            }
            catch (Throwable throwable) {
                CloseUtil.close(inputStream);
                throw throwable;
            }
            CloseUtil.close(inputStream);
        }
        CloseUtil.close(inputStream);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(len > 0 ? 0 : 1);
        try {
            outputStream.write(result);
        }
        catch (IOException e) {
            LogUtil.error(e.getMessage(), e);
        }
        return outputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] uploadFileItem(FileItem fileItem, String fileDisplayName) {
        byte[] byArray;
        IQingFile qingFile = FileFactory.newTempFile(QingTempFileType.UPLOAD);
        InputStream inputStream = null;
        try {
            inputStream = fileItem.getInputStream();
            inputStream = new BufferedInputStream(inputStream);
            qingFile.write(new CopyWriteCall(inputStream, false), true);
            byArray = ResponseUtil.output(new ResponseSuccessWrap(qingFile.getName()));
        }
        catch (IOException e) {
            byte[] byArray2;
            try {
                UploadFileException uploadFileException = new UploadFileException(e);
                byArray2 = ResponseUtil.output(uploadFileException);
            }
            catch (Throwable throwable) {
                CloseUtil.close(inputStream);
                throw throwable;
            }
            CloseUtil.close(inputStream);
            return byArray2;
        }
        CloseUtil.close(inputStream);
        return byArray;
    }

    public byte[] uploadPiece(String fileNameKey, byte[] bytes, int index) {
        String name = fileNameKey + "." + index;
        IQingFile qingFile = FileFactory.newTempFile(QingTempFileType.UPLOAD);
        QingSessionUtil.set(name, qingFile.getName());
        try {
            qingFile.write(new CopyWriteCall(new BufferedInputStream(new ByteArrayInputStream(bytes)), false), true);
        }
        catch (IOException e) {
            UploadFileException uploadFileException = new UploadFileException(e);
            return ResponseUtil.output(uploadFileException);
        }
        return null;
    }

    public byte[] combineUpload(final String fileNameKey, final int fileCount) {
        IQingFile qingFile = FileFactory.newTempFile(QingTempFileType.UPLOAD);
        try {
            qingFile.write(new IWriteCall(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void call(OutputStream outputStream) throws IOException {
                    BufferedInputStream inputStream = null;
                    try {
                        for (int i = 1; i <= fileCount; ++i) {
                            String subFileNameKey = fileNameKey + "." + i;
                            String subFileName = QingSessionUtil.get(subFileNameKey);
                            QingSessionUtil.remove(subFileNameKey);
                            IQingFileVisitor subQingFile = FileFactory.newFileVisitor(QingTempFileType.UPLOAD, subFileName);
                            inputStream = new BufferedInputStream(subQingFile.getInputStream());
                            IOUtil.copy(inputStream, outputStream);
                            CloseUtil.close(inputStream);
                        }
                    }
                    catch (Throwable throwable) {
                        CloseUtil.close(inputStream);
                        throw throwable;
                    }
                    CloseUtil.close(inputStream);
                }
            }, true);
            return ResponseUtil.output(new ResponseSuccessWrap(qingFile.getName()));
        }
        catch (IOException e) {
            UploadFileException uploadFileException = new UploadFileException(e);
            return ResponseUtil.output(uploadFileException);
        }
    }

    public void deleteFile(String fileNameKey, int typeIndex) {
        AbstractQingFileType fileType = FileTypeUtil.getInstanceByTypeIndex(typeIndex);
        IQingFileUpdater fileUpdater = FileFactory.newFileUpdater(this.qingContext, fileType, fileNameKey);
        fileUpdater.delete();
    }
}

