/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.schedule;

import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.schedule.exception.ScheduleModelParseException;
import com.kingdee.bos.qing.schedule.model.Schedule;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.quartz.TriggerUtils;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;

public abstract class AbstractScheduleEngine
implements IScheduleEngine {
    public static final String getExecuteCron(Schedule scheduleInfo) {
        int time = scheduleInfo.getTime();
        int hour = time / 3600;
        int minute = (time - hour * 3600) / 60;
        int second = (time - hour * 3600) % 60;
        switch (scheduleInfo.getPeriod()) {
            case Daily: {
                return String.format("%s %s %s * * ? *", second, minute, hour);
            }
            case Weekly: {
                String week = "*";
                if (!scheduleInfo.isWeek(127)) {
                    StringBuilder weeks = new StringBuilder();
                    int weekValue = scheduleInfo.getWeek();
                    for (int weekIndex = 1; weekIndex < 8; ++weekIndex) {
                        if ((weekValue & 1) == 1) {
                            weeks = weeks.length() == 0 ? weeks.append(weekIndex) : weeks.append(",").append(weekIndex);
                        }
                        weekValue >>>= 1;
                    }
                    week = weeks.toString();
                }
                return String.format("%s %s %s ? * %s *", second, minute, hour, week);
            }
            case Monthly: {
                int dayAtMonthly = scheduleInfo.getDay();
                String day = dayAtMonthly >= 1 ? dayAtMonthly + "" : "L";
                return String.format("%s %s %s %s * ? *", second, minute, hour, day);
            }
            case Custom: {
                return scheduleInfo.getCron();
            }
        }
        return null;
    }

    public static final List<String> cronExpression(String cronExpression) throws ParseException {
        CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
        cronTriggerImpl.setCronExpression(cronExpression);
        ArrayList<String> result = new ArrayList<String>();
        List dates = TriggerUtils.computeFireTimes((OperableTrigger)cronTriggerImpl, null, (int)5);
        if (dates != null && dates.size() > 0) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < dates.size(); ++i) {
                result.add(dateFormat.format((Date)dates.get(i)));
            }
        }
        return result;
    }

    public static final Date getFirstExecuteTime(Schedule scheduleInfo) throws ScheduleModelParseException {
        String cronExpression = AbstractScheduleEngine.getExecuteCron(scheduleInfo);
        CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
        try {
            cronTriggerImpl.setCronExpression(cronExpression);
        }
        catch (ParseException e) {
            throw new ScheduleModelParseException(e);
        }
        List dates = TriggerUtils.computeFireTimes((OperableTrigger)cronTriggerImpl, null, (int)1);
        return (Date)dates.get(0);
    }

    public static final String formateTime(int time) {
        StringBuilder sb = new StringBuilder();
        int hour = time / 3600;
        int minute = (time - hour * 3600) / 60;
        int second = (time - hour * 3600) % 60;
        if (hour == 0) {
            sb = sb.append("00");
        } else if (hour < 10) {
            sb = sb.append(0);
            sb = sb.append(hour);
        } else {
            sb = sb.append(hour);
        }
        sb = sb.append(":");
        if (minute == 0) {
            sb = sb.append("00");
        } else if (minute < 10) {
            sb = sb.append(0);
            sb = sb.append(minute);
        } else {
            sb = sb.append(minute);
        }
        sb = sb.append(":");
        if (second == 0) {
            sb = sb.append("00");
        } else if (second < 10) {
            sb = sb.append(0);
            sb = sb.append(second);
        } else {
            sb = sb.append(second);
        }
        return sb.toString();
    }
}

