/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NameUtil {
    private static Pattern p = Pattern.compile("[^A-Za-z0-9_\u4e00-\u9fa5]+");

    public static String encodeFullName(String entityName, String propertyName) {
        if (entityName == null || entityName.isEmpty()) {
            return propertyName;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(entityName);
        sb.append(".");
        sb.append(propertyName);
        return sb.toString();
    }

    public static String[] decodeFullName(String fullName) {
        String fieldPureName;
        String tableName;
        int dotIdx = fullName.indexOf(".");
        if (dotIdx == -1) {
            tableName = null;
            fieldPureName = fullName;
        } else {
            tableName = fullName.substring(0, dotIdx);
            fieldPureName = fullName.substring(dotIdx + 1);
        }
        return new String[]{tableName, fieldPureName};
    }

    private static String clearName(String name) {
        Matcher m = p.matcher(name);
        return m.replaceAll("_").trim();
    }

    public static String getPureName(String oldName, Map<String, Integer> nameRepeatTime) {
        String newName = NameUtil.clearName(oldName);
        if (nameRepeatTime != null) {
            int index;
            String checkName = newName;
            int n = index = nameRepeatTime.containsKey(checkName) ? nameRepeatTime.get(checkName) : 0;
            while (nameRepeatTime.containsKey(checkName)) {
                checkName = newName + ++index;
            }
            nameRepeatTime.put(checkName, index);
            newName = checkName;
        }
        return newName;
    }

    public static boolean isFileNameAccept(String fileName) {
        String regex = "^[\\u4e00-\\u9fa5_a-z0-9]+";
        return Pattern.matches(regex, fileName);
    }
}

