/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.service.job.core.ClusterStateManager;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.core.JobMonitor;
import com.kingdee.bos.service.job.core.JobThreadPoolManager;
import com.kingdee.bos.service.job.core.ReadyJobs;
import com.kingdee.bos.service.job.core.SchedulerEvent;
import com.kingdee.bos.service.job.core.ThreadWaiting;
import com.kingdee.bos.service.job.core.ThreadWorker;
import com.kingdee.bos.service.job.util.DbConnector;
import org.apache.log4j.Logger;

public class BOSSchedulerService {
    private static Logger logger = Logger.getLogger(BOSSchedulerService.class);
    private static volatile boolean running = false;
    private static boolean initiated = false;

    public static boolean isRunning() {
        return running;
    }

    public static synchronized void init() {
        if (initiated) {
            return;
        }
        initiated = true;
        DbConnector.registerDataCenterChangedListener(new DbConnector.DataCenterChangedListener(){

            @Override
            public void onAddnew(String dataCenter) {
                if (Configuration.transientJobOnly()) {
                    return;
                }
                ClusterStateManager.get(dataCenter);
            }
        });
        DbConnector.init();
        JobMonitor h = new JobMonitor();
        JobInstanceConfig cfg = new JobInstanceConfig((IJobHandler)h, false);
        cfg.priority = Integer.MIN_VALUE;
        Job job = new Job(null, "JobMonitor", cfg, (Object)Boolean.TRUE);
        JobManager.instance().add(job);
    }

    public static synchronized void startWorkerThread() {
        if (!Configuration.isEnable()) {
            logger.warn((Object)"Scheduler is disabled! because bosconfig.xml->scheduler->enable is false.");
            return;
        }
        if (running) {
            return;
        }
        running = true;
        ThreadWorker.startTime = System.currentTimeMillis();
        ThreadWorker.threadCount = 0;
        ThreadWorker.processedJobCount = 0L;
        ThreadWorker.usedTime = 0L;
        ThreadWorker.coreJobCount = 0L;
        ThreadWorker.coreTimeUsed = 0L;
        int j = Configuration.maximalConcurrency();
        JobThreadPoolManager.getInstance().initJobThreadPool(ReadyJobs.Queue.SmallJobs, j, j, Configuration.getKeepAliveTime(), Configuration.isAllowCoreThreadTimeOut());
        JobThreadPoolManager.getInstance().initJobThreadPool(ReadyJobs.Queue.WfJobs, j, j, Configuration.getKeepAliveTime(), Configuration.isAllowCoreThreadTimeOut());
        JobThreadPoolManager.getInstance().initJobThreadPool(ReadyJobs.Queue.BigJobs, j, j, Configuration.getKeepAliveTime(), Configuration.isAllowCoreThreadTimeOut());
        JobThreadPoolManager.getInstance().initJobThreadPool(ReadyJobs.Queue.MajorJobs, j, j, Configuration.getKeepAliveTime(), Configuration.isAllowCoreThreadTimeOut());
        Thread t = new Thread(new ThreadWaiting());
        t.setName("BGJOB_WAITING");
        t.setDaemon(true);
        t.start();
        SchedulerEvent.OnAppStart.raise(null);
    }

    public static void stopWorkerThread() {
        running = false;
    }
}

