/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ApplicationDef;
import com.kingdee.bos.workflow.define.ToolActivityDef;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.app.AbstractApplicationManager;
import com.kingdee.bos.workflow.enactment.app.WfApplicationManagerFactory;
import com.kingdee.bos.workflow.enactment.trace.WfLogger;
import com.kingdee.bos.workflow.exception.TransactionRollbackException;
import com.kingdee.bos.workflow.metas.LogTypeEnum;
import com.kingdee.bos.workflow.metas.ProcessInstEventEnum;
import com.kingdee.bos.workflow.transaction.ActivityRunner;
import com.kingdee.bos.workflow.util.WorkflowUtils;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import org.apache.log4j.Logger;

public class ToolActivityRunner
implements ActivityRunner {
    private Logger logger = Logger.getLogger(ToolActivityRunner.class);
    private WfActivity innerActivityInst;
    private ToolActivityDef innerActivityDef;

    public ToolActivityRunner(WfActivity activityInst) {
        if (activityInst == null) {
            throw new IllegalArgumentException("activityInst");
        }
        this.innerActivityInst = activityInst;
        ActivityDef activityDef = this.innerActivityInst.getDefinition();
        if (!(activityDef instanceof ToolActivityDef)) {
            throw new UnsupportedOperationException();
        }
        this.innerActivityDef = (ToolActivityDef)activityDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws WfException {
        if (ProfileConfig.getInstance().logWfEngine) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "start", null);
        }
        try {
            long time = System.currentTimeMillis();
            this.logger.debug((Object)"ToolActivityRunner.start() begin!");
            this.beginStartLog();
            ApplicationDef applicationDef = this.innerActivityDef.getRelatedApplication();
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.info((Object)("ToolActRunner start getContext cost: " + (System.currentTimeMillis() - time)));
                    time = System.currentTimeMillis();
                }
                this.invoke();
                if (this.logger.isDebugEnabled()) {
                    this.logger.info((Object)("ToolActRunner start invoke cost: " + (System.currentTimeMillis() - time)));
                    time = System.currentTimeMillis();
                }
                this.innerActivityInst.complete("");
                if (this.logger.isDebugEnabled()) {
                    this.logger.info((Object)("ToolActRunner start complete cost: " + (System.currentTimeMillis() - time)));
                    time = System.currentTimeMillis();
                }
                this.logger.debug((Object)"ToolActivityRunner.start() end!");
                this.endStartLog();
            }
            catch (TransactionRollbackException e) {
                if (applicationDef != null && applicationDef.getFunction() != null) {
                    this.logger.error((Object)("Invoke application error." + applicationDef.getFunction().getName() + " " + applicationDef.getFunction().getPackageName() + " " + applicationDef.getFunction().getOperation() + "; datacenter: " + this.innerActivityInst.getWfEngine().context().getAIS()));
                }
                throw e;
            }
            catch (Throwable e) {
                if (e instanceof WfException) {
                    throw (WfException)e;
                }
                throw new WfException("start error!", e);
            }
        }
        finally {
            if (ProfileConfig.getInstance().logWfEngine) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    public void invoke() throws WfException {
        ApplicationDef applicationDef = this.innerActivityDef.getRelatedApplication();
        AbstractApplicationManager manager = WfApplicationManagerFactory.createApplicationManager(this.innerActivityInst);
        manager.invokeApplication(applicationDef, this.innerActivityDef.getActualParameters());
    }

    private void beginStartLog() {
        try {
            WfLogger logger = WorkflowUtils.getWfLogger(this.innerActivityInst);
            if (logger == null || logger.checkLogLevel(LogTypeEnum.DEBUG)) {
                return;
            }
            String processInstId = this.innerActivityInst.container().getId();
            StringBuffer buffer = new StringBuffer();
            buffer.append("ToolActivityRunner.start() begin!");
            buffer.append("The detail is ");
            buffer.append("ProcessInstId=" + processInstId);
            buffer.append(";ActivityInstId=" + this.innerActivityInst.getId());
            String message = buffer.toString();
            logger.addWfProcessInstLog(LogTypeEnum.DEBUG, ProcessInstEventEnum.EXECUTETOOL, processInstId, message);
        }
        catch (Exception e) {
            this.logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void endStartLog() {
        try {
            WfLogger logger = WorkflowUtils.getWfLogger(this.innerActivityInst);
            if (logger == null || logger.checkLogLevel(LogTypeEnum.DEBUG)) {
                return;
            }
            String processInstId = this.innerActivityInst.container().getId();
            StringBuffer buffer = new StringBuffer();
            buffer.append("ToolActivityRunner.start() end!");
            buffer.append("The detail is ");
            buffer.append("ProcessInstId=" + processInstId);
            buffer.append(";ActivityInstId=" + this.innerActivityInst.getId());
            String message = buffer.toString();
            logger.addWfProcessInstLog(LogTypeEnum.DEBUG, ProcessInstEventEnum.EXECUTETOOL, processInstId, message);
        }
        catch (Exception e) {
            this.logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }
}

