/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment;

import com.kingdee.bos.framework.config.AISChangedEvent;
import com.kingdee.bos.framework.config.AISChangedListener;
import com.kingdee.bos.framework.config.AISDeployInfo;
import com.kingdee.bos.framework.config.SolutionDeployInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfEngine;
import org.apache.log4j.Logger;

public class WorkflowAISChangedListener
implements AISChangedListener {
    private static Logger logger = Logger.getLogger(WorkflowAISChangedListener.class);

    public void valueChanged(AISChangedEvent e) {
        if (e == null) {
            throw new IllegalArgumentException();
        }
        SolutionDeployInfo solutionDeployInfo = e.getSolutionDeployInfo();
        if (solutionDeployInfo == null) {
            throw new IllegalArgumentException();
        }
        String solutionName = solutionDeployInfo.getName();
        AISDeployInfo aisDeployInfo = e.getAisDeployInfo();
        if (aisDeployInfo == null) {
            throw new IllegalArgumentException();
        }
        String aisName = aisDeployInfo.getName();
        int type = e.getType();
        if (AISChangedEvent.ADD != type && AISChangedEvent.DELETE == type) {
            try {
                WfEngine wfEngine;
                boolean exist = WfEngine.exist(aisName, solutionName);
                if (exist && (wfEngine = WfEngine.getEngine(aisName, solutionName)) != null) {
                    wfEngine.destroy();
                }
            }
            catch (WfException exception) {
                logger.error((Object)exception);
            }
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("WorkflowAISChangedListener:");
        buffer.append(solutionName);
        buffer.append(':');
        buffer.append(aisName);
        buffer.append(':');
        buffer.append(type);
        String message = buffer.toString();
        logger.info((Object)message);
    }
}

