/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.async;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.async.OtherSysUtil;
import com.kingdee.bos.workflow.enactment.async.RpaUtil;
import com.kingdee.bos.workflow.enactment.async.YsqUtil;
import com.kingdee.bos.workflow.util.ScriptUtil;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public enum CallMode {
    HTTP{

        @Override
        public Object call(String httpUrl, Map parameterMap, WfActivity wfAact, Context ctx) throws Exception {
            return OtherSysUtil.post(httpUrl, parameterMap, null, 5000, 5000, "UTF-8");
        }
    }
    ,
    KSCRIPT{

        @Override
        public Object call(String script, Map parameterMap, WfActivity wfAact, Context ctx) throws Exception {
            logger.error((Object)"======= OtherSys KSCRIPT begin =======");
            ScriptUtil.executeScriptReturnValue(script, wfAact, parameterMap, ctx);
            logger.error((Object)"======= OtherSys KSCRIPT end =======");
            return null;
        }
    }
    ,
    OPENAPI{

        @Override
        public Object call(String address, Map parameterMap, WfActivity wfAact, Context ctx) {
            return null;
        }
    }
    ,
    WEBSERVICE{

        @Override
        public Object call(String address, Map parameterMap, WfActivity wfAact, Context ctx) {
            return ctx;
        }
    }
    ,
    RPA{

        @Override
        public Object call(String apiBaseUrl, Map parameterMap, WfActivity wfAact, Context ctx) throws Exception {
            return RpaUtil.callRpa(apiBaseUrl, parameterMap);
        }
    }
    ,
    YSQ{

        @Override
        public Object call(String apiBaseUrl, Map parameterMap, WfActivity wfAact, Context ctx) throws Exception {
            TreeMap bodyParams = (TreeMap)parameterMap.get("bodyParams");
            String serverAddress = (String)parameterMap.get("serverAddress");
            String token = YsqUtil.getYsqToken(serverAddress, (String)parameterMap.get("accessKey"), (String)parameterMap.get("secretKey"));
            String[] headerParmas = YsqUtil.getYsqTimestampAndSignature(token, bodyParams);
            return YsqUtil.callYsq(serverAddress, token, headerParmas[0], headerParmas[1], bodyParams);
        }
    }
    ,
    YSQDYNAMIC{

        @Override
        public Object call(String apiBaseUrl, Map parameterMap, WfActivity wfAact, Context ctx) throws Exception {
            return YSQ.call(apiBaseUrl, parameterMap, wfAact, ctx);
        }
    };

    private static Logger logger;

    public abstract Object call(String var1, Map var2, WfActivity var3, Context var4) throws Exception;

    static {
        logger = Logger.getLogger(CallMode.class);
    }
}

