/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.message;

import com.kingdee.bos.service.message.Connection;
import com.kingdee.bos.service.message.Destination;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.MessageConsumer;
import com.kingdee.bos.service.message.MessageException;
import com.kingdee.bos.service.message.MessageListener;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.event.WfEvent;
import java.util.Properties;
import org.apache.log4j.Logger;

public class WfMessageListener
implements MessageListener,
Runnable {
    public static boolean beReceiveFailedToRetry = true;
    public static int receiveFailedToRetryCount = 5;
    private Destination destination;
    private WfEngine engine;
    private MessageConsumer consumer;
    private Connection conn;
    private volatile Thread thread;
    private boolean bSuspended = false;
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.workflow.enactment.message.WfMessageListener");

    public WfMessageListener(WfEngine engine) {
        this.engine = engine;
        this.destination = this.engine.getMessageManager().getWfDestination();
        if (this.destination == null) {
            throw new RuntimeException("cannot get WfDestination");
        }
    }

    public void start() {
        try {
            this.conn = this.destination.getConnection(null);
            Properties prop = new Properties();
            prop.put("messageDomianPrefix", "kingdee.bos.workflow.");
            this.consumer = this.conn.createRecevier(prop);
            this.thread = new Thread((Runnable)this, "WfEngine Message Listener for " + this.engine.getEngineKey());
            this.thread.start();
        }
        catch (MessageException ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public int onMessage(Message message) {
        String domainName = message.getDomian();
        if (log.isDebugEnabled()) {
            log.debug((Object)("receive Message " + message.getBody() + " domain = '" + domainName + "'"));
        }
        if (message.getDomian().startsWith("kingdee.bos.workflow.event")) {
            WfEvent event = WfEvent.FromMessage(this.engine, message);
            this.engine.handleEvent(event);
        }
        return 1;
    }

    public synchronized void stop() {
        this.thread = null;
        this.notify();
    }

    public synchronized void suspend() {
        this.bSuspended = true;
    }

    public synchronized void resume() {
        this.bSuspended = false;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread thisThread = Thread.currentThread();
        int retryTimes = 0;
        while (thisThread == this.thread) {
            try {
                Thread.sleep(100L);
                WfMessageListener wfMessageListener = this;
                synchronized (wfMessageListener) {
                    while (this.bSuspended && this.thread == thisThread) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.onMessage(this.consumer.receive());
            }
            catch (MessageException ex) {
                if (beReceiveFailedToRetry && retryTimes < receiveFailedToRetryCount) {
                    log.warn((Object)("receive message error,retry it [" + ++retryTimes + "]"), (Throwable)ex);
                    continue;
                }
                log.warn((Object)"receive message error,stop listening", (Throwable)ex);
                this.thread = null;
                retryTimes = 0;
            }
        }
        try {
            this.consumer.close();
            this.conn.close();
        }
        catch (MessageException ex1) {
            log.warn((Object)"close  message consumer error", (Throwable)ex1);
        }
    }
}

