/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.policy;

import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.enactment.IPolicy;
import com.kingdee.bos.workflow.enactment.RuntimeSystemVariable;
import com.kingdee.bos.workflow.enactment.WfActivity;
import java.util.HashMap;

public class NextPersonPolicy
implements IPolicy {
    private static final String NEXT_PERSON_DATA_FIELD_ID = "nextPersonDataFieldID";
    private static final String NEXT_PERSON = "nextPerson";
    private WfActivity activity;
    private ActivityDef activityDef;
    private String participantId;

    public NextPersonPolicy(WfActivity activity) {
        this.activity = activity;
        this.activityDef = activity.getDefinition();
    }

    @Override
    public void excute() throws WfException {
        if (this.hasNextPerson()) {
            HashMap<String, String> participant = (HashMap<String, String>)this.activity.container().getProcessContext().getDataFieldValue(RuntimeSystemVariable.RUNTIMETACTIVITYPARTICIPANTS.getValue());
            if (participant == null) {
                participant = new HashMap<String, String>();
            }
            participant.put(this.activityDef.getPostActivities().get(0).getID(), this.participantId);
            this.activity.container().getProcessContext().putDataFieldValue(RuntimeSystemVariable.RUNTIMETACTIVITYPARTICIPANTS.getValue(), participant);
            this.activity.container().getProcessContext().storeToDb();
        }
    }

    private boolean hasNextPerson() throws WfException {
        if (this.activityDef instanceof ApproveActivityDef) {
            ApproveActivityDef approveDef = (ApproveActivityDef)this.activityDef;
            ExtendedAttributeCollection collection = approveDef.getActivityHeader().getExtendedAttributes();
            if (collection.get(NEXT_PERSON) != null && collection.get(NEXT_PERSON).getValue().equalsIgnoreCase("true")) {
                ExtendedAttributeDef exDef = approveDef.getActivityHeader().getExtendedAttributes().get(NEXT_PERSON_DATA_FIELD_ID);
                if (exDef != null) {
                    String nextPersonDataFieldID = exDef.getValue();
                    String participantName = this.activity.container().getDefinition().getDataFieldDef(nextPersonDataFieldID).getName();
                    if (this.activity.container().getProcessContext().getDataFieldValue(participantName) != null) {
                        this.participantId = this.activity.container().getProcessContext().getDataFieldValue(participantName).toString();
                        return true;
                    }
                }
                return false;
            }
            return false;
        }
        return false;
    }
}

