/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.enactment.thread;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONMap;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.workflow.enactment.thread.FinanceShareReq;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.metas.IInvokeMethodDelegate;
import com.kingdee.bos.workflow.metas.InvokeMethodDelegateFactory;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.transaction.SnapshotRecorder;
import com.kingdee.eas.base.message.webservice.WebServiceSscLogUtil;
import com.kingdee.eas.base.message.webservice.WriteServiceLogReq;
import com.kingdee.eas.base.wssc.CallSSCInterfaceFacadeFactory;
import com.kingdee.eas.base.wssc.app.trd.webservice.WebServiceConfig;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ShareFinanceRunner
implements IJobHandler {
    private static final Logger logger = Logger.getLogger(ShareFinanceRunner.class);
    private FinanceShareReq financeShareReq;

    public ShareFinanceRunner(FinanceShareReq financeShareReq) {
        this.financeShareReq = financeShareReq;
    }

    public Object execute(Job job) throws Exception {
        this.financeShare(this.financeShareReq);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void financeShare(FinanceShareReq financeShareReq) throws BOSException {
        if (financeShareReq == null) {
            logger.error((Object)"financeShareReq is null,cannot invoke financeshare!!");
            return;
        }
        long startTime = System.currentTimeMillis();
        try {
            Context ctx = new Context((IObjectPK)new ObjectUuidPK(), financeShareReq.getSolution(), financeShareReq.getDataCenter(), new Locale("l2"));
            EnactmentServiceProxy service = new EnactmentServiceProxy(ctx);
            boolean result = false;
            String serviceUrl = WebServiceConfig.getPropertiesValue((Context)ctx, null, (String)"createShareTaskWebServiceUrl");
            String createTaskMethodName = WebServiceConfig.getPropertiesValue((Context)ctx, null, (String)"createTaskMethodName");
            String shareCenterParamMapVarableName = WebServiceConfig.getPropertiesValue((Context)ctx, null, (String)"createTaskProcessVarableName");
            logger.info((Object)("com.kingdee.bos.workflow.AssignReadListenerExt shareCenterParamMapVarableName:" + shareCenterParamMapVarableName + " serviceUrl:" + serviceUrl + " createTaskMethodName:" + createTaskMethodName));
            Object obj = service.getProcessContext(financeShareReq.getProcInstId(), shareCenterParamMapVarableName);
            HashMap map = null;
            boolean isTaskCenter = false;
            boolean isNode = false;
            if (obj != null && obj instanceof HashMap) {
                map = (HashMap)obj;
                if (map.get("isTaskCenter") != null) {
                    isTaskCenter = (Boolean)map.get("isTaskCenter");
                }
                if (map.get("isNode") != null) {
                    isNode = (Boolean)map.get("isNode");
                }
            }
            logger.info((Object)("com.kingdee.bos.workflow.AssignReadListenerExt isTaskCenter:" + isTaskCenter + " isNode:" + isNode));
            if (!isTaskCenter) return;
            if (!isNode) return;
            this.makeMap(financeShareReq, map);
            JSONMap json = null;
            String param = null;
            String errorStack = "";
            String subject = map.get("subject") == null ? "" : map.get("subject").toString();
            json = new JSONMap((Map)map);
            param = json.toString();
            try {
                if (StringUtils.isEmpty((String)createTaskMethodName)) throw new NullPointerException("createTaskMethodName is null");
                result = CallSSCInterfaceFacadeFactory.getLocalInstance((Context)ctx).creatAssignment(param);
                logger.info((Object)("com.kingdee.eas.base.message.app.FinanceShareHandler createShareTask webservice return:" + result));
                if (result) {
                    SnapshotRecorder recorder = SnapshotRecorder.create();
                    AssignInfo info = financeShareReq.getAssignInfo();
                    info.setIsSendMsg(false);
                    recorder.snapshoot((AbstractObjectValue)info);
                    recorder.recordSnapshots();
                    map.put("isPhotoCopy", Boolean.FALSE);
                    map.put("isNode", Boolean.FALSE);
                    service.setProcessContext(financeShareReq.getProcInstId(), shareCenterParamMapVarableName, (Object)map);
                }
                long endTime = System.currentTimeMillis();
                logger.info((Object)("*************!@#**********billId=" + financeShareReq.getBillId() + "\ttime=" + (endTime - startTime) / 1000L + "s\t" + (endTime - startTime) + "ms"));
            }
            catch (Exception e) {
                try {
                    errorStack = WebServiceSscLogUtil.exceptionToString((Exception)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        IInvokeMethodDelegate delegate = InvokeMethodDelegateFactory.getLocalInstance((Context)ctx);
                        delegate.invokeRequiresNew("com.kingdee.eas.base.message.webservice.WebServiceSscLogUtil", (Object)this, "writeServiceLog", new Class[]{WriteServiceLogReq.class}, new Object[]{new WriteServiceLogReq(ctx, financeShareReq.getAssignId(), financeShareReq.getBillId(), serviceUrl + "&" + createTaskMethodName, param, String.valueOf(result), subject, result, errorStack, 0L, "11", null)});
                        throw throwable;
                    }
                    catch (Throwable e2) {
                        logger.error((Object)("saveLogInNewTransaction catch ex:" + e2), e2);
                    }
                    throw throwable;
                }
            }
            try {
                IInvokeMethodDelegate delegate = InvokeMethodDelegateFactory.getLocalInstance((Context)ctx);
                delegate.invokeRequiresNew("com.kingdee.eas.base.message.webservice.WebServiceSscLogUtil", (Object)this, "writeServiceLog", new Class[]{WriteServiceLogReq.class}, new Object[]{new WriteServiceLogReq(ctx, financeShareReq.getAssignId(), financeShareReq.getBillId(), serviceUrl + "&" + createTaskMethodName, param, String.valueOf(result), subject, result, errorStack, 0L, "11", null)});
                return;
            }
            catch (Throwable e) {
                logger.error((Object)("saveLogInNewTransaction catch ex:" + e), e);
                return;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void makeMap(FinanceShareReq financeShareReq, HashMap map) {
        map.put("solution", financeShareReq.getSolution());
        map.put("dataCenter", financeShareReq.getDataCenter());
        map.put("assignId", financeShareReq.getAssignId());
        map.put("procInstId", financeShareReq.getProcInstId());
        map.put("billId", financeShareReq.getBillId());
    }
}

